/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.GradientStop;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.android.ide.common.vectordrawable.VdPath;
import com.android.ide.common.vectordrawable.VdUtil;
import com.android.utils.DecimalUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

class SvgGradientNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private final ArrayList<GradientStop> myGradientStops = new ArrayList();
    private SvgLeafNode mSvgLeafNode;
    private Rectangle2D boundingBox;
    private GradientUsage mGradientUsage;
    private static final ImmutableMap<String, Integer> vectorCoordinateMap = ImmutableMap.builder().put((Object)"x1", (Object)0).put((Object)"y1", (Object)1).put((Object)"x2", (Object)2).put((Object)"y2", (Object)3).build();

    SvgGradientNode(SvgTree svgTree, Element element, String nodeName) {
        super(svgTree, element, nodeName);
    }

    @Override
    public SvgGradientNode deepCopy() {
        SvgGradientNode newInstance = new SvgGradientNode(this.getTree(), this.mDocumentElement, this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    protected void copyFrom(SvgGradientNode from) {
        super.copyFrom(from);
        for (GradientStop g : from.myGradientStops) {
            this.addGradientStop(g.getColor(), g.getOffset(), g.getOpacity());
        }
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current gradient is :" + this.getName());
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        AffineTransform finalTransform = new AffineTransform(rootTransform);
        finalTransform.concatenate(this.mStackedTransform);
    }

    @Override
    public void flatten(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
    }

    private GradientCoordResult getGradientCoordinate(String x, double defaultValue) {
        if (!this.mVdAttributesMap.containsKey(x)) {
            return new GradientCoordResult(defaultValue, false);
        }
        double val = defaultValue;
        String vdValue = ((String)this.mVdAttributesMap.get(x)).trim();
        if (x.equals("r") && vdValue.startsWith("-")) {
            return new GradientCoordResult(defaultValue, false);
        }
        boolean isPercentage = false;
        try {
            if (vdValue.endsWith("%")) {
                val = Double.parseDouble(vdValue.substring(0, vdValue.length() - 1)) / 100.0;
                isPercentage = true;
            } else {
                val = Double.parseDouble(vdValue);
            }
        }
        catch (NumberFormatException e) {
            this.logError("Unsupported coordinate value");
        }
        return new GradientCoordResult(val, isPercentage);
    }

    @Override
    public void writeXml(OutputStreamWriter writer, boolean inClipPath, String indent) throws IOException {
        double[] transformedBounds;
        double[] gradientBounds;
        if (this.myGradientStops.isEmpty()) {
            this.logError("Gradient has no stop info");
            return;
        }
        writer.write(indent);
        if (this.mGradientUsage == GradientUsage.FILL) {
            writer.write("<aapt:attr name=\"android:fillColor\">");
        } else {
            writer.write("<aapt:attr name=\"android:strokeColor\">");
        }
        writer.write(System.lineSeparator());
        writer.write(indent);
        writer.write("  ");
        writer.write("<gradient ");
        this.setBoundingBox();
        double height = this.boundingBox.getHeight();
        double width = this.boundingBox.getWidth();
        double startX = this.boundingBox.getX();
        double startY = this.boundingBox.getY();
        String gradientUnit = (String)this.mVdAttributesMap.get("gradientUnits");
        boolean isUserSpaceOnUse = "userSpaceOnUse".equals(gradientUnit);
        if (isUserSpaceOnUse) {
            startX = 0.0;
            startY = 0.0;
            height = this.getTree().getHeight();
            width = this.getTree().getWidth();
        }
        AffineTransform identity = new AffineTransform();
        if (this.mVdAttributesMap.containsKey("gradientTransform")) {
            String transformValue = (String)this.mVdAttributesMap.get("gradientTransform");
            this.parseLocalTransform(transformValue);
            if (!isUserSpaceOnUse) {
                identity.scale(1.0 / width, 1.0 / height);
                this.mLocalTransform.concatenate(identity);
                identity.setToIdentity();
                identity.scale(width, height);
                this.mLocalTransform.preConcatenate(identity);
            }
        }
        if (isUserSpaceOnUse) {
            this.mLocalTransform.preConcatenate(this.mSvgLeafNode.mStackedTransform);
        }
        String gradientType = "linear";
        if (this.mVdAttributesMap.containsKey("gradientType")) {
            gradientType = (String)this.mVdAttributesMap.get("gradientType");
        }
        if (gradientType.equals("linear")) {
            gradientBounds = new double[4];
            transformedBounds = new double[4];
            for (Map.Entry entry : vectorCoordinateMap.entrySet()) {
                String s = (String)entry.getKey();
                int index = (Integer)entry.getValue();
                double defaultValue = 0.0;
                if (index == 2) {
                    defaultValue = 1.0;
                }
                GradientCoordResult result2 = this.getGradientCoordinate(s, defaultValue);
                double coordValue = result2.getValue();
                if (!isUserSpaceOnUse || result2.isPercentage()) {
                    coordValue = index % 2 == 0 ? coordValue * width + startX : coordValue * height + startY;
                }
                gradientBounds[index] = coordValue;
                transformedBounds[index] = coordValue;
                if (this.mVdAttributesMap.containsKey(s)) continue;
                this.mVdAttributesMap.put(s, "");
            }
            this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 2);
        } else {
            gradientBounds = new double[2];
            transformedBounds = new double[2];
            GradientCoordResult cxResult = this.getGradientCoordinate("cx", 0.5);
            double d = cxResult.getValue();
            if (!isUserSpaceOnUse || cxResult.isPercentage()) {
                d = width * d + startX;
            }
            GradientCoordResult cyResult = this.getGradientCoordinate("cy", 0.5);
            double cy = cyResult.getValue();
            if (!isUserSpaceOnUse || cyResult.isPercentage()) {
                cy = height * cy + startY;
            }
            GradientCoordResult rResult = this.getGradientCoordinate("r", 0.5);
            double r = rResult.getValue();
            if (!isUserSpaceOnUse || rResult.isPercentage()) {
                r *= Math.max(height, width);
            }
            gradientBounds[0] = d;
            transformedBounds[0] = d;
            gradientBounds[1] = cy;
            transformedBounds[1] = cy;
            this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 1);
            Point2D.Double radius = new Point2D.Double(r, 0.0);
            Point2D.Double transformedRadius = new Point2D.Double(r, 0.0);
            this.mLocalTransform.deltaTransform(radius, transformedRadius);
            this.mVdAttributesMap.put("cx", XmlUtils.formatFloatAttribute((double)transformedBounds[0]));
            this.mVdAttributesMap.put("cy", XmlUtils.formatFloatAttribute((double)transformedBounds[1]));
            this.mVdAttributesMap.put("r", XmlUtils.formatFloatAttribute((double)transformedRadius.distance(0.0, 0.0)));
        }
        for (Map.Entry entry : this.mVdAttributesMap.entrySet()) {
            String key = (String)entry.getKey();
            String gradientAttr = (String)Svg2Vector.gradientMap.get((Object)key);
            String svgValue = ((String)entry.getValue()).trim();
            String vdValue = this.colorSvg2Vd(svgValue, "#000000");
            if (vdValue == null) {
                if (vectorCoordinateMap.containsKey((Object)key)) {
                    double x = transformedBounds[(Integer)vectorCoordinateMap.get((Object)key)];
                    vdValue = XmlUtils.formatFloatAttribute((double)x);
                } else if (key.equals("spreadMethod")) {
                    if (svgValue.equals("pad")) {
                        vdValue = "clamp";
                    } else if (svgValue.equals("reflect")) {
                        vdValue = "mirror";
                    } else if (svgValue.equals("repeat")) {
                        vdValue = "repeat";
                    } else {
                        this.logError("Unsupported spreadMethod " + svgValue);
                        vdValue = "clamp";
                    }
                } else {
                    vdValue = svgValue.endsWith("%") ? XmlUtils.formatFloatAttribute((double)this.getGradientCoordinate(key, 0.0).getValue()) : svgValue;
                }
            }
            if (gradientAttr.isEmpty()) continue;
            writer.write(System.lineSeparator());
            writer.write(indent);
            writer.write("  ");
            writer.write("    ");
            writer.write(gradientAttr);
            writer.write("=\"");
            writer.write(vdValue);
            writer.write("\"");
        }
        writer.write(62);
        writer.write(System.lineSeparator());
        this.writeGradientStops(writer, indent + "  " + "  ");
        writer.write(indent);
        writer.write("  ");
        writer.write("</gradient>");
        writer.write(System.lineSeparator());
        writer.write(indent);
        writer.write("</aapt:attr>");
        writer.write(System.lineSeparator());
    }

    private void writeGradientStops(OutputStreamWriter writer, String indent) throws IOException {
        for (GradientStop g : this.myGradientStops) {
            float opacity;
            String color = g.getColor();
            try {
                opacity = Float.parseFloat(g.getOpacity());
            }
            catch (NumberFormatException e) {
                this.logWarning("Unsupported opacity value");
                opacity = 1.0f;
            }
            int color1 = VdPath.applyAlpha(VdUtil.parseColorValue(color), opacity);
            color = String.format("#%08X", color1);
            writer.write(indent);
            writer.write("<item android:offset=\"");
            writer.write(DecimalUtils.trimInsignificantZeros((String)g.getOffset()));
            writer.write("\"");
            writer.write(" android:color=\"");
            writer.write(color);
            writer.write("\"/>");
            writer.write(System.lineSeparator());
            if (this.myGradientStops.size() != 1) continue;
            this.logWarning("Gradient has only one color stop");
            writer.write(indent);
            writer.write("<item android:offset=\"1\"");
            writer.write(" android:color=\"");
            writer.write(color);
            writer.write("\"/>");
            writer.write(System.lineSeparator());
        }
    }

    public void addGradientStop(String color, String offset, String opacity) {
        GradientStop stop = new GradientStop(color, offset);
        stop.setOpacity(opacity);
        this.myGradientStops.add(stop);
    }

    public void setGradientUsage(GradientUsage gradientUsage) {
        this.mGradientUsage = gradientUsage;
    }

    public void setSvgLeafNode(SvgLeafNode svgLeafNode) {
        this.mSvgLeafNode = svgLeafNode;
    }

    private void setBoundingBox() {
        Path2D.Double svgPath = new Path2D.Double();
        VdPath.Node[] nodes = PathParser.parsePath(this.mSvgLeafNode.getPathData());
        VdNodeRender.createPath(nodes, svgPath);
        this.boundingBox = svgPath.getBounds2D();
    }

    protected static enum GradientUsage {
        FILL,
        STROKE;

    }

    private static class GradientCoordResult {
        private final double mValue;
        private final boolean mIsPercentage;

        GradientCoordResult(double value, boolean isPercentage) {
            this.mValue = value;
            this.mIsPercentage = isPercentage;
        }

        double getValue() {
            return this.mValue;
        }

        boolean isPercentage() {
            return this.mIsPercentage;
        }
    }
}

