/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeFile;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public final class IdeNativeFile
implements NativeFile,
Serializable {
    private final File myFilePath;
    private final String mySettingsName;
    private final File myWorkingDirectory;
    private final int myHashCode;

    public IdeNativeFile() {
        this.myFilePath = null;
        this.mySettingsName = "";
        this.myWorkingDirectory = null;
        this.myHashCode = 0;
    }

    public IdeNativeFile(NativeFile file) {
        this.myFilePath = file.getFilePath();
        this.mySettingsName = file.getSettingsName();
        this.myWorkingDirectory = file.getWorkingDirectory();
        this.myHashCode = this.calculateHashCode();
    }

    public File getFilePath() {
        return this.myFilePath;
    }

    public String getSettingsName() {
        return this.mySettingsName;
    }

    public File getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeFile)) {
            return false;
        }
        IdeNativeFile file = (IdeNativeFile)o;
        return Objects.equals(this.myFilePath, file.myFilePath) && Objects.equals(this.mySettingsName, file.mySettingsName) && Objects.equals(this.myWorkingDirectory, file.myWorkingDirectory);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myFilePath, this.mySettingsName, this.myWorkingDirectory);
    }

    public String toString() {
        return "IdeNativeFile{myFilePath=" + this.myFilePath + ", mySettingsName='" + this.mySettingsName + '\'' + ", myWorkingDirectory=" + this.myWorkingDirectory + "}";
    }
}

