/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeLibraries;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.BuildFolderPaths;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.gradle.model.level2.IdeDependenciesImpl;
import com.android.ide.common.gradle.model.level2.IdeLibraryFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IdeDependenciesFactory {
    private final Map<String, Library> myLibrariesById = new HashMap<String, Library>();
    private final IdeLibraryFactory myLibraryFactory = new IdeLibraryFactory();
    private final BuildFolderPaths myBuildFolderPaths = new BuildFolderPaths();

    public void findAndAddBuildFolderPath(String buildId, String moduleGradlePath, File buildFolder) {
        this.myBuildFolderPaths.addBuildFolderMapping(buildId, moduleGradlePath, buildFolder);
    }

    public void setRootBuildId(String rootBuildId) {
        this.myBuildFolderPaths.setRootBuildId(rootBuildId);
    }

    public IdeDependencies create(BaseArtifact artifact, GradleVersion modelVersion) {
        ModelCache modelCache = new ModelCache();
        if (modelVersion != null && modelVersion.getMajor() >= 3 && !artifact.getDependencyGraphs().getCompileDependencies().isEmpty()) {
            return this.createFromDependencyGraphs(artifact.getDependencyGraphs());
        }
        return this.createFromDependencies(artifact.getDependencies());
    }

    @VisibleForTesting
    public IdeDependencies createFromDependencyGraphs(DependencyGraphs graphs) {
        return this.createInstance(graphs.getCompileDependencies().stream().map(GraphItem::getArtifactAddress).collect(Collectors.toList()), Collections.emptyList());
    }

    private IdeDependencies createFromDependencies(Dependencies dependencies) {
        List<File> jars;
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        this.populateAndroidLibraries(dependencies.getLibraries(), visited);
        this.populateJavaLibraries(dependencies.getJavaLibraries(), visited);
        this.populateModuleDependencies(dependencies, visited);
        try {
            jars = dependencies.getRuntimeOnlyClasses();
        }
        catch (UnsupportedOperationException e) {
            jars = Collections.emptyList();
        }
        return this.createInstance(visited, jars);
    }

    private void populateModuleDependencies(Dependencies dependencies, Set<String> visited) {
        try {
            for (Dependencies.ProjectIdentifier identifier : dependencies.getJavaModules()) {
                this.createModuleLibrary(visited, identifier.getProjectPath(), IdeLibraries.computeAddress(identifier), identifier.getBuildId());
            }
        }
        catch (UnsupportedOperationException ignored) {
            for (String projectPath : dependencies.getProjects()) {
                this.createModuleLibrary(visited, projectPath, projectPath, null);
            }
        }
    }

    private void createModuleLibrary(Set<String> visited, String projectPath, String artifactAddress, String buildId) {
        if (!visited.contains(artifactAddress)) {
            visited.add(artifactAddress);
            this.myLibrariesById.computeIfAbsent(artifactAddress, id -> IdeLibraryFactory.create(projectPath, artifactAddress, buildId));
        }
    }

    private void populateAndroidLibraries(Collection<? extends AndroidLibrary> androidLibraries, Set<String> visited) {
        for (AndroidLibrary androidLibrary : androidLibraries) {
            String address = IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary);
            if (visited.contains(address)) continue;
            visited.add(address);
            this.myLibrariesById.computeIfAbsent(address, id -> this.myLibraryFactory.create(androidLibrary, this.myBuildFolderPaths));
            this.populateAndroidLibraries(androidLibrary.getLibraryDependencies(), visited);
            this.populateJavaLibraries(IdeDependenciesFactory.getJavaDependencies(androidLibrary), visited);
        }
    }

    private static Collection<? extends JavaLibrary> getJavaDependencies(AndroidLibrary androidLibrary) {
        try {
            return androidLibrary.getJavaDependencies();
        }
        catch (UnsupportedOperationException e) {
            return Collections.emptyList();
        }
    }

    private void populateJavaLibraries(Collection<? extends JavaLibrary> javaLibraries, Set<String> visited) {
        for (JavaLibrary javaLibrary : javaLibraries) {
            String address = IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary);
            if (visited.contains(address)) continue;
            visited.add(address);
            this.myLibrariesById.computeIfAbsent(address, k -> this.myLibraryFactory.create(javaLibrary));
            this.populateJavaLibraries(javaLibrary.getDependencies(), visited);
        }
    }

    private IdeDependencies createInstance(Collection<String> artifactAddresses, Collection<File> runtimeOnlyJars) {
        ImmutableList.Builder androidLibraries = ImmutableList.builder();
        ImmutableList.Builder javaLibraries = ImmutableList.builder();
        ImmutableList.Builder moduleDependencies = ImmutableList.builder();
        block5: for (String address : artifactAddresses) {
            Library library = this.myLibrariesById.get(address);
            assert (library != null);
            switch (library.getType()) {
                case 1: {
                    androidLibraries.add((Object)library);
                    continue block5;
                }
                case 2: {
                    javaLibraries.add((Object)library);
                    continue block5;
                }
                case 3: {
                    moduleDependencies.add((Object)library);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown library type " + library.getType());
        }
        return new IdeDependenciesImpl((ImmutableList<Library>)androidLibraries.build(), (ImmutableList<Library>)javaLibraries.build(), (ImmutableList<Library>)moduleDependencies.build(), (ImmutableList<File>)ImmutableList.copyOf(runtimeOnlyJars));
    }

    public void setUpGlobalLibraryMap(List<GlobalLibraryMap> globalLibraryMaps) {
        for (GlobalLibraryMap globalLibraryMap : globalLibraryMaps) {
            for (Library library : globalLibraryMap.getLibraries().values()) {
                this.myLibrariesById.computeIfAbsent(library.getArtifactAddress(), k -> this.myLibraryFactory.create(library));
            }
        }
    }
}

