/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.level2.GraphItem;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class IdeGraphItem
implements GraphItem,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myArtifactAddress;
    private final List<GraphItem> myDependencies;
    private final String myRequestedCoordinates;
    private final int myHashCode;

    public IdeGraphItem() {
        this.myArtifactAddress = "";
        this.myDependencies = Collections.emptyList();
        this.myRequestedCoordinates = null;
        this.myHashCode = 0;
    }

    public IdeGraphItem(GraphItem item, ModelCache modelCache) {
        this.myArtifactAddress = item.getArtifactAddress();
        this.myDependencies = IdeModel.copy(item.getDependencies(), modelCache, item1 -> new IdeGraphItem((GraphItem)item1, modelCache));
        this.myRequestedCoordinates = item.getRequestedCoordinates();
        this.myHashCode = this.calculateHashCode();
    }

    public String getArtifactAddress() {
        return this.myArtifactAddress;
    }

    public List<GraphItem> getDependencies() {
        return this.myDependencies;
    }

    public String getRequestedCoordinates() {
        return this.myRequestedCoordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeGraphItem)) {
            return false;
        }
        IdeGraphItem item = (IdeGraphItem)o;
        return Objects.equals(this.myArtifactAddress, item.myArtifactAddress) && Objects.equals(this.myDependencies, item.myDependencies) && Objects.equals(this.myRequestedCoordinates, item.myRequestedCoordinates);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myArtifactAddress, this.myDependencies, this.myRequestedCoordinates);
    }

    public String toString() {
        return "IdeGraphItem{myArtifactAddress='" + this.myArtifactAddress + '\'' + ", myDependencies=" + this.myDependencies + ", myRequestedCoordinates='" + this.myRequestedCoordinates + '\'' + '}';
    }
}

