/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.level2;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class IdeDependenciesImpl
implements IdeDependencies,
Serializable {
    private static final long serialVersionUID = 3L;
    private final Collection<Library> myAndroidLibraries;
    private final Collection<Library> myJavaLibraries;
    private final Collection<Library> myModuleDependencies;
    private final Collection<File> myRuntimeOnlyClasses;
    private final int myHashCode;

    public IdeDependenciesImpl() {
        this.myAndroidLibraries = Collections.emptyList();
        this.myJavaLibraries = Collections.emptyList();
        this.myModuleDependencies = Collections.emptyList();
        this.myRuntimeOnlyClasses = Collections.emptyList();
        this.myHashCode = 0;
    }

    IdeDependenciesImpl(ImmutableList<Library> androidLibraries, ImmutableList<Library> javaLibraries, ImmutableList<Library> moduleDependencies, ImmutableList<File> runtimeOnlyClasses) {
        this.myAndroidLibraries = androidLibraries;
        this.myJavaLibraries = javaLibraries;
        this.myModuleDependencies = moduleDependencies;
        this.myRuntimeOnlyClasses = runtimeOnlyClasses;
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public Collection<Library> getAndroidLibraries() {
        return this.myAndroidLibraries;
    }

    @Override
    public Collection<Library> getJavaLibraries() {
        return this.myJavaLibraries;
    }

    @Override
    public Collection<Library> getModuleDependencies() {
        return this.myModuleDependencies;
    }

    @Override
    public Collection<File> getRuntimeOnlyClasses() {
        return this.myRuntimeOnlyClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependenciesImpl)) {
            return false;
        }
        IdeDependenciesImpl item = (IdeDependenciesImpl)o;
        return Objects.equals(this.myAndroidLibraries, item.myAndroidLibraries) && Objects.equals(this.myJavaLibraries, item.myJavaLibraries) && Objects.equals(this.myModuleDependencies, item.myModuleDependencies) && Objects.equals(this.myRuntimeOnlyClasses, item.myRuntimeOnlyClasses);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myAndroidLibraries, this.myJavaLibraries, this.myModuleDependencies, this.myRuntimeOnlyClasses);
    }

    public String toString() {
        return "IdeDependenciesImpl{myAndroidLibraries=" + this.myAndroidLibraries + ", myJavaLibraries=" + this.myJavaLibraries + ", myModuleDependencies=" + this.myModuleDependencies + ", myRuntimeOnlyClasses=" + this.myRuntimeOnlyClasses + '}';
    }
}

