/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SplitOutputMatcher {
    public static List<File> computeBestOutputs(DeviceConfigProvider deviceConfigProvider, Collection<IdeAndroidArtifactOutput> outputs, Collection<String> variantAbiFilters) {
        ArrayList<File> apkFiles = new ArrayList<File>();
        List<IdeAndroidArtifactOutput> outputFiles = SplitOutputMatcher.computeBestOutput(outputs, variantAbiFilters, deviceConfigProvider.getAbis());
        for (IdeAndroidArtifactOutput outputFile : outputFiles) {
            apkFiles.add(outputFile.getOutputFile());
        }
        return apkFiles;
    }

    public static List<IdeAndroidArtifactOutput> computeBestOutput(Collection<IdeAndroidArtifactOutput> outputs, Collection<String> variantAbiFilters, List<String> deviceAbis) {
        ArrayList matches = Lists.newArrayList();
        for (IdeAndroidArtifactOutput variantOutput : outputs) {
            String abiFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.ABI);
            if (abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(variantOutput);
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        IdeAndroidArtifactOutput match2 = (IdeAndroidArtifactOutput)Collections.max(matches, (splitOutput, splitOutput2) -> {
            int rc = splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            if (rc != 0) {
                return rc;
            }
            int abiOrder1 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput, deviceAbis);
            int abiOrder2 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput2, deviceAbis);
            return abiOrder1 - abiOrder2;
        });
        return SplitOutputMatcher.isMainApkCompatibleWithDevice(match2, variantAbiFilters, deviceAbis) ? ImmutableList.of((Object)match2) : ImmutableList.of();
    }

    private static int getAbiPreferenceOrder(IdeAndroidArtifactOutput variantOutput, List<String> deviceAbi) {
        String abiFilter = SplitOutputMatcher.getFilter(variantOutput, IdeAndroidArtifactOutput.ABI);
        if (Strings.isNullOrEmpty((String)abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match2 = deviceAbi.indexOf(abiFilter);
        if (match2 == 0) {
            match2 = deviceAbi.size();
        } else if (match2 > 0) {
            match2 = deviceAbi.size() - match2 - 1;
        }
        return match2;
    }

    private static boolean isMainApkCompatibleWithDevice(IdeAndroidArtifactOutput mainOutputFile, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, IdeAndroidArtifactOutput.ABI) == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String getFilter(IdeAndroidArtifactOutput variantOutput, String filterType) {
        for (FilterData filterData : variantOutput.getFilters()) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }
}

