/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.impl.ndk.v1;

import com.android.ide.common.gradle.model.ndk.v1.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.ndk.v1.IdeNativeArtifact;
import com.android.ide.common.gradle.model.ndk.v1.IdeNativeSettings;
import com.android.ide.common.gradle.model.ndk.v1.IdeNativeToolchain;
import com.android.ide.common.gradle.model.ndk.v1.IdeNativeVariantInfo;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class IdeNativeAndroidProjectImpl
implements IdeNativeAndroidProject,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myModelVersion;
    private final String myName;
    private final List<File> myBuildFiles;
    private final Map<String, IdeNativeVariantInfo> myVariantInfos;
    private final Collection<IdeNativeArtifact> myArtifacts;
    private final Collection<IdeNativeToolchain> myToolChains;
    private final Collection<IdeNativeSettings> mySettings;
    private final Map<String, String> myFileExtensions;
    private final Collection<String> myBuildSystems;
    private final String myDefaultNdkVersion;
    private final int myApiVersion;
    private final int myHashCode;

    public IdeNativeAndroidProjectImpl() {
        this.myModelVersion = "";
        this.myName = "";
        this.myBuildFiles = Collections.emptyList();
        this.myVariantInfos = Collections.emptyMap();
        this.myArtifacts = Collections.emptyList();
        this.myToolChains = Collections.emptyList();
        this.mySettings = Collections.emptyList();
        this.myFileExtensions = Collections.emptyMap();
        this.myBuildSystems = Collections.emptyList();
        this.myDefaultNdkVersion = "";
        this.myApiVersion = 0;
        this.myHashCode = 0;
    }

    public IdeNativeAndroidProjectImpl(String modelVersion, int apiVersion, String name, List<File> buildFiles, Map<String, IdeNativeVariantInfo> variantInfos, List<IdeNativeArtifact> artifacts2, List<IdeNativeToolchain> toolChains, List<IdeNativeSettings> settings, Map<String, String> fileExtensions, String defaultNdkVersion, List<String> buildSystems) {
        this.myModelVersion = modelVersion;
        this.myApiVersion = apiVersion;
        this.myName = name;
        this.myBuildFiles = buildFiles;
        this.myVariantInfos = variantInfos;
        this.myArtifacts = artifacts2;
        this.myToolChains = toolChains;
        this.mySettings = settings;
        this.myFileExtensions = fileExtensions;
        this.myDefaultNdkVersion = defaultNdkVersion;
        this.myBuildSystems = buildSystems;
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public String getModelVersion() {
        return this.myModelVersion;
    }

    @Override
    public int getApiVersion() {
        return this.myApiVersion;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Map<String, IdeNativeVariantInfo> getVariantInfos() {
        return this.myVariantInfos;
    }

    @Override
    public Collection<File> getBuildFiles() {
        return this.myBuildFiles;
    }

    @Override
    public Collection<IdeNativeArtifact> getArtifacts() {
        return this.myArtifacts;
    }

    @Override
    public Collection<IdeNativeToolchain> getToolChains() {
        return this.myToolChains;
    }

    @Override
    public Collection<IdeNativeSettings> getSettings() {
        return this.mySettings;
    }

    @Override
    public Map<String, String> getFileExtensions() {
        return this.myFileExtensions;
    }

    @Override
    public Collection<String> getBuildSystems() {
        return this.myBuildSystems;
    }

    @Override
    public String getDefaultNdkVersion() {
        if (this.myDefaultNdkVersion != null) {
            return this.myDefaultNdkVersion;
        }
        throw new UnsupportedOperationException("Unsupported method: NativeAndroidProject.getDefaultNdkVersion()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeAndroidProjectImpl)) {
            return false;
        }
        IdeNativeAndroidProjectImpl project = (IdeNativeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myBuildFiles, project.myBuildFiles) && Objects.equals(this.myVariantInfos, project.myVariantInfos) && Objects.equals(this.myArtifacts, project.myArtifacts) && Objects.equals(this.myToolChains, project.myToolChains) && Objects.equals(this.mySettings, project.mySettings) && Objects.equals(this.myFileExtensions, project.myFileExtensions) && Objects.equals(this.myBuildSystems, project.myBuildSystems) && Objects.equals(this.myDefaultNdkVersion, project.myDefaultNdkVersion);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myName, this.myBuildFiles, this.myVariantInfos, this.myArtifacts, this.myToolChains, this.mySettings, this.myFileExtensions, this.myBuildSystems, this.myApiVersion, this.myDefaultNdkVersion);
    }

    public String toString() {
        return "IdeNativeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myBuildFiles=" + this.myBuildFiles + ", myArtifacts=" + this.myArtifacts + ", myToolChains=" + this.myToolChains + ", mySettings=" + this.mySettings + ", myFileExtensions=" + this.myFileExtensions + ", myBuildSystems=" + this.myBuildSystems + ", myApiVersion=" + this.myApiVersion + ", myDefaultNdkVersion=" + this.myDefaultNdkVersion + "}";
    }
}

