/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ResourceVisibilityLookup {
    public static final ResourceVisibilityLookup NONE = new ResourceVisibilityLookup(){

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            return false;
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            return false;
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            return false;
        }

        @Override
        public String getPrivateIn(ResourceType type, String name) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    public abstract boolean isPrivate(ResourceType var1, String var2);

    public abstract boolean isPublic(ResourceType var1, String var2);

    protected abstract boolean isKnown(ResourceType var1, String var2);

    public boolean isPrivate(ResourceUrl url) {
        assert (!url.isFramework());
        return this.isPrivate(url.type, url.name);
    }

    public abstract String getPrivateIn(ResourceType var1, String var2);

    public abstract boolean isEmpty();

    public static ResourceVisibilityLookup create(File publicResources, File allResources, String mapKey) {
        return new LibraryResourceVisibility(publicResources, allResources, mapKey);
    }

    public static ResourceVisibilityLookup create(List<ResourceVisibilityLookup> libraries) {
        if (libraries.size() == 1) {
            return libraries.get(0);
        }
        return new MultipleLibraryResourceVisibility(libraries);
    }

    public static ResourceVisibilityLookup create(IdeLibrary library) {
        return new AndroidLibraryResourceVisibility(library, new SymbolProvider());
    }

    public static ResourceVisibilityLookup create(List<IdeLibrary> libraries, Provider provider) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)libraries.size());
        for (IdeLibrary library : libraries) {
            ResourceVisibilityLookup v = provider != null ? provider.get(library) : new AndroidLibraryResourceVisibility(library, new SymbolProvider());
            if (v.isEmpty()) continue;
            list.add(v);
        }
        return new MultipleLibraryResourceVisibility(list);
    }

    private static String getMapKey(IdeLibrary library) {
        return library.getArtifactAddress();
    }

    private static String getMapKey(IdeAndroidArtifact artifact) {
        return artifact.getApplicationId();
    }

    private static String getMapKey(IdeVariant variant) {
        return ResourceVisibilityLookup.getMapKey(variant.getMainArtifact()) + '-' + variant.getName();
    }

    private static Multimap<String, ResourceType> readSymbolFile(File symbolFile) throws IOException {
        List lines = Files.readLines((File)symbolFile, (Charset)Charsets.UTF_8);
        ArrayListMultimap result2 = ArrayListMultimap.create((int)lines.size(), (int)2);
        ResourceType previousType = null;
        String previousTypeString = "";
        int count = lines.size();
        for (int lineIndex = 1; lineIndex <= count; ++lineIndex) {
            ResourceType type;
            String line = (String)lines.get(lineIndex - 1);
            if (!line.startsWith("int ")) continue;
            int typeStart = 4;
            int typeEnd = line.indexOf(32, typeStart);
            String typeString = line.substring(typeStart, typeEnd);
            if (typeString.equals(previousTypeString)) {
                type = previousType;
            } else {
                type = ResourceType.fromClassName((String)typeString);
                previousTypeString = typeString;
                previousType = type;
            }
            if (type == null) continue;
            int nameStart = typeEnd + 1;
            int nameEnd = line.indexOf(32, nameStart);
            String name = line.substring(nameStart, nameEnd);
            result2.put((Object)name, (Object)type);
        }
        return result2;
    }

    @VisibleForTesting
    static class SymbolProvider {
        private final Map<String, Multimap<String, ResourceType>> mCache = Maps.newHashMap();

        SymbolProvider() {
        }

        @VisibleForTesting
        Multimap<String, ResourceType> getSymbols(IdeLibrary library) {
            if (library.getType() != IdeLibrary.LibraryType.LIBRARY_ANDROID) {
                return ImmutableListMultimap.of();
            }
            String mapKey = ResourceVisibilityLookup.getMapKey(library);
            Multimap<String, ResourceType> map = this.mCache.get(mapKey);
            if (map != null) {
                return map;
            }
            File symbolFile = new File(library.getSymbolFile());
            if (!symbolFile.exists()) {
                ImmutableListMultimap empty = ImmutableListMultimap.of();
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)empty);
                return empty;
            }
            try {
                Multimap result2 = ResourceVisibilityLookup.readSymbolFile(symbolFile);
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)result2);
                return result2;
            }
            catch (IOException ignore) {
                ImmutableListMultimap empty = ImmutableListMultimap.of();
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)empty);
                return empty;
            }
        }
    }

    private static class AndroidLibraryResourceVisibility
    extends LibraryResourceVisibility {
        private final IdeLibrary mLibrary;

        private AndroidLibraryResourceVisibility(IdeLibrary library, Multimap<String, ResourceType> publicResources, SymbolProvider symbols2) {
            super(publicResources, publicResources != null ? symbols2.getSymbols(library) : null, ResourceVisibilityLookup.getMapKey(library));
            this.mLibrary = library;
        }

        private AndroidLibraryResourceVisibility(IdeLibrary library, SymbolProvider symbols2) {
            this(library, AndroidLibraryResourceVisibility.computeVisibilityMap(new File(library.getPublicResources())), symbols2);
        }

        @Override
        public String toString() {
            return ResourceVisibilityLookup.getMapKey(this.mLibrary);
        }

        @Override
        protected String getLibraryName() {
            return this.mLibrary.getArtifactAddress();
        }
    }

    private static class LibraryResourceVisibility
    extends ResourceVisibilityLookup {
        private final String mMapKey;
        private final Multimap<String, ResourceType> mAll;
        private final Multimap<String, ResourceType> mPublic;

        protected LibraryResourceVisibility(Multimap<String, ResourceType> publicResources, Multimap<String, ResourceType> allResources, String mapKey) {
            this.mPublic = publicResources;
            this.mAll = allResources;
            this.mMapKey = mapKey;
        }

        protected LibraryResourceVisibility(File publicResources, File allResources, String mapKey) {
            this.mPublic = LibraryResourceVisibility.computeVisibilityMap(publicResources);
            Multimap all = null;
            if (this.mPublic != null) {
                try {
                    all = ResourceVisibilityLookup.readSymbolFile(allResources);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mAll = all;
            this.mMapKey = mapKey;
        }

        public String toString() {
            return this.mMapKey;
        }

        @Override
        public boolean isEmpty() {
            return this.mPublic == null;
        }

        @Override
        public String getPrivateIn(ResourceType type, String name) {
            if (this.isPrivate(type, name)) {
                return this.getLibraryName();
            }
            return null;
        }

        protected String getLibraryName() {
            return this.mMapKey;
        }

        static Multimap<String, ResourceType> computeVisibilityMap(File publicResources) {
            if (!publicResources.exists()) {
                return null;
            }
            try {
                List lines = Files.readLines((File)publicResources, (Charset)Charsets.UTF_8);
                ArrayListMultimap result2 = ArrayListMultimap.create((int)lines.size(), (int)2);
                for (String line : lines) {
                    String typeString;
                    ResourceType type;
                    int index = line.indexOf(32);
                    if (index == -1 || line.isEmpty() || (type = ResourceType.fromClassName((String)(typeString = line.substring(0, index)))) == null) continue;
                    String name = line.substring(index + 1);
                    name = name.replace('.', '_');
                    result2.put((Object)name, (Object)type);
                }
                return result2;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            if (this.mPublic == null) {
                return false;
            }
            if (this.mAll != null && !this.mAll.containsEntry((Object)name, (Object)type)) {
                return false;
            }
            return !this.mPublic.containsEntry((Object)name, (Object)type);
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            return this.mAll != null && this.mAll.containsEntry((Object)name, (Object)type);
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            if (this.mAll == null) {
                return true;
            }
            return this.isKnown(type, name) && (this.mPublic == null || this.mPublic.containsEntry((Object)name, (Object)type));
        }
    }

    public static class Provider {
        private final Map<Object, ResourceVisibilityLookup> mInstances = Maps.newHashMap();
        private final SymbolProvider mSymbols = new SymbolProvider();

        public ResourceVisibilityLookup get(IdeLibrary library) {
            String key = ResourceVisibilityLookup.getMapKey(library);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                visibility = new AndroidLibraryResourceVisibility(library, this.mSymbols);
                if (visibility.isEmpty()) {
                    visibility = NONE;
                }
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }

        public ResourceVisibilityLookup get(IdeAndroidArtifact artifact) {
            String key = ResourceVisibilityLookup.getMapKey(artifact);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)(artifact.getLevel2Dependencies().getAndroidLibraries().size() + 1));
                for (IdeLibrary ideLibrary : artifact.getLevel2Dependencies().getAndroidLibraries()) {
                    ResourceVisibilityLookup v = this.get(ideLibrary);
                    if (v.isEmpty()) continue;
                    list.add(v);
                }
                int size = list.size();
                visibility = size == 0 ? NONE : (size == 1 ? (ResourceVisibilityLookup)list.get(0) : new MultipleLibraryResourceVisibility(list));
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }

        public static boolean isVisibilityAwareModel(IdeAndroidProject project) {
            String modelVersion = project.getModelVersion();
            return !modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && project.getApiVersion() >= 3;
        }

        public ResourceVisibilityLookup get(IdeAndroidProject project, IdeVariant variant) {
            String key = ResourceVisibilityLookup.getMapKey(variant);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                if (Provider.isVisibilityAwareModel(project)) {
                    IdeAndroidArtifact artifact = variant.getMainArtifact();
                    visibility = this.get(artifact);
                } else {
                    visibility = NONE;
                }
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }
    }

    private static class MultipleLibraryResourceVisibility
    extends ResourceVisibilityLookup {
        private final List<ResourceVisibilityLookup> mRepositories;

        public MultipleLibraryResourceVisibility(List<ResourceVisibilityLookup> repositories) {
            this.mRepositories = repositories;
        }

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isPublic(type, name)) continue;
                return false;
            }
            return this.isKnown(type, name);
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isKnown(type, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isPublic(type, name) || !lookup.isKnown(type, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                if (this.mRepositories.get(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getPrivateIn(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup r = this.mRepositories.get(i);
                if (!r.isPrivate(type, name)) continue;
                return r.getPrivateIn(type, name);
            }
            return null;
        }

        public String toString() {
            return this.mRepositories.toString();
        }
    }
}

