/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmakeOutputParser
implements PatternAwareOutputParser {
    private static final String CMAKE_ERROR = "CMake Error";
    private static final String CMAKE_WARNING = "CMake Warning";
    private static final String ERROR = "Error";
    private final Pattern cmakeErrorOrWarning = Pattern.compile("^\\s*CMake (Error|Warning)(: (Error|Warning) in cmake code)? at.*");
    private final Pattern doubleDashLine = Pattern.compile("^\\s*-- .*");
    static final Pattern fileAndLineNumber = Pattern.compile("^(([A-Za-z]:)?.*):([0-9]+)? *:([0-9]+)?(.+)?");
    static final Pattern errorFileAndLineNumber = Pattern.compile("CMake (Error|Warning).*at (([A-Za-z]:)?[^:]+):([0-9]+)?.*(\\([^:]*\\))?:([0-9]+)?(.+)?");
    private static final int SOURCE_POSITION_OFFSET = -1;

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        if (this.cmakeErrorOrWarning.matcher(line).matches()) {
            String nextLine;
            StringBuilder fullMessage = new StringBuilder(line + " ");
            while ((nextLine = reader.readLine()) != null) {
                if (this.doubleDashLine.matcher(nextLine).matches()) {
                    messages.add(new Message(Message.Kind.SIMPLE, nextLine, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                    continue;
                }
                if (nextLine.isEmpty() || this.cmakeErrorOrWarning.matcher(nextLine).matches()) {
                    reader.pushBack();
                    break;
                }
                fullMessage.append(nextLine).append(" ");
            }
            return CmakeOutputParser.matchesErrorFileAndLineNumberError(line = fullMessage.toString(), messages) || CmakeOutputParser.matchesFileAndLineNumberError(line, messages);
        }
        return false;
    }

    private static boolean matchesFileAndLineNumberError(String line, List<Message> messages) {
        Matcher matcher = fileAndLineNumber.matcher(line);
        if (matcher.matches()) {
            File file = new File(matcher.group(1));
            if (!file.isAbsolute()) {
                return false;
            }
            Message.Kind kind = Message.Kind.WARNING;
            for (Message m : messages) {
                if (m.getText().startsWith(CMAKE_ERROR)) {
                    kind = Message.Kind.ERROR;
                    continue;
                }
                if (!m.getText().startsWith(CMAKE_WARNING)) continue;
                kind = Message.Kind.WARNING;
            }
            ErrorFields fields = CmakeOutputParser.matchFileAndLineNumberErrorParts(matcher, line);
            fields.kind = kind;
            SourceFilePosition position = new SourceFilePosition(file, new SourcePosition(fields.lineNumber + -1, fields.columnNumber + -1, -1));
            Message message = new Message(fields.kind, fields.errorMessage, position, new SourceFilePosition[0]);
            messages.add(message);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static ErrorFields matchFileAndLineNumberErrorParts(Matcher matcher, String line) {
        ErrorFields fields = new ErrorFields();
        fields.lineNumber = -1;
        if (matcher.group(3) != null) {
            fields.lineNumber = Integer.valueOf(matcher.group(3));
        }
        fields.columnNumber = -1;
        if (matcher.group(4) != null) {
            fields.columnNumber = Integer.valueOf(matcher.group(4));
        }
        fields.errorMessage = line;
        if (matcher.group(5) != null) {
            fields.errorMessage = matcher.group(5);
        }
        return fields;
    }

    private static boolean matchesErrorFileAndLineNumberError(String line, List<Message> messages) {
        Matcher matcher = errorFileAndLineNumber.matcher(line);
        if (matcher.matches()) {
            File file = new File(matcher.group(2));
            if (!file.isAbsolute()) {
                return false;
            }
            ErrorFields fields = CmakeOutputParser.matchErrorFileAndLineNumberErrorParts(matcher, line);
            SourceFilePosition position = new SourceFilePosition(file, new SourcePosition(fields.lineNumber + -1, fields.columnNumber + -1, -1));
            Message message = new Message(fields.kind, fields.errorMessage, position, new SourceFilePosition[0]);
            messages.add(message);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static ErrorFields matchErrorFileAndLineNumberErrorParts(Matcher matcher, String line) {
        ErrorFields fields = new ErrorFields();
        fields.kind = Message.Kind.WARNING;
        if (matcher.group(1).equals(ERROR)) {
            fields.kind = Message.Kind.ERROR;
        }
        fields.lineNumber = 0;
        if (matcher.group(4) != null) {
            fields.lineNumber = Integer.valueOf(matcher.group(4));
        }
        fields.columnNumber = 0;
        if (matcher.group(6) != null) {
            fields.columnNumber = Integer.valueOf(matcher.group(6));
        }
        fields.errorMessage = line;
        if (matcher.group(7) != null) {
            fields.errorMessage = matcher.group(7);
        }
        return fields;
    }

    static class ErrorFields {
        Message.Kind kind;
        int lineNumber;
        int columnNumber;
        String errorMessage;

        ErrorFields() {
        }
    }
}

