/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.signing;

import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class KeystoreHelper {
    private static final String CERTIFICATE_DESC = "CN=Android Debug,O=Android,C=US";
    private static final int DEFAULT_VALIDITY_YEARS = 30;

    public static File defaultDebugKeystoreLocation(AndroidLocationsProvider androidLocationsProvider) throws AndroidLocationsException {
        return androidLocationsProvider.getPrefsLocation().resolve("debug.keystore").toFile();
    }

    public static boolean createDebugStore(String storeType, File storeFile, String storePassword, String keyPassword, String keyAlias, ILogger logger) throws KeytoolException {
        return KeystoreHelper.createNewStore(storeType, storeFile, storePassword, keyPassword, keyAlias, CERTIFICATE_DESC, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createNewStore(String storeType, File storeFile, String storePassword, String keyPassword, String keyAlias, String dn, int validityYears) throws KeytoolException {
        Preconditions.checkArgument((validityYears > 0 ? 1 : 0) != 0, (String)"validityYears (%s) <= 0", (int)validityYears);
        String useStoreType = storeType;
        if (useStoreType == null) {
            useStoreType = KeyStore.getDefaultType();
            Verify.verifyNotNull((Object)useStoreType);
        }
        try {
            KeyStore ks = KeyStore.getInstance(useStoreType);
            ks.load(null, null);
            Pair<PrivateKey, X509Certificate> generated = KeystoreHelper.generateKeyAndCertificate("RSA", "SHA1withRSA", validityYears, dn);
            ks.setKeyEntry(keyAlias, (Key)generated.getFirst(), keyPassword.toCharArray(), new Certificate[]{(Certificate)generated.getSecond()});
            FileOutputStream fos = new FileOutputStream(storeFile);
            boolean threw = true;
            try {
                ks.store(fos, storePassword.toCharArray());
                threw = false;
            }
            finally {
                Closeables.close((Closeable)fos, (boolean)threw);
            }
        }
        catch (KeytoolException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeytoolException("Failed to create keystore.", e);
        }
        return true;
    }

    public static CertificateInfo getCertificateInfo(String storeType, File storeFile, String storePassword, String keyPassword, String keyAlias) throws KeytoolException, FileNotFoundException {
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType != null ? storeType : KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(storeFile);
            keyStore.load(fis, storePassword.toCharArray());
            fis.close();
            char[] keyPasswordArray = keyPassword.toCharArray();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPasswordArray));
            if (entry == null) {
                throw new KeytoolException(String.format("No key with alias '%1$s' found in keystore %2$s", keyAlias, storeFile.getAbsolutePath()));
            }
            return new CertificateInfo(entry.getPrivateKey(), (X509Certificate)entry.getCertificate());
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeytoolException(String.format("Failed to read key %1$s from store \"%2$s\": %3$s", keyAlias, storeFile, e.getMessage()), e);
        }
    }

    private static Pair<PrivateKey, X509Certificate> generateKeyAndCertificate(String asymmetric, String sign, int validityYears, String dn) throws KeytoolException {
        X509Certificate certificate;
        ContentSigner signer;
        KeyPair keyPair;
        Preconditions.checkArgument((validityYears > 0 ? 1 : 0) != 0, (Object)"validityYears <= 0");
        try {
            keyPair = KeyPairGenerator.getInstance(asymmetric).generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeytoolException("Failed to generate key and certificate pair for algorithm '" + asymmetric + "'.", e);
        }
        Date notBefore = new Date(System.currentTimeMillis());
        Date notAfter = new Date(System.currentTimeMillis() + (long)validityYears * 365L * 24L * 60L * 60L * 1000L);
        X500Name issuer = new X500Name(new X500Principal(dn).getName());
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v1CertificateBuilder builder = new X509v1CertificateBuilder(issuer, BigInteger.ONE, notBefore, notAfter, issuer, publicKeyInfo);
        try {
            signer = new JcaContentSignerBuilder(sign).setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate());
        }
        catch (OperatorCreationException e) {
            throw new KeytoolException("Failed to build content signer with signature algorithm '" + sign + "'.", e);
        }
        X509CertificateHolder holder = builder.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider());
        try {
            certificate = converter.getCertificate(holder);
        }
        catch (CertificateException e) {
            throw new KeytoolException("Failed to obtain the self-signed certificate.", e);
        }
        return Pair.of((Object)keyPair.getPrivate(), (Object)certificate);
    }
}

