/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ResourcesUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

public class ResourceNameKeyedMap<T>
extends THashMap<String, T> {
    private static TObjectHashingStrategy<String> NORMALIZED_RESOURCE_NAME_STRATEGY = new TObjectHashingStrategy<String>(){

        public int computeHashCode(@NotNull String object) {
            int result2 = 0;
            for (int i = 0; i < object.length(); ++i) {
                result2 = result2 * 31 + this.normalize(object.charAt(i));
            }
            return result2;
        }

        public boolean equals(@NotNull String o1, @NotNull String o2) {
            if (o1.length() != o2.length()) {
                return false;
            }
            for (int i = o1.length() - 1; i >= 0; --i) {
                char c2;
                char c1 = this.normalize(o1.charAt(i));
                if (c1 == (c2 = this.normalize(o2.charAt(i)))) continue;
                return false;
            }
            return true;
        }

        private char normalize(char c) {
            if (ResourcesUtil.isInvalidResourceFieldNameCharacter(c)) {
                return '_';
            }
            return c;
        }
    };

    public ResourceNameKeyedMap() {
        super(NORMALIZED_RESOURCE_NAME_STRATEGY);
    }

    public ResourceNameKeyedMap(int expectedSize) {
        super(expectedSize, NORMALIZED_RESOURCE_NAME_STRATEGY);
    }
}

