/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceId;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0007J\u0010\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020!J\"\u0010(\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007J\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u001f0.J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\n002\u0006\u00101\u001a\u00020\u0007H\u0002J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u00103\u001a\u00020\u0007J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u00105\u001a\u00020\u0007J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u000207J\u000e\u0010:\u001a\u0002072\u0006\u0010)\u001a\u00020\u0007J\u000e\u0010;\u001a\u0002072\u0006\u0010)\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR&\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u001f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore;", "", "supportMultipackages", "", "(Z)V", "_discardAttributes", "", "", "_keepAttributes", "_resources", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "discardAttributes", "", "getDiscardAttributes", "()Ljava/util/List;", "keepAttributes", "getKeepAttributes", "keepResources", "", "Lcom/android/ide/common/resources/usage/ResourceId;", "resourceById", "", "resources", "getResources", "safeMode", "getSafeMode", "()Z", "setSafeMode", "getSupportMultipackages", "typeToName", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "valueToResource", "", "addResource", "resource", "dumpConfig", "dumpKeepResources", "dumpReferences", "dumpResourceModel", "getResource", "value", "packageName", "type", "name", "getResourceMaps", "", "getResourcesForKeepOrDiscardPattern", "Lkotlin/sequences/Sequence;", "pattern", "getResourcesFromUrl", "possibleUrlReference", "getResourcesFromWebUrl", "webUrl", "merge", "", "other", "processToolsAttributes", "recordDiscardToolAttribute", "recordKeepToolAttribute", "Companion", "sdk-common"})
public final class ResourceStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportMultipackages;
    @NotNull
    private final Map<ResourceId, ResourceUsageModel.Resource> resourceById;
    @NotNull
    private final List<ResourceUsageModel.Resource> _resources;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceUsageModel.Resource>> typeToName;
    @NotNull
    private final Map<Integer, ResourceUsageModel.Resource> valueToResource;
    @NotNull
    private final Set<ResourceId> keepResources;
    @NotNull
    private final List<String> _keepAttributes;
    @NotNull
    private final List<String> _discardAttributes;
    private boolean safeMode;
    private static final int TYPICAL_RESOURCE_COUNT = 200;

    public ResourceStore(boolean supportMultipackages) {
        this.supportMultipackages = supportMultipackages;
        Cloneable cloneable = Maps.newLinkedHashMapWithExpectedSize((int)200);
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newLinkedHashMapWithExpe\u2026e(TYPICAL_RESOURCE_COUNT)");
        this.resourceById = cloneable;
        cloneable = Lists.newArrayListWithCapacity((int)200);
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newArrayListWithCapacity\u2026>(TYPICAL_RESOURCE_COUNT)");
        this._resources = (List)((Object)cloneable);
        cloneable = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newEnumMap(ResourceType::class.java)");
        this.typeToName = cloneable;
        cloneable = Maps.newHashMapWithExpectedSize((int)200);
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newHashMapWithExpectedSize(TYPICAL_RESOURCE_COUNT)");
        this.valueToResource = cloneable;
        cloneable = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newHashSet()");
        this.keepResources = (Set)((Object)cloneable);
        cloneable = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newArrayList()");
        this._keepAttributes = (List)((Object)cloneable);
        cloneable = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"newArrayList()");
        this._discardAttributes = (List)((Object)cloneable);
        this.safeMode = true;
    }

    public /* synthetic */ ResourceStore(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getSupportMultipackages() {
        return this.supportMultipackages;
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources() {
        List<ResourceUsageModel.Resource> list = Collections.unmodifiableList(this._resources);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(_resources)");
        return list;
    }

    @NotNull
    public final List<String> getKeepAttributes() {
        List<String> list = Collections.unmodifiableList(this._keepAttributes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(_keepAttributes)");
        return list;
    }

    @NotNull
    public final List<String> getDiscardAttributes() {
        List<String> list = Collections.unmodifiableList(this._discardAttributes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(_discardAttributes)");
        return list;
    }

    public final boolean getSafeMode() {
        return this.safeMode;
    }

    public final void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(int value) {
        return this.valueToResource.get(value);
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(@Nullable String packageName, @NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Preconditions.checkArgument((this.supportMultipackages || packageName == null ? 1 : 0) != 0, (String)"In a single package mode packageName must be null.", (Object[])new Object[0]);
        return this.resourceById.get(new ResourceId(type, name, packageName));
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources(@NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.typeToName.get(type);
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ListMultimap<String, ResourceUsageModel.Resource> resourcesByName = object;
        object = resourcesByName.get((Object)ResourcesUtil.resourceNameToFieldName(name));
        Intrinsics.checkNotNullExpressionValue(object, (String)"resourcesByName[resourceNameToFieldName(name)]");
        return CollectionsKt.toList((Iterable)((Iterable)object));
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromUrl(@NotNull String possibleUrlReference) {
        Intrinsics.checkNotNullParameter((Object)possibleUrlReference, (String)"possibleUrlReference");
        ResourceUrl url = ResourceUrl.parse((String)possibleUrlReference);
        if (url == null || url.isFramework()) {
            return CollectionsKt.emptyList();
        }
        Object object = url.type;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url.type");
        ResourceType resourceType = object;
        object = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url.name");
        return this.getResources(resourceType, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromWebUrl(@NotNull String webUrl) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)webUrl, (String)"webUrl");
        String afterAndroidRes = StringsKt.substringAfter$default((String)webUrl, (String)"android_res/", null, (int)2, null);
        Object object = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)afterAndroidRes, (String[])object, (boolean)false, (int)2, (int)2, null);
        if (parts.size() < 2) {
            return CollectionsKt.emptyList();
        }
        Object object2 = object = parts;
        boolean bl = false;
        String type = (String)object2.get(0);
        Object object3 = object;
        boolean bl2 = false;
        String namePart = (String)object3.get(1);
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)type);
        if (resourceFolderType == null) {
            return CollectionsKt.emptyList();
        }
        ResourceFolderType folderType = resourceFolderType;
        String name = StringsKt.substringBefore$default((String)namePart, (char)'.', null, (int)2, null);
        Iterable iterable = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getRelatedResourceTypes(folderType)");
        iterable = iterable;
        boolean $i$f$flatMap = false;
        void var11_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResourceType it = (ResourceType)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv$iv = this.getResources(it, name);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ResourceUsageModel.Resource addResource(@NotNull ResourceUsageModel.Resource resource) {
        ResourceUsageModel.Resource resource2;
        boolean bl;
        Map<Integer, ResourceUsageModel.Resource> map;
        ResourceStore resourceStore;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        if (!this.supportMultipackages) {
            resource.packageName = null;
        }
        Object object = resource.type;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resource.type");
        ResourceType resourceType = object;
        object = resource.name;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resource.name");
        ResourceId id = new ResourceId(resourceType, (String)object, resource.packageName);
        ResourceUsageModel.Resource stored = this.resourceById.get(id);
        if (stored == null) {
            resourceStore = this;
            map = resourceStore.resourceById;
            Pair pair = TuplesKt.to((Object)id, (Object)resource);
            bl = false;
            map.put((Integer)((Object)((ResourceId)pair.getFirst())), (ResourceUsageModel.Resource)pair.getSecond());
            resourceStore = this;
            map = resourceStore._resources;
            boolean bl2 = false;
            map.add(resource);
            this.typeToName.computeIfAbsent(resource.type, addResource.updated.1.INSTANCE).put((Object)resource.name, (Object)resource);
            if (resource.value != -1) {
                resourceStore = this;
                map = resourceStore.valueToResource;
                Pair pair2 = TuplesKt.to((Object)resource.value, (Object)resource);
                bl = false;
                map.put((Integer)pair2.getFirst(), (ResourceUsageModel.Resource)pair2.getSecond());
            }
            resource2 = resource;
        } else {
            Preconditions.checkState((resource.value == -1 || stored.value == resource.value ? 1 : 0) != 0, (String)"Resource value must be the same between addResource calls.", (Object[])new Object[0]);
            if (resource.value != -1 && stored.value == -1) {
                stored.value = resource.value;
                resourceStore = this;
                map = resourceStore.valueToResource;
                Pair pair = TuplesKt.to((Object)stored.value, (Object)stored);
                bl = false;
                map.put((Integer)pair.getFirst(), (ResourceUsageModel.Resource)pair.getSecond());
            }
            resource2 = stored;
        }
        ResourceUsageModel.Resource updated2 = resource2;
        return updated2;
    }

    @NotNull
    public final Collection<ListMultimap<String, ResourceUsageModel.Resource>> getResourceMaps() {
        return this.typeToName.values();
    }

    public final void recordKeepToolAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Iterable iterable = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"on(',')\n            .omi\u2026            .split(value)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ResourceStore resourceStore = this;
            Collection collection = resourceStore._keepAttributes;
            boolean bl2 = false;
            collection.add(it);
        }
    }

    public final void recordDiscardToolAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Iterable iterable = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"on(',')\n            .omi\u2026            .split(value)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ResourceStore resourceStore = this;
            Collection collection = resourceStore._discardAttributes;
            boolean bl2 = false;
            collection.add(it);
        }
    }

    public final void processToolsAttributes() {
        ResourceUsageModel.Resource it;
        Sequence $this$forEach$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this._keepAttributes), (Function1)((Function1)new Function1<String, Sequence<? extends ResourceUsageModel.Resource>>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<ResourceUsageModel.Resource> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ResourceStore.access$getResourcesForKeepOrDiscardPattern(this.this$0, it);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            it.setReachable(true);
            ResourceStore resourceStore = this;
            Collection collection = resourceStore.keepResources;
            Object object = it.type;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.type");
            ResourceType resourceType = object;
            object = it.name;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.name");
            object = new ResourceId(resourceType, (String)object, it.packageName);
            boolean bl2 = false;
            collection.add(object);
        }
        $this$forEach$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this._discardAttributes), (Function1)((Function1)new Function1<String, Sequence<? extends ResourceUsageModel.Resource>>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<ResourceUsageModel.Resource> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ResourceStore.access$getResourcesForKeepOrDiscardPattern(this.this$0, it);
            }
        }));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            it.setReachable(false);
        }
    }

    @NotNull
    public final String dumpConfig() {
        Function1[] function1Array = new Function1[]{dumpConfig.1.INSTANCE, dumpConfig.2.INSTANCE};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), (Function1)((Function1)new Function1<ResourceUsageModel.Resource, String>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ResourceUsageModel.Resource r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Object object = r.type;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.type");
                ResourceType resourceType = object;
                object = r.name;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.name");
                ResourceId id = new ResourceId(resourceType, (String)object, r.packageName);
                Object[] objectArray = new String[2];
                String string = "remove";
                boolean bl = false;
                boolean bl2 = false;
                String string2 = string;
                int n = 0;
                Object[] objectArray2 = objectArray;
                boolean $i$a$-takeUnless-ResourceStore$dumpConfig$3$actions$22 = false;
                boolean bl3 = r.isReachable();
                objectArray2[n] = !bl3 ? string : null;
                string = "no_obfuscate";
                ResourceStore resourceStore = this.this$0;
                bl2 = false;
                boolean bl4 = false;
                String $i$a$-takeUnless-ResourceStore$dumpConfig$3$actions$22 = string;
                n = 1;
                objectArray2 = objectArray;
                boolean bl5 = false;
                bl3 = ResourceStore.access$getKeepResources$p(resourceStore).contains(id);
                objectArray2[n] = bl3 ? string : null;
                String actions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                return r.type + '/' + r.name + '#' + actions;
            }
        })), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpKeepResources() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.keepResources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceId resourceId = (ResourceId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String dumpReferences() {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Function1)dumpReferences.1.INSTANCE), (Function1)dumpReferences.2.INSTANCE)), (CharSequence)"\n", (CharSequence)"Resource Reference Graph:\n", (CharSequence)"", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public final String dumpResourceModel() {
        Function1[] function1Array = new Function1[]{dumpResourceModel.1.INSTANCE, dumpResourceModel.2.INSTANCE};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), (Function1)dumpResourceModel.3.INSTANCE), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    private final Sequence<ResourceUsageModel.Resource> getResourcesForKeepOrDiscardPattern(String pattern) {
        ResourceUrl url = ResourceUrl.parse((String)pattern);
        if (url == null || url.isFramework()) {
            return SequencesKt.emptySequence();
        }
        Object object = this.typeToName.get(url.type);
        if (object == null) {
            return SequencesKt.emptySequence();
        }
        ListMultimap<String, ResourceUsageModel.Resource> resources = object;
        object = url.name;
        Intrinsics.checkNotNullExpressionValue(object, (String)"url.name");
        if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"*", (boolean)false, (int)2, null)) {
            object = url.name;
            Intrinsics.checkNotNullExpressionValue(object, (String)"url.name");
            if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"?", (boolean)false, (int)2, null)) {
                object = resources.get((Object)url.name);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resources[url.name]");
                return CollectionsKt.asSequence((Iterable)((Iterable)object));
            }
        }
        try {
            String string = url.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.name");
            Object object2 = SdkUtils.globToRegexp((String)ResourcesUtil.resourceNameToFieldName(string));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"globToRegexp(resourceNameToFieldName(url.name))");
            boolean bl = false;
            Regex regexp = new Regex((String)object2);
            object2 = resources.entries();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"resources.entries()");
            object = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object2)), (Function1)((Function1)new Function1<Map.Entry<String, ResourceUsageModel.Resource>, Boolean>(regexp){
                final /* synthetic */ Regex $regexp;
                {
                    this.$regexp = $regexp;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Map.Entry<String, ResourceUsageModel.Resource> it) {
                    String string = it.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.key");
                    return this.$regexp.matches((CharSequence)string);
                }
            })), (Function1)getResourcesForKeepOrDiscardPattern.2.INSTANCE);
        }
        catch (PatternSyntaxException e) {
            object = SequencesKt.emptySequence();
        }
        return object;
    }

    public final void merge(@NotNull ResourceStore other) {
        boolean $i$f$forEach;
        Object object;
        ResourceUsageModel.Resource r;
        String it;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterable $this$forEach$iv = other._discardAttributes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (this._discardAttributes.contains(it)) continue;
            this._discardAttributes.add(it);
        }
        $this$forEach$iv = other._keepAttributes;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (this._keepAttributes.contains(it)) continue;
            this._keepAttributes.add(it);
        }
        $this$forEach$iv = other._resources;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            r = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            String string = r.packageName;
            object = r.type;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.type");
            ResourceType resourceType = object;
            object = r.name;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.name");
            Object object2 = this.getResource(string, resourceType, (String)object);
            ResourceUsageModel.Resource existing = object2 == null ? this.addResource(new ResourceUsageModel.Resource(r.packageName, r.type, r.name, r.value)) : object2;
            existing.mFlags |= r.mFlags;
            object2 = r.declarations;
            if (object2 == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Path location = (Path)element$iv2;
                boolean bl2 = false;
                List<Path> locations = existing.declarations;
                if (locations != null && locations.contains(location)) continue;
                existing.addLocation(location);
            }
        }
        $this$forEach$iv = other._resources;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            r = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            String string = r.packageName;
            object = r.type;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.type");
            Object object3 = object;
            object = r.name;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.name");
            ResourceUsageModel.Resource existing = this.getResource(string, (ResourceType)object3, (String)object);
            if (existing == null || (object = r.references) == null) continue;
            Iterable $this$forEach$iv3 = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                ResourceUsageModel.Resource referenced = (ResourceUsageModel.Resource)element$iv2;
                boolean bl3 = false;
                String string2 = referenced.packageName;
                Object object4 = referenced.type;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"referenced.type");
                ResourceType resourceType = object4;
                object4 = referenced.name;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"referenced.name");
                ResourceUsageModel.Resource ref = this.getResource(string2, resourceType, (String)object4);
                if (ref == null) continue;
                existing.addReference(ref);
            }
        }
    }

    public ResourceStore() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Sequence access$getResourcesForKeepOrDiscardPattern(ResourceStore $this, String pattern) {
        return $this.getResourcesForKeepOrDiscardPattern(pattern);
    }

    public static final /* synthetic */ Set access$getKeepResources$p(ResourceStore $this) {
        return $this.keepResources;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore$Companion;", "", "()V", "TYPICAL_RESOURCE_COUNT", "", "deserialize", "Lcom/android/ide/common/resources/usage/ResourceStore;", "s", "", "serialize", "store", "includeValues", "", "serializeInto", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String serialize(@NotNull ResourceStore store, boolean includeValues) {
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            StringBuilder sb = new StringBuilder(2000);
            this.serializeInto(sb, store, includeValues);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public static /* synthetic */ String serialize$default(Companion companion, ResourceStore resourceStore, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.serialize(resourceStore, bl);
        }

        public final void serializeInto(@NotNull StringBuilder sb, @NotNull ResourceStore store, boolean includeValues) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            if (store.getSupportMultipackages()) {
                sb.append("P;");
            }
            Map storeTypeToName = store.typeToName;
            HashBiMap hashBiMap = HashBiMap.create((int)storeTypeToName.size());
            Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(storeTypeToName.size)");
            BiMap referenceMap = (BiMap)hashBiMap;
            int nextId = 0;
            for (ResourceType type : storeTypeToName.keySet()) {
                ListMultimap listMultimap = (ListMultimap)storeTypeToName.get(type);
                if (listMultimap == null) continue;
                ListMultimap list = listMultimap;
                for (ResourceUsageModel.Resource resource : list.values()) {
                    Map map = (Map)referenceMap;
                    int n = nextId;
                    nextId = n + 1;
                    Integer n2 = n;
                    boolean bl = false;
                    map.put(resource, n2);
                }
            }
            if (referenceMap.isEmpty()) {
                return;
            }
            ResourceType prev = null;
            boolean first = true;
            for (ResourceUsageModel.Resource resource : referenceMap.keySet()) {
                boolean includeValue;
                ResourceType type = resource.type;
                if (type != prev) {
                    prev = type;
                    if (!first) {
                        sb.append(']');
                        sb.append(',');
                        first = true;
                    }
                    sb.append(type.getName());
                    sb.append('[');
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(resource.name);
                sb.append('(');
                sb.append(resource.flagString());
                boolean bl = includeValue = includeValues && resource.value != -1;
                if (store.getSupportMultipackages()) {
                    if (resource.packageName != null) {
                        sb.append(',');
                        sb.append(resource.packageName);
                    } else if (includeValue) {
                        sb.append(',');
                    }
                }
                if (includeValue) {
                    sb.append(',');
                    sb.append(Integer.toHexString(resource.value));
                }
                sb.append(')');
            }
            sb.append(']');
            sb.append(';');
            first = true;
            for (ResourceUsageModel.Resource resource : referenceMap.keySet()) {
                List<ResourceUsageModel.Resource> references = resource.references;
                if (references == null) continue;
                Collection includeValue = references;
                boolean bl = false;
                if (!(!includeValue.isEmpty())) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"resource");
                sb.append(com.android.ide.common.resources.usage.ResourceStore$Companion.serializeInto$id(resource, (BiMap<ResourceUsageModel.Resource, Integer>)referenceMap));
                for (ResourceUsageModel.Resource reference : references) {
                    sb.append('^');
                    Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"reference");
                    sb.append(com.android.ide.common.resources.usage.ResourceStore$Companion.serializeInto$id(reference, (BiMap<ResourceUsageModel.Resource, Integer>)referenceMap));
                }
            }
            sb.append(';');
            Object object = store._keepAttributes;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$serializeInto_u24lambda_u2d0 = object;
            boolean bl3 = false;
            Collection collection = (Collection)$this$serializeInto_u24lambda_u2d0;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)((Iterable)$this$serializeInto_u24lambda_u2d0), (Appendable)sb, (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
            }
            sb.append(';');
            object = store._discardAttributes;
            bl = false;
            bl2 = false;
            Object $this$serializeInto_u24lambda_u2d1 = object;
            boolean bl5 = false;
            collection = (Collection)$this$serializeInto_u24lambda_u2d1;
            bl4 = false;
            if (!collection.isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)((Iterable)$this$serializeInto_u24lambda_u2d1), (Appendable)sb, (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
            }
            sb.append(';');
        }

        public static /* synthetic */ void serializeInto$default(Companion companion, StringBuilder stringBuilder, ResourceStore resourceStore, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.serializeInto(stringBuilder, resourceStore, bl);
        }

        @NotNull
        public final ResourceStore deserialize(@NotNull String s) {
            int discardEnd;
            int keepEnd;
            String idString;
            int typeEnd;
            char next;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            CharSequence charSequence = s;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return new ResourceStore(false, 1, null);
            }
            int offset = 0;
            boolean supportMultiPackages = false;
            if (StringsKt.startsWith$default((String)s, (String)"P;", (boolean)false, (int)2, null)) {
                supportMultiPackages = true;
                offset += 2;
            }
            ResourceStore resourceStore = new ResourceStore(supportMultiPackages);
            HashBiMap hashBiMap = HashBiMap.create((int)(s.length() / 10));
            Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(s.length / 10)");
            BiMap referenceMap = (BiMap)hashBiMap;
            int nextId = 0;
            int length = s.length();
            ResourceType type = ResourceType.SAMPLE_DATA;
            char[] cArray = new char[]{',', ')', '^', ';'};
            char[] delimiters = cArray;
            block0: while (offset < length && (next = s.charAt(offset)) != ';') {
                ResourceType fromClassName;
                ResourceType resourceType;
                boolean bl2;
                Object it;
                boolean $i$f$first22;
                block20: {
                    String typeString;
                    typeEnd = StringsKt.indexOf$default((CharSequence)s, (char)'[', (int)offset, (boolean)false, (int)4, null);
                    boolean bl3 = typeEnd != -1;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl3) {
                        boolean bl6 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    String string = s;
                    bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(offset, typeEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    ResourceType resourceType2 = ResourceType.fromClassName((String)typeString);
                    if (resourceType2 == null) {
                        ResourceType[] $this$first$iv = ResourceType.values();
                        $i$f$first22 = false;
                        for (ResourceType element$iv : $this$first$iv) {
                            it = element$iv;
                            bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)typeString)) continue;
                            resourceType = element$iv;
                            break block20;
                        }
                        throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                    resourceType = resourceType2;
                }
                type = fromClassName = resourceType;
                offset = typeEnd + 1;
                while (offset < length) {
                    String name;
                    boolean bl7;
                    Object object;
                    String flagString;
                    boolean bl8 = s.charAt(offset) != ']';
                    boolean $this$first$iv = false;
                    $i$f$first22 = false;
                    if (_Assertions.ENABLED && !bl8) {
                        boolean bl9 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    int nameEnd = StringsKt.indexOf$default((CharSequence)s, (char)'(', (int)offset, (boolean)false, (int)4, null);
                    $this$first$iv = nameEnd != -1;
                    $i$f$first22 = false;
                    boolean bl10 = false;
                    if (_Assertions.ENABLED && !$this$first$iv) {
                        int n = 0;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    String $i$f$first22 = s;
                    bl10 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$first22.substring(offset, nameEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    offset = nameEnd + 1;
                    int end = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                    String string = s;
                    int n = 0;
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(offset, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int flags = ResourceUsageModel.Resource.stringToFlag(flagString);
                    String pkg = null;
                    if (supportMultiPackages && s.charAt(end) == ',') {
                        offset = end + 1;
                        int packageEnd = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                        if (packageEnd > offset) {
                            it = s;
                            bl2 = false;
                            String string2 = ((String)it).substring(offset, packageEnd);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            pkg = string2;
                        }
                        end = packageEnd;
                    }
                    int value = 0;
                    if (s.charAt(end) == ',') {
                        String valueString22;
                        offset = end + 1;
                        int valueEnd = StringsKt.indexOf$default((CharSequence)s, (char)')', (int)offset, (boolean)false, (int)4, null);
                        object = s;
                        bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)((String)object).substring(offset, valueEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        value = Integer.parseUnsignedInt(valueString22, 16);
                        offset = valueEnd + 1;
                    } else {
                        value = -1;
                        offset = end + 1;
                    }
                    ResourceUsageModel.Resource resource = new ResourceUsageModel.Resource(pkg, type, name, value);
                    resource.mFlags = flags;
                    Map valueString22 = (Map)referenceMap;
                    int n2 = nextId;
                    nextId = n2 + 1;
                    object = n2;
                    bl7 = false;
                    valueString22.put(resource, object);
                    int valueString22 = offset;
                    offset = valueString22 + 1;
                    if (s.charAt(valueString22) == ',') continue;
                    if (s.charAt(offset) != ',') continue block0;
                    valueString22 = offset;
                    offset = valueString22 + 1;
                    continue block0;
                }
            }
            if (offset < length - 1) {
                BiMap inverse = referenceMap.inverse();
                typeEnd = offset;
                offset = typeEnd + 1;
                while (offset < length) {
                    if (s.charAt(offset) == ';') {
                        typeEnd = offset;
                        offset = typeEnd + 1;
                        break;
                    }
                    int end = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                    String fromClassName = s;
                    boolean nameEnd = false;
                    Intrinsics.checkNotNullExpressionValue((Object)fromClassName.substring(offset, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int id = Integer.parseInt(idString, 16);
                    Object object = inverse.get((Object)id);
                    Intrinsics.checkNotNull((Object)object);
                    ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)object;
                    offset = end + 1;
                    while (offset < length) {
                        String refIdString;
                        int refEnd = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                        String flagString = s;
                        boolean flags = false;
                        Intrinsics.checkNotNullExpressionValue((Object)flagString.substring(offset, refEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        int ref = Integer.parseInt(refIdString, 16);
                        Object object2 = inverse.get((Object)ref);
                        Intrinsics.checkNotNull((Object)object2);
                        ResourceUsageModel.Resource reference = (ResourceUsageModel.Resource)object2;
                        resource.addReference(reference);
                        offset = refEnd + 1;
                        if (s.charAt(offset - 1) != ',' && s.charAt(offset - 1) != ';') continue;
                    }
                    if (s.charAt(offset - 1) != ';') continue;
                }
            }
            if ((keepEnd = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)offset, (boolean)false, (int)4, null)) > offset) {
                idString = s;
                boolean id = false;
                String string = idString.substring(offset, keepEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String keep = string;
                resourceStore.recordKeepToolAttribute(keep);
            }
            if ((discardEnd = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)(offset = keepEnd + 1), (boolean)false, (int)4, null)) > offset) {
                String id = s;
                boolean bl11 = false;
                String string = id.substring(offset, discardEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String discard = string;
                resourceStore.recordDiscardToolAttribute(discard);
            }
            Map $this$forEach$iv = (Map)referenceMap;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl12 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$resource$_u24__u24 = element$iv = iterator.next();
                boolean bl13 = false;
                Map.Entry entry = $dstr$resource$_u24__u24;
                boolean bl14 = false;
                ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)entry.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"resource");
                resourceStore.addResource(resource);
            }
            resourceStore.processToolsAttributes();
            return resourceStore;
        }

        private static final String serializeInto$id(ResourceUsageModel.Resource $this$serializeInto_u24id, BiMap<ResourceUsageModel.Resource, Integer> referenceMap) {
            Object object = referenceMap.get((Object)$this$serializeInto_u24id);
            Intrinsics.checkNotNull((Object)object);
            String string = Integer.toHexString(((Number)object).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(referenceMap[this]!!)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

