/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessInfo;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProcessInfoBuilder
extends ProcessEnvBuilder<ProcessInfoBuilder> {
    private String mExecutable;
    private String mClasspath;
    private String mMain;
    private final List<String> mArgs = Lists.newArrayList();
    private final List<String> mJvmArgs = Lists.newArrayList();
    private File mDirectory;

    public ProcessInfo createProcess() {
        Preconditions.checkNotNull((Object)this.mExecutable, (Object)"executable is missing");
        return new ProcessInfoImpl(this.mExecutable, (List<String>)ImmutableList.copyOf(this.mArgs), (Map<String, Object>)ImmutableMap.copyOf((Map)this.mEnvironment), this.mDirectory);
    }

    public JavaProcessInfo createJavaProcess() {
        Preconditions.checkNotNull((Object)this.mClasspath, (Object)"classpath is missing");
        Preconditions.checkNotNull((Object)this.mMain, (Object)"main class is missing");
        return new JavaProcessInfoImpl(this.mClasspath, this.mMain, (List<String>)ImmutableList.copyOf(this.mArgs), (Map<String, Object>)ImmutableMap.copyOf((Map)this.mEnvironment), (List<String>)ImmutableList.copyOf(this.mJvmArgs), this.mDirectory);
    }

    public ProcessInfoBuilder setExecutable(String executable) {
        this.mExecutable = executable;
        return this;
    }

    public ProcessInfoBuilder setExecutable(File executable) {
        this.mExecutable = executable.getAbsolutePath();
        return this;
    }

    public ProcessInfoBuilder setClasspath(String classpath) {
        this.mClasspath = classpath;
        return this;
    }

    public ProcessInfoBuilder setMain(String mainClass) {
        this.mMain = mainClass;
        return this;
    }

    public ProcessInfoBuilder addArgs(String arg) {
        this.mArgs.add(arg);
        return this;
    }

    public ProcessInfoBuilder addArgs(String arg1, String arg2) {
        this.mArgs.add(arg1);
        this.mArgs.add(arg2);
        return this;
    }

    public ProcessInfoBuilder addArgs(String arg1, String arg2, String arg3) {
        this.mArgs.add(arg1);
        this.mArgs.add(arg2);
        this.mArgs.add(arg3);
        return this;
    }

    public ProcessInfoBuilder addArgs(String arg1, String arg2, String arg3, String ... args) {
        this.mArgs.add(arg1);
        this.mArgs.add(arg2);
        this.mArgs.add(arg3);
        this.mArgs.addAll(Arrays.asList(args));
        return this;
    }

    public ProcessInfoBuilder addArgs(List<String> args) {
        this.mArgs.addAll(args);
        return this;
    }

    public ProcessInfoBuilder addArgs(String[] args) {
        Collections.addAll(this.mArgs, args);
        return this;
    }

    public ProcessInfoBuilder addJvmArg(String arg) {
        this.mJvmArgs.add(arg);
        return this;
    }

    public ProcessInfoBuilder addJvmArgs(String arg1, String arg2) {
        this.mJvmArgs.add(arg1);
        this.mJvmArgs.add(arg2);
        return this;
    }

    public ProcessInfoBuilder addJvmArgs(String arg1, String arg2, String arg3) {
        this.mJvmArgs.add(arg1);
        this.mJvmArgs.add(arg2);
        this.mJvmArgs.add(arg3);
        return this;
    }

    public ProcessInfoBuilder addJvmArgs(String arg1, String arg2, String arg3, String ... args) {
        this.mJvmArgs.add(arg1);
        this.mJvmArgs.add(arg2);
        this.mJvmArgs.add(arg3);
        this.mJvmArgs.addAll(Arrays.asList(args));
        return this;
    }

    public ProcessInfoBuilder addJvmArgs(List<String> args) {
        this.mJvmArgs.addAll(args);
        return this;
    }

    public ProcessInfoBuilder setDirectory(File directory) {
        this.mDirectory = directory;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Executable : ").append(this.mExecutable).append("\n");
        sb.append("arguments : \n").append(Joiner.on((String)"\n").join(this.mArgs)).append("\n");
        sb.append("jvmArgs : \n").append(Joiner.on((String)",").join(this.mJvmArgs)).append("\n");
        if (this.mDirectory != null) {
            sb.append("directory : ").append(this.mDirectory).append("\n");
        }
        return sb.toString();
    }

    protected static class ProcessInfoImpl
    implements ProcessInfo {
        private final String mExecutable;
        private final List<String> mArgs;
        private final Map<String, Object> mEnvironment;
        private final File mDirectory;

        public ProcessInfoImpl(String executable, List<String> args, Map<String, Object> environment, File directory) {
            this.mExecutable = executable;
            this.mArgs = args;
            this.mEnvironment = environment;
            this.mDirectory = directory;
        }

        @Override
        public String getExecutable() {
            return this.mExecutable;
        }

        @Override
        public List<String> getArgs() {
            return this.mArgs;
        }

        @Override
        public Map<String, Object> getEnvironment() {
            return this.mEnvironment;
        }

        @Override
        public File getWorkingDirectory() {
            return this.mDirectory;
        }

        @Override
        public String getDescription() {
            return "process " + this.getExecutable();
        }
    }

    protected static class JavaProcessInfoImpl
    implements JavaProcessInfo {
        private final String mClasspath;
        private final String mMain;
        private final List<String> mArgs;
        private final Map<String, Object> mEnvironment;
        private final List<String> mJvmArgs;
        private final File mDirectory;

        public JavaProcessInfoImpl(String classpath, String main, List<String> args, Map<String, Object> environment, List<String> jvmArgs, File directory) {
            this.mClasspath = classpath;
            this.mMain = main;
            this.mArgs = args;
            this.mEnvironment = environment;
            this.mJvmArgs = jvmArgs;
            this.mDirectory = directory;
        }

        @Override
        public String getExecutable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClasspath() {
            return this.mClasspath;
        }

        @Override
        public String getMainClass() {
            return this.mMain;
        }

        @Override
        public List<String> getArgs() {
            return this.mArgs;
        }

        @Override
        public Map<String, Object> getEnvironment() {
            return this.mEnvironment;
        }

        @Override
        public List<String> getJvmArgs() {
            return this.mJvmArgs;
        }

        @Override
        public File getWorkingDirectory() {
            return this.mDirectory;
        }

        @Override
        public String getDescription() {
            return "java process with main class " + this.mMain;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mClasspath", (Object)this.mClasspath).add("mMain", (Object)this.mMain).add("mArgs", this.mArgs).add("mEnvironment", this.mEnvironment).add("mJvmArgs", this.mJvmArgs).toString();
        }
    }
}

