/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.operator.bc;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.ExtendedDigest;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.Signer;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.github.dockerjava.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.github.dockerjava.shaded.org.bouncycastle.operator.OperatorCreationException;
import com.github.dockerjava.shaded.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

