/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import com.github.dockerjava.shaded.com.google.common.base.Preconditions;

public class PullImageCmdImpl
extends AbstrAsyncDockerCmd<PullImageCmd, PullResponseItem>
implements PullImageCmd {
    private String repository;
    private String tag;
    private String registry;
    private AuthConfig authConfig;

    public PullImageCmdImpl(PullImageCmd.Exec exec, AuthConfig authConfig, String repository) {
        super(exec);
        this.withAuthConfig(authConfig);
        this.withRepository(repository);
    }

    @Override
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    @Override
    public PullImageCmd withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getRegistry() {
        return this.registry;
    }

    @Override
    public PullImageCmd withRepository(String repository) {
        Preconditions.checkNotNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    @Override
    public PullImageCmd withTag(String tag) {
        Preconditions.checkNotNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    public PullImageCmd withRegistry(String registry) {
        Preconditions.checkNotNull(registry, "registry was not specified");
        this.registry = registry;
        return this;
    }
}

