/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.depend;

import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.depend.ClassFileIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarFileIterator
implements ClassFileIterator {
    private ZipInputStream jarStream;

    public JarFileIterator(InputStream stream) throws IOException {
        this.jarStream = new ZipInputStream(stream);
    }

    public ClassFile getNextClassFile() {
        ClassFile nextElement = null;
        try {
            ZipEntry jarEntry = this.jarStream.getNextEntry();
            while (nextElement == null && jarEntry != null) {
                String entryName = jarEntry.getName();
                if (!jarEntry.isDirectory() && entryName.endsWith(".class")) {
                    ClassFile javaClass = new ClassFile();
                    javaClass.read(this.jarStream);
                    nextElement = javaClass;
                    continue;
                }
                jarEntry = this.jarStream.getNextEntry();
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            String text = e.getClass().getName();
            if (message != null) {
                text = text + ": " + message;
            }
            throw new RuntimeException("Problem reading JAR file: " + text);
        }
        return nextElement;
    }
}

