/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.types.resources;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Reference;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Resource;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.ResourceCollection;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.ArchiveResource;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.FileProvider;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.FileUtils;
import com.github.dockerjava.shaded.org.apache.tools.zip.ZipEntry;
import com.github.dockerjava.shaded.org.apache.tools.zip.ZipExtraField;
import com.github.dockerjava.shaded.org.apache.tools.zip.ZipFile;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZipResource
extends ArchiveResource {
    private String encoding;
    private ZipExtraField[] extras;
    private int method;

    public ZipResource() {
    }

    public ZipResource(File z, String enc, ZipEntry e) {
        super(z, true);
        this.setEncoding(enc);
        this.setEntry(e);
    }

    public void setZipfile(File z) {
        this.setArchive(z);
    }

    public File getZipfile() {
        FileProvider fp = this.getArchive().as(FileProvider.class);
        return fp.getFile();
    }

    public void addConfigured(ResourceCollection a) {
        super.addConfigured(a);
        if (!a.isFilesystemOnly()) {
            throw new BuildException("only filesystem resources are supported");
        }
    }

    public void setEncoding(String enc) {
        this.checkAttributesAllowed();
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.isReference() ? ((ZipResource)this.getCheckedRef()).getEncoding() : this.encoding;
    }

    public void setRefid(Reference r) {
        if (this.encoding != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        final ZipFile z = new ZipFile(this.getZipfile(), this.getEncoding());
        ZipEntry ze = z.getEntry(this.getName());
        if (ze == null) {
            z.close();
            throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
        }
        return new FilterInputStream(z.getInputStream(ze)){

            public void close() throws IOException {
                FileUtils.close(this.in);
                z.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    super.finalize();
                    throw throwable;
                }
                super.finalize();
            }
        };
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the zip task for zip output.");
    }

    public ZipExtraField[] getExtraFields() {
        if (this.isReference()) {
            return ((ZipResource)this.getCheckedRef()).getExtraFields();
        }
        this.checkEntry();
        if (this.extras == null) {
            return new ZipExtraField[0];
        }
        return this.extras;
    }

    public int getMethod() {
        return this.method;
    }

    protected void fetchEntry() {
        ZipFile z = null;
        try {
            try {
                z = new ZipFile(this.getZipfile(), this.getEncoding());
                this.setEntry(z.getEntry(this.getName()));
            }
            catch (IOException e) {
                this.log(e.getMessage(), 4);
                throw new BuildException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ZipFile.closeQuietly(z);
            throw throwable;
        }
        ZipFile.closeQuietly(z);
    }

    private void setEntry(ZipEntry e) {
        if (e == null) {
            this.setExists(false);
            return;
        }
        this.setName(e.getName());
        this.setExists(true);
        this.setLastModified(e.getTime());
        this.setDirectory(e.isDirectory());
        this.setSize(e.getSize());
        this.setMode(e.getUnixMode());
        this.extras = e.getExtraFields(true);
        this.method = e.getMethod();
    }
}

