/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.util.regexp;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.regexp.RegexpMatcher;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.regexp.RegexpUtil;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Jdk14RegexpMatcher
implements RegexpMatcher {
    private String pattern;

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected Pattern getCompiledPattern(int options) throws BuildException {
        int cOptions = this.getCompilerOptions(options);
        try {
            Pattern p = Pattern.compile(this.pattern, cOptions);
            return p;
        }
        catch (PatternSyntaxException e) {
            throw new BuildException(e);
        }
    }

    public boolean matches(String argument) throws BuildException {
        return this.matches(argument, 0);
    }

    public boolean matches(String input, int options) throws BuildException {
        try {
            Pattern p = this.getCompiledPattern(options);
            return p.matcher(input).find();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public Vector getGroups(String argument) throws BuildException {
        return this.getGroups(argument, 0);
    }

    public Vector getGroups(String input, int options) throws BuildException {
        Pattern p = this.getCompiledPattern(options);
        Matcher matcher = p.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int cnt = matcher.groupCount();
        for (int i = 0; i <= cnt; ++i) {
            String match = matcher.group(i);
            if (match == null) {
                match = "";
            }
            v.addElement(match);
        }
        return v;
    }

    protected int getCompilerOptions(int options) {
        int cOptions = 1;
        if (RegexpUtil.hasFlag(options, 256)) {
            cOptions |= 2;
        }
        if (RegexpUtil.hasFlag(options, 4096)) {
            cOptions |= 8;
        }
        if (RegexpUtil.hasFlag(options, 65536)) {
            cOptions |= 0x20;
        }
        return cOptions;
    }
}

