/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.cert.crmf;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.cmp.PBMParameter;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.github.dockerjava.shaded.org.bouncycastle.cert.crmf.CRMFException;
import com.github.dockerjava.shaded.org.bouncycastle.cert.crmf.PKMACBuilder;
import com.github.dockerjava.shaded.org.bouncycastle.operator.MacCalculator;
import com.github.dockerjava.shaded.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.areEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

