/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cells;

import com.aspose.cells.CellArea;
import com.aspose.cells.Color;
import com.aspose.cells.Hyperlink;
import com.aspose.cells.Name;
import com.aspose.cells.PasteOptions;
import com.aspose.cells.Range;
import com.aspose.cells.Style;
import com.aspose.cells.StyleFlag;
import com.aspose.cells.WorksheetCollection;
import com.aspose.cells.b.a.a.zf;
import com.aspose.cells.b.a.zn;
import com.aspose.cells.b.a.zt;
import com.aspose.cells.zbjl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UnionRange {
    private String c;
    Range[] a;
    final WorksheetCollection b;

    UnionRange(WorksheetCollection parent) {
        this.b = parent;
    }

    UnionRange(WorksheetCollection parent, Range[] rs) {
        this.b = parent;
        this.a = rs;
    }

    UnionRange(UnionRange ur) {
        this.b = ur.b;
        this.c = ur.c;
        if (ur.a != null) {
            this.a = new Range[ur.a.length];
            for (int i = 0; i < ur.a.length; ++i) {
                this.a[i] = new Range(CellArea.g(ur.a[i].a()), ur.a[i].b);
            }
        }
    }

    public int getFirstRow() {
        if (this.a == null || this.a.length == 0) {
            return -1;
        }
        if (this.a.length == 1) {
            return this.a[0].getFirstRow();
        }
        return this.a[0].getFirstRow();
    }

    public int getFirstColumn() {
        if (this.a == null || this.a.length == 0) {
            return -1;
        }
        if (this.a.length == 1) {
            return this.a[0].getFirstColumn();
        }
        return this.a[0].getFirstColumn();
    }

    public int getRowCount() {
        if (this.a == null || this.a.length == 0) {
            return 0;
        }
        if (this.a.length == 1) {
            return this.a[0].getRowCount();
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.a.length; ++i) {
            CellArea cellArea = this.a[i].a();
            for (int j = cellArea.StartRow; j <= cellArea.EndRow; ++j) {
                hashMap.put(j, j);
            }
        }
        return hashMap.size();
    }

    public int getColumnCount() {
        if (this.a == null || this.a.length == 0) {
            return 0;
        }
        if (this.a.length == 1) {
            return this.a[0].getColumnCount();
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.a.length; ++i) {
            CellArea cellArea = this.a[i].a();
            for (int j = cellArea.StartColumn; j <= cellArea.EndColumn; ++j) {
                hashMap.put(j, j);
            }
        }
        return hashMap.size();
    }

    public void merge() {
        if (this.a == null || this.a.length == 0) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].merge();
        }
    }

    public void unMerge() {
        if (this.a == null || this.a.length == 0) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].unMerge();
        }
    }

    public void putValue(String stringValue, boolean isConverted, boolean setStyle) {
        if (this.a == null || this.a.length == 0) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].putValue(stringValue, isConverted, setStyle);
        }
    }

    public Object getValue() {
        if (this.a == null || this.a.length == 0) {
            return null;
        }
        if (this.a.length == 1) {
            return this.a[0].getValue();
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.a.length; ++i) {
            zf.a(arrayList, this.a[i].getValue());
        }
        return arrayList;
    }

    public void setValue(Object value) {
        if (this.a == null || this.a.length == 0) {
            return;
        }
        ArrayList arrayList = zn.a(value, ArrayList.class);
        if (this.a.length == 1) {
            this.a[0].setValue(arrayList == null ? value : arrayList.get(0));
            return;
        }
        if (arrayList != null) {
            for (int i = 0; i < this.a.length; ++i) {
                if (i >= arrayList.size()) continue;
                this.a[i].setValue(arrayList.get(i));
            }
        } else {
            for (int i = 0; i < this.a.length; ++i) {
                this.a[i].setValue(value);
            }
        }
    }

    public String getName() {
        return this.c;
    }

    public void setName(String value) {
        String string = value.trim();
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        this.c = string;
        int n = this.b.getNames().add(this.c);
        Name name = this.b.getNames().get(n);
        name.setRefersTo(this.getRefersTo());
    }

    public String getRefersTo() {
        if (this.a == null || this.a.length == 0) {
            return null;
        }
        if (this.a.length == 1) {
            return this.a[0].getRefersTo();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("=");
        for (int i = 0; i < this.a.length; ++i) {
            Range range = this.a[i];
            String string = range.getRefersTo();
            stringBuilder.append(string.substring(1));
            if (i == this.a.length - 1) continue;
            stringBuilder.append(",");
        }
        return zt.a(stringBuilder);
    }

    public boolean hasRange() {
        return this.a != null && this.a.length != 0;
    }

    public Hyperlink[] getHyperlinks() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].a(arrayList);
        }
        Hyperlink[] hyperlinkArray = new Hyperlink[arrayList.size()];
        for (int i = 0; i < hyperlinkArray.length; ++i) {
            hyperlinkArray[i] = (Hyperlink)arrayList.get(i);
        }
        return hyperlinkArray;
    }

    public void setStyle(Style style) {
        int n = -1;
        if (style != null) {
            n = this.b.a(style);
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].c(n);
        }
    }

    public void applyStyle(Style style, StyleFlag flag) {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].applyStyle(style, flag);
        }
    }

    public void copy(UnionRange range, PasteOptions options) throws Exception {
        if (this.a == null || this.a.length != 1) {
            return;
        }
        if (range.a == null || range.a.length != 1) {
            return;
        }
        this.a[0].copy(range.a[1], options);
    }

    public Iterator iterator() {
        if (this.a == null || this.a.length != 1) {
            return null;
        }
        return this.a[0].iterator();
    }

    public int getCellCount() {
        if (this.a == null || this.a.length == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.a.length; ++i) {
            Range range = this.a[i];
            n += range.getRowCount() * range.getColumnCount();
        }
        return n;
    }

    public int getRangeCount() {
        return this.a == null ? 0 : this.a.length;
    }

    public Range[] getRanges() {
        return this.a;
    }

    public void setOutlineBorders(int[] borderStyles, Color[] borderColors) {
        if (this.a == null) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].setOutlineBorders(borderStyles, borderColors);
        }
    }

    public void setOutlineBorders(int borderStyle, Color borderColor) {
        if (this.a == null) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].setOutlineBorders(borderStyle, borderColor);
        }
    }

    public UnionRange intersect(String range) {
        int n = -1;
        if (this.a != null && this.a.length > 0) {
            n = this.a[0].b.e.getIndex();
        }
        return this.intersect(this.b.createUnionRange(range, n));
    }

    public UnionRange intersect(UnionRange unionRange) {
        return this.intersect(unionRange.a);
    }

    public UnionRange intersect(Range[] ranges) {
        if (ranges == null || ranges.length == 0) {
            return new UnionRange(this.b, this.a);
        }
        if (this.a == null || this.a.length == 0) {
            return new UnionRange(this.b, ranges);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < ranges.length; ++i) {
            UnionRange.a(arrayList, this.a, ranges[i]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Range[] rangeArray = new Range[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            rangeArray[i] = (Range)arrayList.get(i);
        }
        return new UnionRange(this.b, rangeArray);
    }

    private static void a(ArrayList arrayList, Range[] rangeArray, Range range) {
        if (rangeArray.length == 0) {
            arrayList.add(range);
            return;
        }
        for (int i = 0; i < rangeArray.length; ++i) {
            Range range2 = rangeArray[i];
            Range range3 = range2.intersect(range);
            if (range3 == null) continue;
            arrayList.add(range3);
        }
    }

    public UnionRange union(String range) {
        int n = -1;
        if (this.a != null && this.a.length > 0) {
            n = this.a[0].b.e.getIndex();
        }
        return this.union(this.b.createUnionRange(range, n));
    }

    public UnionRange union(UnionRange unionRange) {
        return this.union(unionRange.a);
    }

    public UnionRange union(Range[] ranges) {
        if (ranges == null) {
            return new UnionRange(this.b, this.a);
        }
        if (this.a == null) {
            return new UnionRange(this.b, ranges);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < ranges.length; ++i) {
            this.b(arrayList, this.a, ranges[i]);
        }
        arrayList = UnionRange.a(arrayList);
        Range[] rangeArray = new Range[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            rangeArray[i] = (Range)arrayList.get(i);
        }
        return new UnionRange(this.b, rangeArray);
    }

    private void b(ArrayList arrayList, Range[] rangeArray, Range range) {
        for (int i = 0; i < rangeArray.length; ++i) {
            ArrayList arrayList2 = rangeArray[i].union(range);
            for (int j = 0; j < arrayList2.size(); ++j) {
                Range range2 = (Range)arrayList2.get(j);
                boolean bl = true;
                for (int k = 0; k < arrayList.size(); ++k) {
                    Range range3 = (Range)arrayList.get(k);
                    if (range3.b != range2.b || !range3.a().a(range2.a())) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(range2);
            }
        }
    }

    private static ArrayList a(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<Range> arrayList2 = new ArrayList<Range>();
        while (arrayList.size() > 0) {
            Object object;
            int n;
            ArrayList arrayList3 = new ArrayList();
            Range range = (Range)arrayList.get(0);
            zf.a(arrayList3, range.a());
            arrayList.remove(0);
            for (n = 0; n < arrayList.size(); ++n) {
                object = (Range)arrayList.get(n);
                if (((Range)object).b != range.b) continue;
                zf.a(arrayList3, ((Range)object).a);
                arrayList.remove(n);
                --n;
            }
            zbjl.a(arrayList3);
            for (n = 0; n < arrayList3.size(); ++n) {
                object = (CellArea)arrayList3.get(n);
                arrayList2.add(new Range((CellArea)object, range.b));
            }
        }
        return arrayList2;
    }
}

