/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.dom.Attr;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.z7;
import com.aspose.html.internal.ms.System.Action;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.DateTimeFormatInfo;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p108.z1;
import com.aspose.html.internal.p11.z12;
import com.aspose.html.io.IFileList;
import com.aspose.html.io.z3;

public class HTMLInputElement
extends HTMLElement {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("type", "checked", "multiple", "value", "name", "email", "url", "text", "search", "tel", "password", "date", "month", "week", "time", "color", "datetimelocal");
    private boolean checked;
    private IFileList _files = new z3();
    private boolean argumentParsed = false;
    private boolean checkedAccessed;
    private boolean dirtyChechedness;
    private HTMLFormElement form;
    private String value;
    private boolean valueAccessed;

    public HTMLInputElement(z7 z710, Document document) {
        super(z710, document);
        Node.z4.m20(this).set(Node.z2.m2573, false);
        Node.z4.m20(this).set(Node.z2.m2572, false);
        this.getAttributes().subscribe(z12.m1(new Action<Attr>(){

            public void m1(Attr attr) {
                HTMLInputElement.this.onUpdate(attr);
            }

            @Override
            public /* synthetic */ void invoke(Object object) {
                this.m1((Attr)object);
            }
        }));
    }

    public final String getAccept() {
        return this.getAttributeOrDefault("accept", StringExtensions.Empty);
    }

    public final void setAccept(String string) {
        this.setAttribute("accept", string);
    }

    public final String getAccessKey() {
        return this.getAttributeOrDefault("accesskey", StringExtensions.Empty);
    }

    public final void setAccessKey(String string) {
        this.setAttribute("accesskey", string);
    }

    public final String getAlign() {
        return this.getAttributeOrDefault("align", StringExtensions.Empty);
    }

    public final void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public final String getAlt() {
        return this.getAttributeOrDefault("alt", StringExtensions.Empty);
    }

    public final void setAlt(String string) {
        this.setAttribute("alt", string);
    }

    public final boolean getChecked() {
        this.initCheckedAttribute();
        return this.checked;
    }

    public final void setChecked(boolean bl2) {
        Node.z4.m20(this).set(Node.z2.m2572, true);
        this.checked = bl2;
        this.checkedAccessed = true;
        if (this.checked) {
            this.switchOtherRadioButtonToFalse();
        }
    }

    public final boolean getDefaultChecked() {
        return this.hasAttribute("checked");
    }

    public final void setDefaultChecked(boolean bl2) {
        this.initCheckedAttribute();
        this.toggleAttribute("checked", bl2);
    }

    public final String getDefaultValue() {
        return this.getAttributeOrDefault("value", StringExtensions.Empty);
    }

    public final void setDefaultValue(String string) {
        this.initValueAttribute();
        this.setAttribute("value", string);
    }

    public final boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    public final void setDisabled(boolean bl2) {
        this.toggleAttribute("disabled", bl2);
    }

    public final IFileList getFiles() {
        return this._files;
    }

    public final HTMLFormElement getForm() {
        if (this.form == null) {
            this.form = this.getParentOfType(HTMLFormElement.class);
        }
        return this.form;
    }

    public final void setForm(HTMLFormElement hTMLFormElement) {
        this.form = hTMLFormElement;
    }

    public final String getList() {
        return this.getAttributeOrDefault("list", StringExtensions.Empty);
    }

    public final void setList(String string) {
        this.setAttribute("list", string);
    }

    public final int getMaxLength() {
        return this.getAttributeOrDefault(Short.class, "maxlength", (short)Short.MAX_VALUE).shortValue();
    }

    public final void setMaxLength(int n2) {
        this.setAttribute("maxlength", n2);
    }

    public final String getName() {
        return this.getAttributeOrDefault("name", StringExtensions.Empty);
    }

    public final void setName(String string) {
        this.setAttribute("name", string);
    }

    public final boolean getReadOnly() {
        return this.hasAttribute("readonly");
    }

    public final void setReadOnly(boolean bl2) {
        this.toggleAttribute("readonly", bl2);
    }

    public final int getSize() {
        return this.getAttributeOrDefault(Integer.class, "size", 20);
    }

    public final void setSize(int n2) {
        this.setAttribute("size", n2);
    }

    public final String getSrc() {
        return this.getAttributeOrDefault("src", StringExtensions.Empty);
    }

    public final void setSrc(String string) {
        this.setAttribute("src", string);
    }

    public final int getTabIndex() {
        return this.getAttributeOrDefault(Integer.class, "tabindex", 0);
    }

    public final void setTabIndex(int n2) {
        this.setAttribute("tabindex", n2);
    }

    public final String getType() {
        String string = StringExtensions.toLower(this.getAttributeOrDefault("type", "text"));
        z1 z1100 = z1.m5916;
        z1[] z1Array = new z1[]{z1100};
        boolean bl2 = com.aspose.html.internal.p217.z1.m2(z1.class, string, z1Array);
        z1100 = z1Array[0];
        if (bl2) {
            return string;
        }
        return "text";
    }

    public final void setType(String string) {
        this.setAttribute("type", string);
    }

    public final String getUseMap() {
        return this.getAttributeOrDefault("usemap", StringExtensions.Empty);
    }

    public final void setUseMap(String string) {
        this.setAttribute("usemap", string);
    }

    public final String getValue() {
        this.initValueAttribute();
        return this.value;
    }

    public final void setValue(String string) {
        this.value = string;
        this.valueAccessed = true;
        Node.z4.m20(this).set(Node.z2.m2573, true);
        this.sanitizeValue();
    }

    public final void blur() {
    }

    private boolean checkValidColor(String string) {
        if (string.length() != 7) {
            return false;
        }
        if (string.charAt(0) != '#') {
            return false;
        }
        for (int i2 = 1; i2 < 7; ++i2) {
            if (com.aspose.html.internal.p28.z1.m43(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean checkValidDate(String string) {
        DateTime dateTime = new DateTime();
        DateTime[] dateTimeArray = new DateTime[]{dateTime};
        boolean bl2 = DateTime.tryParse(string, dateTimeArray);
        dateTimeArray[0].CloneTo(dateTime);
        if (bl2) {
            return true;
        }
        if (string.length() != 10) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean bl3 = !this.checkValidMonth(StringExtensions.substring(string, 0, 7), nArray, nArray2);
        n2 = nArray[0];
        n3 = nArray2[0];
        if (bl3) {
            return false;
        }
        if (string.charAt(7) != '-') {
            return false;
        }
        int n4 = 0;
        int[] nArray3 = new int[]{0};
        boolean bl4 = !Int32Extensions.tryParse(StringExtensions.substring(string, 8, 2), nArray3);
        n4 = nArray3[0];
        if (bl4) {
            return false;
        }
        return n4 > 0 && n4 <= DateTime.daysInMonth(n2, n3);
    }

    private boolean checkValidDateTimeLocal(String string) {
        String[] stringArray = StringExtensions.split(string, new char[]{'T'}, (short)1);
        return this.checkValidDate(stringArray[0]) || this.checkValidTime(stringArray[1]);
    }

    private boolean checkValidMonth(String string) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean bl2 = this.checkValidMonth(string, nArray, nArray2);
        n2 = nArray[0];
        n3 = nArray2[0];
        return bl2;
    }

    private boolean checkValidMonth(String string, int[] nArray, int[] nArray2) {
        nArray[0] = 0;
        nArray2[0] = 0;
        if (string.length() != 7) {
            return false;
        }
        if (!Int32Extensions.tryParse(StringExtensions.substring(string, 0, 4), nArray)) {
            return false;
        }
        if (nArray[0] <= 0 && nArray[0] > 9999) {
            return false;
        }
        if (string.charAt(4) != '-') {
            return false;
        }
        if (!Int32Extensions.tryParse(StringExtensions.substring(string, 5, 2), nArray2)) {
            return false;
        }
        return nArray2[0] >= 1 && nArray2[0] <= 12;
    }

    private boolean checkValidTime(String string) {
        int n2 = 0;
        int n3 = 0;
        float f2 = 0.0f;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        float[] fArray = new float[]{0.0f};
        boolean bl2 = this.tryParseTime(string, nArray, nArray2, fArray);
        n2 = nArray[0];
        n3 = nArray2[0];
        f2 = fArray[0];
        return bl2;
    }

    private boolean checkValidWeek(String string) {
        if (string.length() != 8) {
            return false;
        }
        int n2 = 0;
        int[] nArray = new int[]{0};
        boolean bl2 = !Int32Extensions.tryParse(StringExtensions.substring(string, 0, 4), nArray);
        n2 = nArray[0];
        if (bl2) {
            return false;
        }
        if (n2 <= 0 && n2 > 9999) {
            return false;
        }
        if (string.charAt(4) != '-') {
            return false;
        }
        if (string.charAt(5) != 'W') {
            return false;
        }
        int n3 = 0;
        int[] nArray2 = new int[]{0};
        boolean bl3 = !Int32Extensions.tryParse(StringExtensions.substring(string, 6, 2), nArray2);
        n3 = nArray2[0];
        if (bl3) {
            return false;
        }
        int n4 = this.getWeeksInYear(n2);
        return n3 >= 1 && n3 <= n4;
    }

    public final void click() {
    }

    public final void focus() {
    }

    private int getWeeksInYear(int n2) {
        DateTimeFormatInfo dateTimeFormatInfo = DateTimeFormatInfo.getCurrentInfo();
        DateTime dateTime = new DateTime(n2, 12, 31);
        msCalendar msCalendar2 = dateTimeFormatInfo.getCalendar();
        return msCalendar2.getWeekOfYear(dateTime.Clone(), dateTimeFormatInfo.getCalendarWeekRule(), dateTimeFormatInfo.getFirstDayOfWeek());
    }

    private void initCheckedAttribute() {
        if (this.checkedAccessed) {
            return;
        }
        this.checked = this.getDefaultChecked();
        this.checkedAccessed = true;
    }

    private void initValueAttribute() {
        if (this.valueAccessed) {
            return;
        }
        this.value = this.getDefaultValue();
        this.valueAccessed = true;
    }

    private void onUpdate(Attr attr) {
        switch (gStringSwitchMap.of(attr.getName())) {
            case 0: {
                break;
            }
            case 1: {
                if (!Node.z4.m20(this).get(Node.z2.m2572) && this.hasAttribute("checked")) {
                    this.checked = true;
                    this.switchOtherRadioButtonToFalse();
                }
                if (Node.z4.m20(this).get(Node.z2.m2572) || this.hasAttribute("checked")) break;
                this.checked = false;
                break;
            }
            case 2: 
            case 3: {
                Node.z4.m20(this).set(Node.z2.m2573, true);
                this.sanitizeValue();
                break;
            }
            case 4: {
                this.checked = this.hasAttribute("checked");
            }
        }
    }

    private void sanitizeValue() {
        switch (gStringSwitchMap.of(this.getType())) {
            case 5: {
                if (this.hasAttribute("multiple")) {
                    String[] stringArray = StringExtensions.split(this.getValue(), new String[]{","}, 1);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        stringArray[i2] = StringExtensions.trim(stringArray[i2]);
                    }
                    this.value = StringExtensions.join(",", stringArray);
                    break;
                }
                this.value = StringExtensions.trim(StringExtensions.replace(StringExtensions.replace(this.getValue(), "\r", StringExtensions.Empty), "\n", StringExtensions.Empty));
                break;
            }
            case 6: {
                this.value = StringExtensions.trim(StringExtensions.replace(StringExtensions.replace(this.getValue(), "\r", StringExtensions.Empty), "\n", StringExtensions.Empty));
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.value = StringExtensions.replace(StringExtensions.replace(this.getValue(), "\r", StringExtensions.Empty), "\n", StringExtensions.Empty);
                break;
            }
            case 11: {
                if (this.checkValidDate(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 12: {
                if (this.checkValidMonth(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 13: {
                if (this.checkValidWeek(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 14: {
                if (this.checkValidTime(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 15: {
                if (!this.checkValidColor(this.getValue())) {
                    this.value = "#000000";
                    break;
                }
                this.value = StringExtensions.toLower(this.getValue());
                break;
            }
            case 16: {
                this.value = !this.checkValidDateTimeLocal(this.value) ? StringExtensions.Empty : this.getValue();
            }
        }
    }

    public final void select() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchOtherRadioButtonToFalse() {
        if (this.getForm() == null) {
            return;
        }
        IEnumerator iEnumerator = this.getForm().getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element = (Element)iEnumerator.next();
                HTMLInputElement hTMLInputElement = Operators.as(element, HTMLInputElement.class);
                if (hTMLInputElement == null || !"radio".equals(hTMLInputElement.getType()) || hTMLInputElement.getName() == null || !StringExtensions.equals(StringExtensions.toLowerInvariant(hTMLInputElement.getName()), StringExtensions.toLowerInvariant(this.getName())) || this.equals(hTMLInputElement)) continue;
                hTMLInputElement.setChecked(false);
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    private boolean tryParseTime(String string, int[] nArray, int[] nArray2, float[] fArray) {
        boolean bl2 = false;
        nArray[0] = 0;
        int n2 = 0;
        nArray2[0] = 0;
        int n3 = 0;
        fArray[0] = 0.0f;
        int n4 = string.length();
        if (n4 < 5) {
            return false;
        }
        int[] nArray3 = new int[]{0};
        boolean bl3 = !Int32Extensions.tryParse(StringExtensions.substring(string, 0, 2), nArray3);
        n2 = nArray3[0];
        if (bl3) {
            return false;
        }
        if (n2 < 0 || n2 > 23) {
            return false;
        }
        if (string.charAt(2) != ':') {
            return false;
        }
        int[] nArray4 = new int[]{0};
        boolean bl4 = !Int32Extensions.tryParse(StringExtensions.substring(string, 3, 2), nArray4);
        n3 = nArray4[0];
        if (bl4) {
            return false;
        }
        if (n3 < 0 || n3 > 59) {
            return false;
        }
        if (n4 == 5) {
            bl2 = true;
            nArray[0] = n2;
            nArray2[0] = n3;
        }
        if (!bl2 && string.charAt(5) != ':') {
            return false;
        }
        int n5 = 0;
        int[] nArray5 = new int[]{0};
        boolean bl5 = !bl2 && !Int32Extensions.tryParse(StringExtensions.substring(string, 6, 2), nArray5);
        n5 = nArray5[0];
        if (bl5) {
            return false;
        }
        if (!(bl2 || n5 >= 0 && n5 <= 59)) {
            return false;
        }
        if (!bl2 && n4 == 8) {
            fArray[0] = n5;
            bl2 = true;
        }
        if (!bl2 && string.charAt(8) != '.') {
            return false;
        }
        int n6 = 0;
        int[] nArray6 = new int[]{0};
        boolean bl6 = !bl2 && !Int32Extensions.tryParse(StringExtensions.substring(string, 9), nArray6);
        n6 = nArray6[0];
        if (bl6) {
            return false;
        }
        if (!bl2 && n4 > 12) {
            return false;
        }
        return SingleExtensions.tryParse(StringExtensions.concat(Int32Extensions.toString(n5), ".", Int32Extensions.toString(n6)), 167, CultureInfo.getInvariantCulture(), fArray);
    }
}

