/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.css.ICSSStyleSheet;
import com.aspose.html.dom.css.ILinkStyle;
import com.aspose.html.dom.css.IStyleSheet;
import com.aspose.html.internal.ms.System.Action;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.StreamReader;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p177.z7;
import com.aspose.html.internal.p177.z8;
import com.aspose.html.internal.p47.z26;
import com.aspose.html.internal.p47.z27;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.services.INetworkService;
import com.aspose.html.services.z12;
import com.aspose.html.z21;
import java.util.concurrent.atomic.AtomicReference;

public class HTMLLinkElement
extends HTMLElement
implements ILinkStyle {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("alternate", "author", "bookmark", "external", "help", "icon", "license", "next", "nofollow", "noopener", "noreferrer", "prev", "search", "tag", "stylesheet");
    private z2 link;

    public HTMLLinkElement(com.aspose.html.dom.z7 z710, Document document) {
        super(z710, document);
    }

    public final String getCharset() {
        return this.getAttributeOrDefault("charset", StringExtensions.Empty);
    }

    public final void setCharset(String string) {
        this.setAttribute("charset", string);
    }

    public final boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    public final void setDisabled(boolean bl2) {
        this.toggleAttribute("disabled", bl2);
    }

    public final String getHref() {
        String string = this.getAttributeOrDefault("href", StringExtensions.Empty);
        if (string != null && StringExtensions.indexOf(string, "&amp;") != -1) {
            string = StringExtensions.replace(string, "&amp;", "&");
        }
        return string;
    }

    public final void setHref(String string) {
        this.setAttribute("href", string);
    }

    public final String getHreflang() {
        return this.getAttributeOrDefault("hreflang", StringExtensions.Empty);
    }

    public final void setHreflang(String string) {
        this.setAttribute("hreflang", string);
    }

    public final String getMedia() {
        return this.getAttributeOrDefault("media", StringExtensions.Empty);
    }

    public final void setMedia(String string) {
        this.setAttribute("media", string);
    }

    public final String getRel() {
        return this.getAttributeOrDefault("rel", StringExtensions.Empty);
    }

    public final void setRel(String string) {
        this.setAttribute("rel", string);
    }

    public final String getRev() {
        return this.getAttributeOrDefault("rev", StringExtensions.Empty);
    }

    public final void setRev(String string) {
        this.setAttribute("rev", string);
    }

    @Override
    public final IStyleSheet getSheet() {
        if (this.link == null) {
            return null;
        }
        if (this.link.m52() == 14) {
            return ((z3)this.link).getStyleSheet();
        }
        return null;
    }

    public final String getTarget() {
        return this.getAttributeOrDefault("target", StringExtensions.Empty);
    }

    public final void setTarget(String string) {
        this.setAttribute("target", string);
    }

    public final String getType() {
        return this.getAttributeOrDefault("type", StringExtensions.Empty);
    }

    public final void setType(String string) {
        this.setAttribute("type", string);
    }

    @Override
    protected void dispose(boolean bl2) {
        if (this.link != null) {
            this.link.dispose();
        }
        super.dispose(bl2);
    }

    private void updateLink(String string) {
        if (this.link != null) {
            this.link.dispose();
        }
        if (string == null) {
            return;
        }
        switch (gStringSwitchMap.of(StringExtensions.toLowerInvariant(string))) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                this.link = new z3(this);
            }
        }
    }

    private static class z3
    extends z2 {
        private AtomicReference<Action> m126 = new AtomicReference();
        private z7 m127;
        private z27 m128;

        public z3(final HTMLLinkElement hTMLLinkElement) {
            super(hTMLLinkElement, (byte)14);
            if (StringExtensions.isNullOrEmpty(hTMLLinkElement.getHref())) {
                return;
            }
            if (hTMLLinkElement.getParentElement() == null) {
                return;
            }
            final com.aspose.html.z1[] z1Array = new com.aspose.html.z1[]{(com.aspose.html.z1)hTMLLinkElement.getOwnerDocument().getContext()};
            final z26[] z26Array = new z26[]{(z26)z1Array[0].m3()};
            final z8[] z8Array = new z8[]{z1Array[0].m15()};
            this.m128 = z26Array[0].m14(hTMLLinkElement);
            ((com.aspose.html.dom.css.z7)hTMLLinkElement.getOwnerDocument().getStyleSheets()).m3(this.m128);
            final Url[] urlArray = new Url[]{null};
            try {
                urlArray[0] = z1Array[0].getService(INetworkService.class).getUrlResolver().resolve(hTMLLinkElement.getOwnerDocument().getBaseURI(), hTMLLinkElement.getHref());
            }
            catch (com.aspose.html.z8 z810) {
                if ("TypeError".equals(z810.getName())) {
                    return;
                }
                throw z810;
            }
            this.m128.setHref(urlArray[0].getHref());
            this.m127 = z8Array[0].m10(new Action(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void invoke(Object object) {
                    block12: {
                        RequestMessage requestMessage = new RequestMessage(urlArray[0]);
                        try {
                            ResponseMessage responseMessage = z1Array[0].getNetwork().send(requestMessage);
                            try {
                                if (!responseMessage.isSuccess()) break block12;
                                StreamReader streamReader = new StreamReader(responseMessage.getContent().readAsStream(), z21.m10(responseMessage.getHeaders().getContentType().getCharSet()));
                                try {
                                    z26Array[0].m1(m128, streamReader.readToEnd());
                                }
                                finally {
                                    if (streamReader != null) {
                                        streamReader.dispose();
                                    }
                                }
                            }
                            finally {
                                if (responseMessage != null) {
                                    responseMessage.dispose();
                                }
                            }
                        }
                        finally {
                            if (requestMessage != null) {
                                requestMessage.dispose();
                            }
                        }
                    }
                }
            });
            final boolean[] blArray = new boolean[]{false};
            final z12[] z12Array = new z12[]{z1Array[0].getService(z12.class)};
            this.m127 = com.aspose.html.internal.p179.z1.m1(this.m127, new Action(){

                public void invoke(Object object) {
                    m128.m20(true);
                    if (!blArray[0]) {
                        z8Array[0].m1(new Action(){

                            public void invoke(Object object) {
                                hTMLLinkElement.dispatchEvent(z12Array[0].createEvent("load"));
                            }
                        }, (byte)1);
                    }
                    Action action = null;
                    action = m126.getAndSet(null);
                    if (action != null) {
                        action.invoke(this);
                    }
                }
            }, new Action<Exception>(){

                public void m1(Exception exception) {
                    blArray[0] = true;
                    z8Array[0].m1(new Action(){

                        public void invoke(Object object) {
                            hTMLLinkElement.dispatchEvent(z12Array[0].createEvent("error"));
                        }
                    }, (byte)1);
                }

                @Override
                public /* synthetic */ void invoke(Object object) {
                    this.m1((Exception)object);
                }
            });
            this.m126.set(new Action(){

                public void invoke(Object object) {
                    Node.z4.m20(hTMLLinkElement.getOwnerDocument()).m61(Node.z2.m2570);
                }
            });
            Node.z4.m20(hTMLLinkElement.getOwnerDocument()).m62(Node.z2.m2570);
            z8Array[0].m5(this.m127);
        }

        public final ICSSStyleSheet getStyleSheet() {
            return this.m128;
        }

        @Override
        protected void dispose(boolean bl2) {
            if (bl2) {
                if (this.m127 != null) {
                    this.m127.cancel();
                }
                if (this.m128 != null) {
                    ((com.aspose.html.dom.css.z7)this.m51().getOwnerDocument().getStyleSheets()).m4(this.m128);
                }
                Action action = null;
                action = this.m126.getAndSet(null);
                if (action != null) {
                    action.invoke(this);
                }
            }
            super.dispose(bl2);
        }
    }

    private static class z2
    implements IDisposable {
        private HTMLLinkElement m124;
        private byte m125;

        protected z2(HTMLLinkElement hTMLLinkElement, byte by2) {
            this.m1(hTMLLinkElement);
            this.m2(by2);
        }

        public final HTMLLinkElement m51() {
            return this.m124;
        }

        private void m1(HTMLLinkElement hTMLLinkElement) {
            this.m124 = hTMLLinkElement;
        }

        public final byte m52() {
            return this.m125;
        }

        private void m2(byte by2) {
            this.m125 = by2;
        }

        @Override
        public final void dispose() {
            this.dispose(true);
            GC.suppressFinalize(this);
        }

        protected void dispose(boolean bl2) {
            if (bl2) {
                this.m1(null);
            }
        }
    }

    public static class z1 {
        public static void m1(HTMLLinkElement hTMLLinkElement, String string) {
            hTMLLinkElement.updateLink(string);
        }
    }
}

