/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLButtonElement;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLInputElement;
import com.aspose.html.HTMLObjectElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.HTMLSelectElement;
import com.aspose.html.HTMLTextAreaElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.z1;
import com.aspose.html.forms.FormEditor;
import com.aspose.html.forms.SubmissionResult;
import com.aspose.html.internal.ms.System.ApplicationException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.Net.CookieContainer;
import com.aspose.html.internal.ms.System.Net.CredentialCache;
import com.aspose.html.internal.ms.System.Net.ICredentials;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p120.z3;
import com.aspose.html.internal.p120.z7;
import com.aspose.html.internal.p198.z4;
import com.aspose.html.internal.p283.z38;
import com.aspose.html.io.z2;
import com.aspose.html.net.ByteArrayContent;
import com.aspose.html.net.Content;
import com.aspose.html.net.FormUrlEncodedContent;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.net.MultipartFormDataContent;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.StringContent;
import com.aspose.html.services.z24;
import com.aspose.html.z1;
import com.aspose.html.z10;
import com.aspose.html.z20;
import com.aspose.time.TimeSpan;

public class FormSubmitter
implements IDisposable {
    private String _action;
    private HTMLFormElement _form;
    private HttpMethod _method;
    private SubmissionResult lastResult;
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");

    public final String getAction() {
        if (this._action == null) {
            return this._form.getAction();
        }
        return this._action;
    }

    public final void setAction(String string) {
        this._action = string;
    }

    public final HttpMethod getMethod() {
        if (this._method == null) {
            if (!StringExtensions.isNullOrEmpty(this._form.getMethod())) {
                return new HttpMethod(this._form.getMethod());
            }
            return HttpMethod.getGet();
        }
        return this._method;
    }

    public final void setMethod(HttpMethod httpMethod) {
        this._method = httpMethod;
    }

    public FormSubmitter(FormEditor formEditor) {
        this._form = formEditor.getForm();
    }

    public FormSubmitter(HTMLDocument hTMLDocument, int n2) {
        HTMLFormElement hTMLFormElement = Operators.as(hTMLDocument.getForms().get_Item(n2), HTMLFormElement.class);
        if (hTMLFormElement == null) {
            z10.m30();
        }
        this._form = hTMLFormElement;
    }

    public FormSubmitter(HTMLDocument hTMLDocument, String string) {
        HTMLFormElement hTMLFormElement;
        Element element = hTMLDocument.getElementById(string);
        if (element == null) {
            z10.m40();
        }
        if ((hTMLFormElement = Operators.as(element, HTMLFormElement.class)) == null) {
            z10.m45();
        }
        this._form = hTMLFormElement;
    }

    public FormSubmitter(HTMLFormElement hTMLFormElement) {
        this._form = hTMLFormElement;
    }

    @Override
    public final void dispose() {
        this._form = null;
        if (this.lastResult != null) {
            this.lastResult.dispose();
            this.lastResult = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<z38<String, z4, String>> getDataSetFromForm(HTMLElement hTMLElement) {
        List<HTMLElement> list = this.getSubmittableElements(hTMLElement);
        List<z38<String, z4, String>> list2 = new List<z38<String, z4, String>>();
        IGenericEnumerator iGenericEnumerator = list.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IDisposable iDisposable;
                Object object;
                IDisposable iDisposable2;
                HTMLElement hTMLElement2 = (HTMLElement)iGenericEnumerator.next();
                String string = this.getTypeOfField(hTMLElement2);
                if ("image".equals(string)) continue;
                String string2 = hTMLElement2.getAttribute("name");
                z20 z2010 = Element.z1.m16(hTMLElement2);
                if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2244)) {
                    iDisposable2 = ((HTMLSelectElement)hTMLElement2).getOptions().iterator();
                    try {
                        while (iDisposable2.hasNext()) {
                            object = (Element)iDisposable2.next();
                            iDisposable = (HTMLOptionElement)object;
                            if (!((HTMLOptionElement)iDisposable).getSelected() || ((HTMLOptionElement)iDisposable).getDisabled()) continue;
                            list2.addItem(new z38<String, z4, String>(string2, z4.m294(((HTMLOptionElement)iDisposable).getValue()), string));
                        }
                        continue;
                    }
                    finally {
                        if (!Operators.is(iDisposable2, IDisposable.class)) continue;
                        iDisposable2.dispose();
                        continue;
                    }
                }
                if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2186)) {
                    iDisposable2 = (HTMLInputElement)hTMLElement2;
                    if ("checkbox".equals(((HTMLInputElement)iDisposable2).getType()) || "radio".equals(((HTMLInputElement)iDisposable2).getType())) {
                        object = "on";
                        if (hTMLElement2.hasAttribute("value")) {
                            object = ((HTMLInputElement)hTMLElement2).getValue();
                        }
                        list2.addItem(new z38<String, z4, String>(string2, z4.m294((String)object), string));
                        continue;
                    }
                    if ("file".equals(((HTMLInputElement)iDisposable2).getType())) {
                        boolean bl2 = false;
                        iDisposable = ((HTMLInputElement)hTMLElement2).getFiles().iterator();
                        try {
                            while (iDisposable.hasNext()) {
                                z2 z2100 = (z2)iDisposable.next();
                                list2.addItem(new z38<String, z4, String>(string2, z4.m3(z2100), string));
                                bl2 = true;
                            }
                        }
                        finally {
                            if (Operators.is(iDisposable, IDisposable.class)) {
                                iDisposable.dispose();
                            }
                        }
                        if (bl2) continue;
                        list2.addItem(new z38<String, z4, String>(string2, z4.m294(StringExtensions.Empty), "application/octet-stream"));
                        continue;
                    }
                    list2.addItem(new z38<String, z4, String>(string2, z4.m294(((HTMLInputElement)hTMLElement2).getValue()), string));
                    continue;
                }
                if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2264)) {
                    list2.addItem(new z38<String, z4, String>(string2, z4.m294(((HTMLTextAreaElement)hTMLElement2).getValue()), string));
                    continue;
                }
                if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2216)) continue;
                list2.addItem(new z38<String, z4, String>(string2, z4.m294(((HTMLInputElement)hTMLElement2).getValue()), string));
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        int n2 = 0;
        while (n2 < list2.size()) {
            if (!"file".equals(list2.get_Item(n2).m164()) && !"textarea".equals(list2.get_Item(n2).m164())) {
                list2.set_Item(n2, new z38<String, z4, String>(FormSubmitter.normalizeLineBreaks(list2.get_Item(n2).m161()), z4.m294(FormSubmitter.normalizeLineBreaks(list2.get_Item(n2).m162().getStringValue())), list2.get_Item(n2).m164()));
            }
            ++n2;
        }
        return list2;
    }

    private String getEnctypeFromSubmitter(HTMLElement hTMLElement) {
        String string;
        if (hTMLElement != null && !StringExtensions.isNullOrEmpty(string = hTMLElement.getAttribute("formenctype"))) {
            return StringExtensions.toLower(string);
        }
        return StringExtensions.toLower(this._form.getEnctype());
    }

    private HttpMethod getMethodFromSubmitter(HTMLElement hTMLElement) {
        String string;
        if (hTMLElement != null && !StringExtensions.isNullOrEmpty(string = hTMLElement.getAttribute("formethod"))) {
            return new HttpMethod(string);
        }
        return this.getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLElement getSubmitButton() {
        IEnumerator iEnumerator = this._form.getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element = (Element)iEnumerator.next();
                z20 z2010 = Element.z1.m16(element);
                if ((!ObjectExtensions.referenceEquals(z2010, z1.z5.m2186) || !StringExtensions.equals("submit", ((HTMLInputElement)element).getType(), (short)5)) && (!ObjectExtensions.referenceEquals(z2010, z1.z5.m2107) || !StringExtensions.equals("submit", ((HTMLButtonElement)element).getType(), (short)5))) continue;
                HTMLElement hTMLElement = (HTMLElement)element;
                return hTMLElement;
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HTMLElement> getSubmittableElements(HTMLElement hTMLElement) {
        List<HTMLElement> list = new List<HTMLElement>();
        IEnumerator iEnumerator = this._form.getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element = (Element)iEnumerator.next();
                z20 z2010 = Element.z1.m16(element);
                if (!ObjectExtensions.referenceEquals(z2010, z1.z5.m2186) && !ObjectExtensions.referenceEquals(z2010, z1.z5.m2216) && !ObjectExtensions.referenceEquals(z2010, z1.z5.m2244) && !ObjectExtensions.referenceEquals(z2010, z1.z5.m2264) || !this.isValidElementToSubmit((HTMLElement)element, hTMLElement)) continue;
                list.addItem((HTMLElement)element);
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return list;
    }

    private String getTypeOfField(HTMLElement hTMLElement) {
        if (Operators.is(hTMLElement, HTMLInputElement.class)) {
            return ((HTMLInputElement)hTMLElement).getType();
        }
        if (Operators.is(hTMLElement, HTMLSelectElement.class)) {
            return ((HTMLSelectElement)hTMLElement).getType();
        }
        if (Operators.is(hTMLElement, HTMLButtonElement.class)) {
            return ((HTMLButtonElement)hTMLElement).getType();
        }
        if (Operators.is(hTMLElement, HTMLObjectElement.class)) {
            return ((HTMLObjectElement)hTMLElement).getType();
        }
        if (Operators.is(hTMLElement, HTMLTextAreaElement.class)) {
            return ((HTMLTextAreaElement)hTMLElement).getType();
        }
        return StringExtensions.Empty;
    }

    private boolean isValidElementToSubmit(HTMLElement hTMLElement, HTMLElement hTMLElement2) {
        if (ObjectExtensions.referenceEquals(Element.z1.m16(hTMLElement.getParentElement()), z1.z5.m2120)) {
            return false;
        }
        if (hTMLElement.hasAttribute("disabled")) {
            return false;
        }
        z20 z2010 = Element.z1.m16(hTMLElement);
        if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2107) && !hTMLElement.equals(hTMLElement2)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2186)) {
            HTMLInputElement hTMLInputElement = (HTMLInputElement)hTMLElement;
            if ("checkbox".equals(StringExtensions.toLower(hTMLInputElement.getType())) && !hTMLInputElement.getChecked()) {
                return false;
            }
            if ("radio".equals(StringExtensions.toLower(hTMLInputElement.getType())) && !hTMLInputElement.getChecked() && hTMLInputElement.getValue() != null && !"checked".equals(StringExtensions.toLower(hTMLInputElement.getValue()))) {
                return false;
            }
            if (!"image".equals(hTMLInputElement.getType()) && StringExtensions.isNullOrEmpty(hTMLInputElement.getAttribute("name"))) {
                return false;
            }
        }
        return !ObjectExtensions.referenceEquals(z2010, z1.z5.m2264) || !StringExtensions.isNullOrEmpty(hTMLElement.getAttribute("name"));
    }

    private static String normalizeLineBreaks(String string) {
        msStringBuilder msStringBuilder2 = new msStringBuilder(Operators.castToInt32((double)string.length() * 1.1, 14));
        boolean bl2 = false;
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2) {
                bl2 = false;
                if (c2 == '\n') continue;
            }
            switch (c2) {
                case '\r': {
                    msStringBuilder2.append("\r\n");
                    bl2 = true;
                    continue block4;
                }
                case '\n': {
                    msStringBuilder2.append("\r\n");
                    continue block4;
                }
                default: {
                    msStringBuilder2.append(c2);
                }
            }
        }
        return msStringBuilder2.toString();
    }

    private Encoding pickEncodingForForm() {
        if (this._form.hasAttribute("accept-charset")) {
            String[] stringArray;
            String string = this._form.getAttribute("accept-charset");
            for (String string2 : stringArray = StringExtensions.split(string, new String[]{" "}, 1)) {
                try {
                    return Encoding.getEncoding(string2);
                }
                catch (RuntimeException runtimeException) {
                }
            }
        }
        return com.aspose.html.dom.z1.m2041;
    }

    public final SubmissionResult submit() {
        return this.submit(CredentialCache.getDefaultCredentials(), TimeSpan.fromSeconds(100.0).Clone(), false, Document.z1.m13(this._form.getOwnerDocument()));
    }

    public final SubmissionResult submit(CookieContainer cookieContainer) {
        return this.submit(CredentialCache.getDefaultCredentials(), TimeSpan.fromSeconds(100.0).Clone(), false, cookieContainer);
    }

    public final SubmissionResult submit(ICredentials iCredentials) {
        return this.submit(iCredentials, TimeSpan.fromSeconds(100.0).Clone(), true);
    }

    public final SubmissionResult submit(ICredentials iCredentials, CookieContainer cookieContainer) {
        return this.submit(iCredentials, TimeSpan.fromSeconds(100.0).Clone(), true, cookieContainer);
    }

    public final SubmissionResult submit(ICredentials iCredentials, TimeSpan timeSpan) {
        return this.submit(iCredentials, timeSpan.Clone(), true, Document.z1.m13(this._form.getOwnerDocument()));
    }

    public final SubmissionResult submit(ICredentials iCredentials, TimeSpan timeSpan, CookieContainer cookieContainer) {
        return this.submit(iCredentials, timeSpan.Clone(), true, cookieContainer);
    }

    public final SubmissionResult submit(ICredentials iCredentials, TimeSpan timeSpan, boolean bl2) {
        return this.submit(iCredentials, timeSpan.Clone(), bl2, Document.z1.m13(this._form.getOwnerDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SubmissionResult submit(ICredentials iCredentials, TimeSpan timeSpan, boolean bl2, CookieContainer cookieContainer) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        HttpMethod httpMethod;
        Object object6;
        Object object7;
        HTMLDocument hTMLDocument = (HTMLDocument)this._form.getOwnerDocument();
        if ((hTMLDocument.getContext().getSecurity() & 0x20) == 32) {
            return null;
        }
        HTMLElement hTMLElement = this.getSubmitButton();
        Object object8 = this.getAction();
        if (StringExtensions.isNullOrEmpty((String)object8)) {
            object8 = hTMLDocument.getDocumentURI();
        }
        if (hTMLElement != null && !StringExtensions.isNullOrEmpty((String)(object7 = hTMLElement.getAttribute("formaction")))) {
            object8 = object7;
        }
        object7 = new Url((String)object8, hTMLDocument.getBaseURI());
        List<z38<String, z4, String>> list = this.getDataSetFromForm(hTMLElement);
        IDisposable iDisposable = z3.z1.m2(this._form.getOwnerDocument(), list);
        try {
            object6 = ((Url)object7).getProtocol();
            if (!StringExtensions.equals((String)object6, "http:", (short)4) && !StringExtensions.equals((String)object6, "https:", (short)4)) {
                throw new NotSupportedException(StringExtensions.format("Protocol {0} is not supported.", object6));
            }
            httpMethod = this.getMethodFromSubmitter(hTMLElement);
            string = this.getEnctypeFromSubmitter(hTMLElement);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
        object6 = (z1)this._form.getOwnerDocument().getContext();
        if (HttpMethod.op_Equality(HttpMethod.getGet(), httpMethod)) {
            z7 z710 = new z7((z1)object6);
            try {
                ((Url)object7).setSearch(((z1)object6).getService(z24.class).m1762().m19(list));
                RequestMessage requestMessage = new RequestMessage((Url)object7);
                requestMessage.setMethod(HttpMethod.getGet());
                requestMessage.setCredentials(iCredentials);
                requestMessage.setPreAuthenticate(true);
                requestMessage.setCookieContainer(cookieContainer);
                SubmissionResult submissionResult = this.lastResult = new SubmissionResult(requestMessage, this._form.getOwnerDocument().getContext().getNetwork().send(requestMessage), this._form);
                return submissionResult;
            }
            finally {
                if (z710 != null) {
                    z710.dispose();
                }
            }
        }
        Encoding encoding = this.pickEncodingForForm();
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>();
        switch (gStringSwitchMap.of(string)) {
            case 0: {
                object5 = list.iterator();
                try {
                    while (object5.hasNext()) {
                        object4 = (z38)object5.next();
                        object3 = ((z4)((z38)object4).m162()).getStringValue();
                        if (!StringExtensions.isNullOrEmpty((String)((z38)object4).m164()) && "hidden".equals(((z38)object4).m164()) && "_charset_".equals(((z38)object4).m161())) {
                            object3 = this.pickEncodingForForm().getEncodingName();
                        }
                        list2.addItem(new KeyValuePair<String, Object>((String)((z38)object4).m161(), object3));
                    }
                }
                finally {
                    if (Operators.is(object5, IDisposable.class)) {
                        ((IDisposable)object5).dispose();
                    }
                }
                object2 = new FormUrlEncodedContent(list2);
                break;
            }
            case 1: {
                object5 = encoding.getEncodingName();
                object4 = new MultipartFormDataContent();
                object3 = list.iterator();
                try {
                    while (object3.hasNext()) {
                        object = (z38)object3.next();
                        byte[] byArray = ((z4)((z38)object).m162()).m1797();
                        if (!StringExtensions.isNullOrEmpty((String)((z38)object).m164()) && "hidden".equals(((z38)object).m164()) && "_charset_".equals(((z38)object).m161())) {
                            byArray = com.aspose.html.dom.z1.m2041.getBytes((String)object5);
                        }
                        ByteArrayContent byteArrayContent = new ByteArrayContent(byArray);
                        if ("file".equals(((z38)object).m164())) {
                            String string2 = Path.getFileName(((z4)((z38)object).m162()).getName());
                            ((MultipartFormDataContent)object4).add(byteArrayContent, (String)((z38)object).m161(), string2);
                            continue;
                        }
                        ((MultipartFormDataContent)object4).add(byteArrayContent, (String)((z38)object).m161());
                    }
                }
                finally {
                    if (Operators.is(object3, IDisposable.class)) {
                        ((IDisposable)object3).dispose();
                    }
                }
                object2 = object4;
                break;
            }
            case 2: {
                object5 = list.iterator();
                try {
                    while (object5.hasNext()) {
                        object4 = (z38)object5.next();
                        object3 = ((z4)((z38)object4).m162()).getStringValue();
                        if (!StringExtensions.isNullOrEmpty((String)((z38)object4).m164()) && "hidden".equals(((z38)object4).m164()) && "_charset_".equals(((z38)object4).m161())) {
                            object3 = encoding.getEncodingName();
                        }
                        list2.addItem(new KeyValuePair<String, Object>((String)((z38)object4).m161(), object3));
                    }
                }
                finally {
                    if (Operators.is(object5, IDisposable.class)) {
                        ((IDisposable)object5).dispose();
                    }
                }
                object4 = new msStringBuilder();
                object3 = list2.iterator();
                try {
                    while (object3.hasNext()) {
                        object = (KeyValuePair)object3.next();
                        ((msStringBuilder)object4).append((String)((KeyValuePair)object).getKey());
                        ((msStringBuilder)object4).append('=');
                        ((msStringBuilder)object4).append((String)((KeyValuePair)object).getValue());
                        ((msStringBuilder)object4).append("\r\n");
                    }
                }
                finally {
                    if (Operators.is(object3, IDisposable.class)) {
                        ((IDisposable)object3).dispose();
                    }
                }
                object2 = new StringContent(((msStringBuilder)object4).toString(), encoding);
                break;
            }
            default: {
                throw new ApplicationException(StringExtensions.format("The enctype '{0}' is not supported while submitting data to the server.", string));
            }
        }
        object5 = z3.z2.m1(this._form.getOwnerDocument(), ((Content)object2).readAsStream());
        try {
            object4 = new z7((z1)object6);
            try {
                object3 = new RequestMessage((Url)object7);
                ((RequestMessage)object3).setMethod(httpMethod);
                ((RequestMessage)object3).setContent((Content)object2);
                ((RequestMessage)object3).setCredentials(iCredentials);
                ((RequestMessage)object3).setPreAuthenticate(bl2);
                ((RequestMessage)object3).setTimeout(timeSpan.Clone());
                ((RequestMessage)object3).setCookieContainer(cookieContainer);
                this.lastResult = new SubmissionResult((RequestMessage)object3, this._form.getOwnerDocument().getContext().getNetwork().send((RequestMessage)object3), this._form);
                object = this.lastResult;
                if (object4 != null) {
                    object4.dispose();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (object4 != null) {
                    object4.dispose();
                }
                throw throwable;
            }
        }
        finally {
            if (object5 != null) {
                object5.dispose();
            }
        }
    }

    public final SubmissionResult submit(TimeSpan timeSpan) {
        return this.submit(CredentialCache.getDefaultCredentials(), timeSpan.Clone(), false);
    }

    public final SubmissionResult submit(TimeSpan timeSpan, CookieContainer cookieContainer) {
        return this.submit(CredentialCache.getDefaultCredentials(), timeSpan.Clone(), false, cookieContainer);
    }
}

