/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.ArrayTypeMismatchException;
import com.aspose.html.internal.ms.System.Collections.Comparer;
import com.aspose.html.internal.ms.System.Collections.Generic.EqualityComparer;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IList;
import com.aspose.html.internal.ms.System.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.html.internal.ms.System.Comparison;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;
import com.aspose.html.internal.ms.System.InvalidCastException;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.RankException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.TypeLoadException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.ConversionUtils;
import com.aspose.html.internal.ms.core.System.a;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.Comparator;

public abstract class Array
implements ICollection,
IEnumerable,
IList,
ICloneable {
    private Array() {
    }

    protected abstract Object getInternalObject();

    protected abstract Info getArrayInfo();

    protected abstract a getArrayHelper();

    protected abstract ArrayEnumerator createEnumerator(int var1, int var2);

    public static Array boxing(Object object) {
        return Array.a(object, 1, false);
    }

    public static Array boxing(Object object, int n2) {
        return Array.a(object, n2, false);
    }

    public static Array boxing(Object object, int n2, boolean bl2) {
        return Array.a(object, n2, bl2);
    }

    private static Box a(Object object, int n2, boolean bl2) {
        if (object == null) {
            return null;
        }
        if (n2 < 1) {
            throw new ArgumentException("Incorrect dimension of array", "rank");
        }
        switch (n2) {
            case 1: {
                return new OneDimensional(object, bl2);
            }
        }
        return new MultiDimensional(object, n2, bl2);
    }

    public static Object unboxing(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array is null");
        }
        return array.getInternalObject();
    }

    public static <T> IGenericList<T> toGenericList(T[] TArray) {
        Array array = Array.boxing(TArray);
        if (array == null) {
            return null;
        }
        return Array.toGenericList(array);
    }

    public static <T> IGenericList<T> toGenericList(Array array) {
        return new GenericArray(array);
    }

    public static <T> ReadOnlyCollection<T> asReadOnly(T[] TArray) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        return new ReadOnlyCollection<T>(Array.toGenericList(TArray));
    }

    public static int binarySearch(Array array, Object object) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (object == null) {
            return -1;
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (!(object instanceof Comparable)) {
            throw new InvalidOperationException("Failed to compare two elements in the array.");
        }
        return Array.a(array, array.getLowerBound(0), array.getLength(0), object, null);
    }

    public static int binarySearch(Array array, Object object, Comparator comparator) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (comparator == null && object != null && !(object instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return Array.a(array, array.getLowerBound(0), array.getLength(0), object, comparator);
    }

    public static int binarySearch(Array array, int n2, int n3, Object object) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (n2 < array.getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 > array.getLowerBound(0) + array.getLength(0) - n3) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (object != null && !(object instanceof Comparable)) {
            throw new ArgumentException("value does not support IComparable");
        }
        return Array.a(array, n2, n3, object, null);
    }

    public static int binarySearch(Array array, int n2, int n3, Object object, Comparator comparator) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (n2 < array.getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 > array.getLowerBound(0) + array.getLength(0) - n3) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (comparator == null && object != null && !(object instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return Array.a(array, n2, n3, object, comparator);
    }

    static int a(Array array, int n2, int n3, Object object, Comparator comparator) {
        if (comparator == null) {
            comparator = Comparer.Default;
        }
        int n4 = n2;
        int n5 = n2 + n3 - 1;
        int n6 = 0;
        while (n4 <= n5) {
            int n7 = n4 + (n5 - n4) / 2;
            Object object2 = array.getValueImpl(n7);
            try {
                n6 = comparator.compare(object2, object);
            }
            catch (java.lang.Exception exception) {
                throw new ArgumentException("value is not of the same type", exception);
            }
            if (n6 == 0) {
                return n7;
            }
            if (n6 > 0) {
                n5 = n7 - 1;
                continue;
            }
            n4 = n7 + 1;
        }
        return ~n4;
    }

    public static <T> int binarySearch(T[] TArray, T t2) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        return Array.binarySearch(TArray, 0, Array.boxing(TArray).getLength(), t2, null);
    }

    public static <T> int binarySearch(T[] TArray, T t2, Comparator<T> comparator) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        return Array.binarySearch(TArray, 0, Array.boxing(TArray).getLength(), t2, comparator);
    }

    public static <T> int binarySearch(T[] TArray, int n2, int n3, T t2) {
        return Array.binarySearch(TArray, n2, n3, t2, null);
    }

    public static <T> int binarySearch(T[] TArray, int n2, int n3, T t2, Comparator<T> comparator) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 > Array.boxing(TArray).getLength() - n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (comparator == null) {
            comparator = com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault();
        }
        int n4 = n2;
        int n5 = n2 + n3 - 1;
        int n6 = 0;
        try {
            while (n4 <= n5) {
                int n7 = n4 + (n5 - n4) / 2;
                n6 = comparator.compare(t2, TArray[n7]);
                if (n6 == 0) {
                    return n7;
                }
                if (n6 < 0) {
                    n5 = n7 - 1;
                    continue;
                }
                n4 = n7 + 1;
            }
        }
        catch (Exception exception) {
            throw new InvalidOperationException("Comparer threw an exception.", exception);
        }
        return ~n4;
    }

    public static void clear(Array array, int n2, int n3) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (n3 < 0) {
            throw new IndexOutOfRangeException("Non-negative number required.");
        }
        int n4 = array.getLowerBound(0);
        if (n2 < n4) {
            throw new IndexOutOfRangeException("index < lower bound");
        }
        if ((n2 -= n4) > array.getLength() - n3) {
            throw new IndexOutOfRangeException("index + length > size");
        }
        ArrayEnumerator arrayEnumerator = array.createEnumerator(n2, n3);
        Class clazz = array.getArrayInfo().b;
        while (arrayEnumerator.hasNext()) {
            arrayEnumerator.a(Operators.defaultValue(clazz));
        }
    }

    @Override
    public Object deepClone() {
        if (this.getRank() > 1) {
            throw new NotImplementedException();
        }
        Info info = this.getArrayInfo();
        Array array = Array.createInstance(Operators.typeOf(info.b), (int)info.e);
        this.copyTo(array, 0);
        return array;
    }

    public static void constrainedCopy(Array array, int n2, Array array2, int n3, int n4) {
        Array.copy(array, n2, array2, n3, n4);
    }

    public static void copy(Array array, Array array2, int n2) {
        if (array == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (array2 == null) {
            throw new ArgumentNullException("destinationArray");
        }
        Array.copy(array, array.getLowerBound(0), array2, array2.getLowerBound(0), n2);
    }

    public static void copy(Array array, int n2, Array array2, int n3, int n4) {
        if (array == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (array2 == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (n4 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Non-negative number required.");
        }
        if (n2 > array.getLength() - n4) {
            throw new ArgumentException("length");
        }
        if (n3 > array2.getLength() - n4) {
            String string = StringExtensions.concat("Destination array was not long enough. Check ", "destIndex and length, and the array's lower bounds");
            throw new ArgumentException(string, StringExtensions.Empty);
        }
        if (array.getRank() != array2.getRank()) {
            throw new RankException("Arrays must be of same size.");
        }
        Class clazz = array.getArrayInfo().b;
        Class clazz2 = array2.getArrayInfo().b;
        boolean bl2 = Struct.class.isAssignableFrom(clazz);
        if (!bl2 && array.getRank() == 1 && Array.a(array, n2, array2, n3, n4)) {
            return;
        }
        if (ObjectExtensions.referenceEquals(Array.unboxing(array), Array.unboxing(array2)) && Array.a(n2, n3, n4)) {
            Type type = Operators.typeOf(clazz);
            Array array3 = Array.createInstance(type, n4);
            Array.a(array, n2, array3, 0, n4, bl2);
            Array.a(array3, 0, array2, n3, n4, false);
        } else {
            Array.a(array, n2, array2, n3, n4, bl2);
        }
    }

    public static <T> void copyInternal(Array array, int n2, Array array2, int n3, int n4, ElementInitializer<T> elementInitializer) {
        if (array == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (array2 == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (n4 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Non-negative number required.");
        }
        if (n2 > array.getLength() - n4) {
            throw new ArgumentException("length");
        }
        if (n3 > array2.getLength() - n4) {
            String string = StringExtensions.concat("Destination array was not long enough. Check ", "destIndex and length, and the array's lower bounds");
            throw new ArgumentException(string, StringExtensions.Empty);
        }
        if (array.getRank() != array2.getRank()) {
            throw new RankException("Arrays must be of same size.");
        }
        Class clazz = array.getArrayInfo().b;
        Class clazz2 = array2.getArrayInfo().b;
        boolean bl2 = Struct.class.isAssignableFrom(clazz);
        if (!bl2 && array.getRank() == 1 && Array.a(array, n2, array2, n3, n4)) {
            return;
        }
        if (ObjectExtensions.referenceEquals(Array.unboxing(array), Array.unboxing(array2)) && Array.a(n2, n3, n4)) {
            Type type = Operators.typeOf(clazz);
            Array array3 = Array.createInstanceInternal(type.getJavaClass(), n4, elementInitializer);
            Array.a(array, n2, array3, 0, n4, bl2);
            Array.a(array3, 0, array2, n3, n4, false);
        } else {
            Array.a(array, n2, array2, n3, n4, bl2);
        }
    }

    private static boolean a(int n2, int n3, int n4) {
        return n2 < n3 && n2 + n4 > n3 || n3 < n2 && n3 + n4 > n2;
    }

    private static void a(Array array, int n2, Array array2, int n3, int n4, boolean bl2) {
        try {
            if (!bl2) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    Object object = array.getValueImpl(n2 + i2);
                    array2.setValueImpl(object, n3 + i2);
                }
            } else {
                for (int i3 = 0; i3 < n4; ++i3) {
                    Object t2 = ((Struct)array.getValueImpl(n2 + i3)).Clone();
                    array2.setValueImpl(t2, n3 + i3);
                }
            }
        }
        catch (java.lang.Exception exception) {
            Class clazz = array.getArrayInfo().b;
            Class clazz2 = array2.getArrayInfo().b;
            if (clazz.equals(Object.class)) {
                throw new InvalidCastException();
            }
            Type type = Operators.typeOf(clazz);
            Type type2 = Operators.typeOf(clazz2);
            throw new ArrayTypeMismatchException(StringExtensions.format("sourceArray and destinationArray are of incompatible types (Types: source={0};  target={1})", type.getFullName(), type2.getFullName()));
        }
    }

    public static void copy(Array array, long l2, Array array2, long l3, long l4) {
        if (array == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (array2 == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Must be in the Int32 range.");
        }
        if (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Must be in the Int32 range.");
        }
        if (l4 < 0L || l4 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        Array.copy(array, (int)l2, array2, (int)l3, (int)l4);
    }

    public static void copy(Array array, Array array2, long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        Array.copy(array, array2, (int)l2);
    }

    private static boolean a(Array array, int n2, Array array2, int n3, int n4) {
        if (ConversionUtils.isSame(array.getArrayInfo().b, array2.getArrayInfo().b)) {
            System.arraycopy(Array.unboxing(array), n2, Array.unboxing(array2), n3, n4);
            return true;
        }
        return false;
    }

    @Override
    public void copyTo(Array array, int n2) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (n2 + this.getLength(0) > array.getLowerBound(0) + array.getLength(0)) {
            throw new ArgumentException(StringExtensions.concat("Destination array was not long ", "enough. Check destIndex and length, and the array's ", "lower bounds."));
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index", "Non-negative number required.");
        }
        Array.copy(this, this.getLowerBound(0), array, n2, this.getLength(0));
    }

    public void copyTo(Array array, long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        this.copyTo(array, (int)l2);
    }

    public static int indexOf(Array array, Object object) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, object, 0, array.getLength());
    }

    public static int indexOf(Array array, Object object, int n2) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, object, n2, array.getLength() - n2);
    }

    public static int indexOf(Array array, Object object, int n2, int n3) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (n3 < 0 || n2 < array.getLowerBound(0) || n2 - 1 > array.getUpperBound(0) - n3) {
            throw new ArgumentOutOfRangeException(n3 < 0 ? "count" : "startIndex", n3 < 0 ? "Count must be positive and count must refer to a location within the string/array/collection." : "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!ObjectExtensions.equals(array.getValueImpl(i2), object)) continue;
            return i2;
        }
        return array.getLowerBound(0) - 1;
    }

    public static <T> int indexOf(T[] TArray, T t2) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(TArray, t2, 0, Array.boxing(TArray).getLength());
    }

    public static <T> int indexOf(T[] TArray, T t2, int n2) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(TArray, t2, n2, Array.boxing(TArray).getLength() - n2);
    }

    public static <T> int indexOf(T[] TArray, T t2, int n2, int n3) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n3 < 0 || n2 < Array.boxing(TArray).getLowerBound(0) || n2 - 1 > Array.boxing(TArray).getUpperBound(0) - n3) {
            throw new ArgumentOutOfRangeException(n3 < 0 ? "count" : "startIndex", n3 < 0 ? "Count must be positive and count must refer to a location within the string/array/collection." : "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n4 = n2 + n3;
        EqualityComparer.DefaultComparer<T> defaultComparer = new EqualityComparer.DefaultComparer<T>();
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!((EqualityComparer)defaultComparer).equals(TArray[i2], t2)) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(Array array, Object object) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getLength() == 0) {
            return array.getLowerBound(0) - 1;
        }
        return Array.lastIndexOf(array, object, array.getLength() - 1);
    }

    public static int lastIndexOf(Array array, Object object, int n2) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.lastIndexOf(array, object, n2, n2 - array.getLowerBound(0) + 1);
    }

    public static int lastIndexOf(Array array, Object object, int n2, int n3) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n4 = array.getLowerBound(0);
        if (array.getLength() == 0) {
            return n4 - 1;
        }
        if (n2 < n4 || n2 > array.getUpperBound(0)) {
            throw new ArgumentOutOfRangeException("startIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (n3 < 0 || n2 - n3 + 1 < n4) {
            throw new ArgumentOutOfRangeException("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        for (int i2 = n2; i2 >= n2 - n3 + 1; --i2) {
            if (!ObjectExtensions.equals(array.getValueImpl(i2), object)) continue;
            return i2;
        }
        return n4 - 1;
    }

    public static <T> int lastIndexOf(T[] TArray, T t2) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (Array.boxing(TArray).getLength() == 0) {
            return -1;
        }
        return Array.lastIndexOf(TArray, t2, Array.boxing(TArray).getLength() - 1);
    }

    public static <T> int lastIndexOf(T[] TArray, T t2, int n2) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        return Array.lastIndexOf(TArray, t2, n2, n2 + 1);
    }

    public static <T> int lastIndexOf(T[] TArray, T t2, int n2, int n3) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < Array.boxing(TArray).getLowerBound(0) || n2 > Array.boxing(TArray).getUpperBound(0)) {
            throw new ArgumentOutOfRangeException("startIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (n3 < 0 || n2 - n3 + 1 < Array.boxing(TArray).getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        EqualityComparer.DefaultComparer<T> defaultComparer = new EqualityComparer.DefaultComparer<T>();
        for (int i2 = n2; i2 >= n2 - n3 + 1; --i2) {
            if (!((EqualityComparer)defaultComparer).equals(TArray[i2], t2)) continue;
            return i2;
        }
        return -1;
    }

    static Swapper a(final Array array) {
        Object object = Array.unboxing(array);
        if (object instanceof Object[]) {
            return new Swapper(){

                @Override
                public void a(int n2, int n3) {
                    array.a(n2, n3);
                }
            };
        }
        return new Swapper(){

            @Override
            public void a(int n2, int n3) {
                array.b(n2, n3);
            }
        };
    }

    private void a(int n2, int n3) {
        Object object = Array.unboxing(this);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : null;
        Object object2 = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object2;
    }

    private void b(int n2, int n3) {
        Object object = this.getValueImpl(n2);
        this.setValueImpl(this.getValue(n3), n2);
        this.setValueImpl(object, n3);
    }

    public static void reverse(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.reverse(array, array.getLowerBound(0), array.getLength(0));
    }

    public static void reverse(Array array, int n2, int n3) {
        int n4;
        Object[] objectArray;
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (n2 < array.getLowerBound(0) || n3 < 0) {
            throw new ArgumentOutOfRangeException(n2 < 0 ? "index" : "length", "Non-negative number required.");
        }
        if (n2 > array.getUpperBound(0) + 1 - n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        Object object = Array.unboxing(array);
        Object[] objectArray2 = objectArray = object instanceof Object[] ? (Object[])object : null;
        if (objectArray != null) {
            for (n4 = n2 + n3 - 1; n2 < n4; ++n2, --n4) {
                Object object2 = objectArray[n2];
                objectArray[n2] = objectArray[n4];
                objectArray[n4] = object2;
            }
            return;
        }
        Swapper swapper = Array.a(array);
        while (n2 < n4) {
            swapper.a(n2, n4);
            ++n2;
            --n4;
        }
    }

    public void initialize() {
        ArrayEnumerator arrayEnumerator = this.createEnumerator(0, this.getLength());
        Class clazz = this.getArrayInfo().b;
        Object object = Operators.defaultValue(clazz);
        if (object != null) {
            if (arrayEnumerator.hasNext() && arrayEnumerator.next() == null) {
                arrayEnumerator.a(object);
            }
            while (arrayEnumerator.hasNext()) {
                object = Operators.defaultValue(clazz);
                if (arrayEnumerator.next() != null) continue;
                arrayEnumerator.a(object);
            }
        }
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Object get_Item(int n2) {
        if (n2 >= this.getLength() || n2 < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (this.getRank() > 1) {
            throw new ArgumentException("Only single dimension arrays are supported.");
        }
        return this.getValueImpl(n2);
    }

    @Override
    public void set_Item(int n2, Object object) {
        if (n2 >= this.getLength() || n2 < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (this.getRank() > 1) {
            throw new ArgumentException("Only single dimension arrays are supported.");
        }
        this.setValueImpl(object, n2);
    }

    @Override
    public int addItem(Object object) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void removeItem(Object object) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void insertItem(int n2, Object object) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void removeAt(int n2) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void clear() {
        Array.clear(this, this.getLowerBound(0), this.getLength());
    }

    @Override
    public boolean contains(Object object) {
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n2 = this.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ObjectExtensions.equals(this.getValueImpl(i2), object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object object) {
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n2 = this.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ObjectExtensions.equals(this.getValueImpl(i2), object)) continue;
            return i2 + this.getLowerBound(0);
        }
        return this.getLowerBound(0) - 1;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public IEnumerator iterator() {
        return this.createEnumerator(0, this.getLength());
    }

    private static void b(a a2, Object object, int n2, Object object2) {
        try {
            a2.a(object, n2, object2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArgumentOutOfRangeException("index is outside the range of valid indexes for the current Array", arrayIndexOutOfBoundsException);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new InvalidCastException(arrayStoreException.getMessage());
        }
    }

    private static Object b(a a2, Object object, int n2) {
        try {
            return a2.a(object, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array", arrayIndexOutOfBoundsException);
        }
    }

    protected Object getValueImpl(int n2) {
        return Array.b(this.getArrayHelper(), this.getInternalObject(), n2);
    }

    protected void setValueImpl(Object object, int n2) {
        throw new InvalidOperationException("Array was not a one-dimensional array.");
    }

    protected Object getValueImpl(int ... nArray) {
        Object object = this.getInternalObject();
        int n2 = nArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = Array.b(a.a(), object, nArray[i2]);
        }
        return Array.b(this.getArrayHelper(), object, nArray[n2]);
    }

    protected void setValueImpl(Object object, int ... nArray) {
        Class clazz = this.getArrayInfo().b;
        if (object == null && clazz.isPrimitive()) {
            object = Operators.defaultValue(clazz);
        }
        if (object != null && !ConversionUtils.isCompatible(object.getClass(), clazz) && (clazz.isPrimitive() || ConversionUtils.getUnboxedClass(clazz) != null)) {
            throw new ArgumentException("Cannot widen from source type to target type either because the source type is a not a primitive type or the conversion cannot be accomplished");
        }
        Object object2 = this.getInternalObject();
        int n2 = nArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = Array.b(a.a(), object2, nArray[i2]);
        }
        try {
            Array.b(this.getArrayHelper(), object2, nArray[n2], object);
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            throw argumentOutOfRangeException;
        }
        catch (java.lang.Exception exception) {
            throw new InvalidCastException("Cannot save value in this array");
        }
    }

    public Object getValue(int ... nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("indices");
        }
        if (this.getRank() != nArray.length) {
            throw new ArgumentException("The number of dimensions in the current Array is not equal to the number of elements in indices");
        }
        return this.getValueImpl(nArray);
    }

    public void setValue(Object object, int ... nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("indices");
        }
        if (this.getRank() != nArray.length) {
            throw new ArgumentException("The number of dimensions in the current Array is not equal to the number of elements in indices");
        }
        this.setValueImpl(object, nArray);
    }

    public int getRank() {
        return this.getArrayInfo().a;
    }

    public int getLowerBound(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (n2 >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return 0;
    }

    public static <T> Array createInstanceInternal(Class<T> clazz, int n2, ElementInitializer<T> elementInitializer) {
        Object object = java.lang.reflect.Array.newInstance(clazz, n2);
        Array array = Array.boxing(object);
        ArrayEnumerator arrayEnumerator = array.createEnumerator(0, n2);
        while (arrayEnumerator.hasNext()) {
            if (arrayEnumerator.next() != null) continue;
            arrayEnumerator.a(elementInitializer.createInstance());
        }
        return array;
    }

    public static Array createInstance(Type type, int n2) {
        int[] nArray = new int[]{n2};
        return Array.createInstance(type, nArray);
    }

    public static Array createInstance(Type type, int n2, int n3) {
        int[] nArray = new int[]{n2, n3};
        return Array.createInstance(type, nArray);
    }

    public static Array createInstance(Type type, int n2, int n3, int n4) {
        int[] nArray = new int[]{n2, n3, n4};
        return Array.createInstance(type, nArray);
    }

    public static Array createInstance(Type type, int ... nArray) {
        if (type == null) {
            throw new ArgumentNullException("elementType");
        }
        if (nArray == null) {
            throw new ArgumentNullException("lengths");
        }
        if (nArray.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        int[] nArray2 = null;
        if (type.equals(Operators.typeOf(Void.TYPE))) {
            throw new NotSupportedException("Array type can not be void");
        }
        return Array.a(type, nArray, nArray2);
    }

    public static Array createInstance(Type type, int[] nArray, int[] nArray2) {
        if (type == null) {
            throw new ArgumentNullException("elementType");
        }
        if (nArray == null) {
            throw new ArgumentNullException("lengths");
        }
        if (nArray2 == null) {
            throw new ArgumentNullException("lowerBounds");
        }
        if (type.equals(Operators.typeOf(Void.TYPE))) {
            throw new NotSupportedException("Array type can not be void");
        }
        if (nArray.length < 1) {
            throw new ArgumentException("Must provide at least one rank.");
        }
        if (nArray.length != nArray2.length) {
            throw new ArgumentException("Number of lengths and lowerBounds must match.");
        }
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (nArray[i2] < 0) {
                throw new ArgumentOutOfRangeException("lengths[" + i2 + "]", "Non-negative number required.");
            }
            if ((long)nArray2[i2] + (long)nArray[i2] <= Integer.MAX_VALUE) continue;
            throw new ArgumentOutOfRangeException("lengths", "Length + bound must not exceed Int32.MaxValue.");
        }
        if (nArray.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        return Array.a(type, nArray, nArray2);
    }

    private static Array a(Type type, int[] nArray, int[] nArray2) {
        int n2;
        if (nArray2 != null) {
            throw new NotImplementedException("Not implemented yet");
        }
        if (nArray == null) {
            throw new ArgumentNullException("lengths");
        }
        if (nArray.length < 1) {
            throw new ArgumentException("Arrays must contain >= 1 elements.");
        }
        if (nArray.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0) continue;
            throw new ArgumentOutOfRangeException("lengths[" + n2 + ']', "Non-negative number required.");
        }
        n2 = 0;
        for (Class<?> clazz = type.getJavaClass().getComponentType(); clazz != null; clazz = clazz.getComponentType()) {
            ++n2;
        }
        Object object = null;
        object = nArray.length > 1 ? java.lang.reflect.Array.newInstance(type.getJavaClass(), nArray) : java.lang.reflect.Array.newInstance(type.getJavaClass(), nArray[0]);
        Array array = Array.boxing(object, nArray.length, n2 > 0);
        array.initialize();
        return array;
    }

    private static int a(String string) {
        if (string.charAt(0) == '[') {
            int n2 = 1;
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            return n2;
        }
        return 0;
    }

    public static <T> void resize(T[][] TArray, int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Non-negative number required.");
        }
        if (TArray[0] == null) {
            Array array = Array.createInstance(Operators.typeOf(TArray.getClass().getComponentType().getComponentType()), n2);
            TArray[0] = (Object[])Array.unboxing(array);
            return;
        }
        int n3 = TArray[0].length;
        if (n3 == n2) {
            return;
        }
        int n4 = 0;
        for (Class<?> clazz = TArray[0].getClass().getComponentType(); clazz != null; clazz = clazz.getComponentType()) {
            ++n4;
        }
        Array array = Array.createInstance(Operators.typeOf(TArray[0].getClass().getComponentType()), n2);
        if (n3 != 0) {
            Array.a(Array.boxing(TArray[0], 1, n4 > 0), 0, array, 0, msMath.min(n2, n3));
        }
        TArray[0] = (Object[])Array.unboxing(array);
    }

    public int getLength() {
        return (int)this.getArrayInfo().e;
    }

    public long getLongLength() {
        return this.getArrayInfo().e;
    }

    public Object getValue(int n2) {
        if (this.getRank() != 1) {
            throw new ArgumentException("Array was not a one-dimensional array.");
        }
        if (n2 < this.getLowerBound(0) || n2 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array");
        }
        return this.getValueImpl(n2);
    }

    public Object getValue(int n2, int n3) {
        if (this.getRank() != 2) {
            throw new ArgumentException("The current Array does not have exactly two dimensions.");
        }
        if (n2 < this.getLowerBound(0) || n2 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (n3 < this.getLowerBound(1) || n3 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{n2, n3};
        return this.getValueImpl(nArray);
    }

    public Object getValue(int n2, int n3, int n4) {
        if (this.getRank() != 3) {
            throw new ArgumentException("The current Array does not have exactly three dimensions.");
        }
        if (n2 < this.getLowerBound(0) || n2 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (n3 < this.getLowerBound(1) || n3 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (n4 < this.getLowerBound(2) || n4 > this.getUpperBound(2)) {
            throw new IndexOutOfRangeException("Index3 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{n2, n3, n4};
        return this.getValueImpl(nArray);
    }

    public Object getValue(long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)l2);
    }

    public Object getValue(long l2, long l3) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (l3 < 0L || l3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)l2, (int)l3);
    }

    public Object getValue(long l2, long l3, long l4) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (l3 < 0L || l3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (l4 < 0L || l4 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index3", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)l2, (int)l3, (int)l4);
    }

    public void setValue(Object object, int n2) {
        if (this.getRank() != 1) {
            throw new ArgumentException("Array was not a one-dimensional array.");
        }
        if (n2 < this.getLowerBound(0) || n2 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array");
        }
        this.setValueImpl(object, n2 - this.getLowerBound(0));
    }

    public void setValue(Object object, int n2, int n3) {
        if (this.getRank() != 2) {
            throw new ArgumentException("The current Array does not have exactly two dimensions.");
        }
        if (n2 < this.getLowerBound(0) || n2 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (n3 < this.getLowerBound(1) || n3 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{n2, n3};
        this.setValueImpl(object, nArray);
    }

    public void setValue(Object object, int n2, int n3, int n4) {
        if (this.getRank() != 3) {
            throw new ArgumentException("The current Array does not have exactly three dimensions.");
        }
        if (n2 < this.getLowerBound(0) || n2 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (n3 < this.getLowerBound(1) || n3 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (n4 < this.getLowerBound(2) || n4 > this.getUpperBound(2)) {
            throw new IndexOutOfRangeException("Index3 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{n2, n3, n4};
        this.setValueImpl(object, nArray);
    }

    public void setValue(Object object, long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        this.setValue(object, (int)l2);
    }

    public void setValue(Object object, long l2, long l3) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (l3 < 0L || l3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        int[] nArray = new int[]{(int)l2, (int)l3};
        this.setValue(object, nArray);
    }

    public void setValue(Object object, long l2, long l3, long l4) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (l3 < 0L || l3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (l4 < 0L || l4 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index3", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        int[] nArray = new int[]{(int)l2, (int)l3, (int)l4};
        this.setValue(object, nArray);
    }

    public int getUpperBound(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (n2 >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return this.getArrayInfo().c[n2];
    }

    public int getLength(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (n2 >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return this.getArrayInfo().c[n2] + 1;
    }

    public static void sort(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, null, array.getLowerBound(0), array.getLength(), null);
    }

    public static <T> void sort(T[] TArray) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(TArray, Array.boxing(TArray).getLowerBound(0), TArray.length, null);
    }

    public static <T> void sort(T[] TArray, Comparator<T> comparator) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(TArray, 0, TArray.length, comparator);
    }

    public static <T> void sort(T[] TArray, Comparison<T> comparison) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        FunctorComparer<T> functorComparer = new FunctorComparer<T>(comparison);
        Array.sort(TArray, functorComparer);
    }

    public static void sort(Array array, Array array2) {
        if (array == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(array, array2, array.getLowerBound(0), array.getLength(), null);
    }

    public static void sort(Array array, Comparator comparator) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, null, array.getLowerBound(0), array.getLength(), comparator);
    }

    public static <TKey, TValue> void sort(TKey[] TKeyArray, TValue[] TValueArray) {
        if (TKeyArray == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(TKeyArray, TValueArray, 0, TKeyArray.length, null);
    }

    public static <T> void sort(T[] TArray, int n2, int n3) {
        Array.sort(TArray, n2, n3, null);
    }

    public static <TKey, TValue> void sort(TKey[] TKeyArray, TValue[] TValueArray, Comparator<TKey> comparator) {
        if (TKeyArray == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(TKeyArray, TValueArray, 0, TKeyArray.length, comparator);
    }

    public static void sort(Array array, Array array2, Comparator comparator) {
        if (array == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(array, array2, array.getLowerBound(0), array.getLength(), comparator);
    }

    public static void sort(Array array, int n2, int n3) {
        Array.sort(array, null, n2, n3, null);
    }

    public static void sort(Array array, int n2, int n3, Comparator comparator) {
        Array.sort(array, null, n2, n3, comparator);
    }

    public static <T> void sort(T[] TArray, int n2, int n3, Comparator<T> comparator) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < 0 || n3 < 0) {
            throw new ArgumentOutOfRangeException(n3 < 0 ? "length" : "index", "Non-negative number required");
        }
        if (TArray.length - n2 < n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (n3 > 1) {
            if (comparator != null && comparator != com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault()) {
                Array.sort(TArray, null, n2, n3, comparator);
            } else {
                Array.sort(TArray, null, n2, n3, com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault());
            }
        }
    }

    public static void sort(Array array, Array array2, int n2, int n3) {
        Array.sort(array, array2, n2, n3, null);
    }

    public static <TKey, TValue> void sort(TKey[] TKeyArray, TValue[] TValueArray, int n2, int n3) {
        Array.sort(TKeyArray, TValueArray, n2, n3, null);
    }

    public static <TKey, TValue> void sort(TKey[] TKeyArray, TValue[] TValueArray, int n2, int n3, Comparator<TKey> comparator) {
        if (TKeyArray == null) {
            throw new ArgumentNullException("keys");
        }
        if (n2 < 0 || n3 < 0) {
            throw new ArgumentOutOfRangeException(n3 < 0 ? "length" : "index", "Non-negative number required");
        }
        if (TKeyArray.length - n2 < n3 || TValueArray != null && n2 > TValueArray.length - n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (comparator == null) {
            comparator = com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault();
        }
        if (n3 > 1) {
            if (comparator != null && comparator != com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault()) {
                Array.a(TKeyArray, TValueArray, n2, n2 + n3 - 1, comparator);
            } else {
                Array.a(TKeyArray, TValueArray, n2, n2 + n3 - 1, com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault());
            }
        }
    }

    private static <TKey, TValue> void a(TKey[] TKeyArray, TValue[] TValueArray, int n2, int n3, Comparator<TKey> comparator) {
        int n4 = n2;
        int n5 = n3;
        int n6 = (n4 + n5) / 2;
        TKey TKey = TKeyArray[n6];
        while (true) {
            if (comparator.compare(TKeyArray[n4], TKey) < 0) {
                ++n4;
                continue;
            }
            while (comparator.compare(TKeyArray[n5], TKey) > 0) {
                --n5;
            }
            if (n4 <= n5) {
                TKey TKey2 = TKeyArray[n4];
                TKeyArray[n4] = TKeyArray[n5];
                TKeyArray[n5] = TKey2;
                if (TValueArray != null) {
                    TValue TValue = TValueArray[n4];
                    TValueArray[n4] = TValueArray[n5];
                    TValueArray[n5] = TValue;
                }
                ++n4;
                --n5;
            }
            if (n4 >= n5) break;
        }
        if (n2 < n5) {
            Array.a(TKeyArray, TValueArray, n2, n5, comparator);
        }
        if (n4 < n3) {
            Array.a(TKeyArray, TValueArray, n4, n3, comparator);
        }
    }

    public static void sort(Array array, Array array2, int n2, int n3, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("keys");
        }
        if (array.getRank() != 1 || array2 != null && array2.getRank() != 1) {
            throw new RankException("Only single dimension arrays are supported");
        }
        if (array2 != null && array.getLowerBound(0) != array2.getLowerBound(0)) {
            throw new ArgumentException("Lower bounds must match");
        }
        if (n2 < array.getLowerBound(0) || n3 < 0) {
            throw new ArgumentOutOfRangeException(n3 < 0 ? "length" : "index", "Non-negative number required");
        }
        if (array.getLength() - (n2 - array.getLowerBound(0)) < n3 || array2 != null && n2 - array2.getLowerBound(0) > array2.getLength() - n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (n3 > 1) {
            Object object = Array.unboxing(array);
            Object object2 = array2 != null ? Array.unboxing(array2) : null;
            Object[] objectArray = object instanceof Object[] ? (Object[])object : null;
            Object[] objectArray2 = null;
            if (objectArray != null) {
                Object[] objectArray3 = objectArray2 = object2 instanceof Object[] ? (Object[])object2 : null;
            }
            if (comparer == null) {
                comparer = com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault();
            }
            if (objectArray != null && (array2 == null || objectArray2 != null)) {
                Array.b(objectArray, objectArray2, comparer, n2, n2 + n3 - 1);
            } else {
                Array.b(array, array2, comparer, n2, n2 + n3 - 1);
            }
        }
    }

    private static int c(int n2, int n3) {
        return n2 + (n3 - n2 >> 1);
    }

    private static void a(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n2, int n3) {
        if (n2 != n3) {
            try {
                if (comparator.compare(objectArray[n2], objectArray[n3]) > 0) {
                    Object object = objectArray[n2];
                    objectArray[n2] = objectArray[n3];
                    objectArray[n3] = object;
                    if (objectArray2 != null) {
                        Object object2 = objectArray2[n2];
                        objectArray2[n2] = objectArray2[n3];
                        objectArray2[n3] = object2;
                    }
                }
            }
            catch (IndexOutOfRangeException indexOutOfRangeException) {
                throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
            }
        }
    }

    private static void a(Array array, Array array2, Comparator comparator, int n2, int n3) {
        if (n2 != n3) {
            try {
                if (comparator.compare(array.getValue(n2), array.getValue(n3)) > 0) {
                    Object object = array.getValue(n2);
                    array.setValue(array.getValue(n3), n2);
                    array.setValue(object, n3);
                    if (array2 != null) {
                        Object object2 = array2.getValue(n2);
                        array2.setValue(array2.getValue(n3), n2);
                        array2.setValue(object2, n3);
                    }
                }
            }
            catch (IndexOutOfRangeException indexOutOfRangeException) {
                throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
            }
        }
    }

    private static void b(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n2, int n3) {
        do {
            int n4 = n2;
            int n5 = n3;
            int n6 = Array.c(n4, n5);
            Array.a(objectArray, objectArray2, comparator, n4, n6);
            Array.a(objectArray, objectArray2, comparator, n4, n5);
            Array.a(objectArray, objectArray2, comparator, n6, n5);
            Object object = objectArray[n6];
            do {
                try {
                    while (comparator.compare(objectArray[n4], object) < 0) {
                        ++n4;
                    }
                    while (comparator.compare(object, objectArray[n5]) < 0) {
                        --n5;
                    }
                }
                catch (IndexOutOfRangeException indexOutOfRangeException) {
                    throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
                }
                if (n4 > n5) break;
                if (n4 >= n5) continue;
                Object object2 = objectArray[n4];
                objectArray[n4] = objectArray[n5];
                objectArray[n5] = object2;
                if (objectArray2 == null) continue;
                Object object3 = objectArray2[n4];
                objectArray2[n4] = objectArray2[n5];
                objectArray2[n5] = object3;
            } while (++n4 <= --n5);
            if (n5 - n2 <= n3 - n4) {
                if (n2 < n5) {
                    Array.b(objectArray, objectArray2, comparator, n2, n5);
                }
                n2 = n4;
                continue;
            }
            if (n4 < n3) {
                Array.b(objectArray, objectArray2, comparator, n4, n3);
            }
            n3 = n5;
        } while (n2 < n3);
    }

    private static <T> void b(Array array, Array array2, Comparator comparator, int n2, int n3) {
        do {
            int n4 = n2;
            int n5 = n3;
            int n6 = Array.c(n4, n5);
            Array.a(array, array2, comparator, n4, n6);
            Array.a(array, array2, comparator, n4, n5);
            Array.a(array, array2, comparator, n6, n5);
            Object object = array.getValue(n6);
            do {
                try {
                    while (comparator.compare(array.getValue(n4), object) < 0) {
                        ++n4;
                    }
                    while (comparator.compare(object, array.getValue(n5)) < 0) {
                        --n5;
                    }
                }
                catch (IndexOutOfRangeException indexOutOfRangeException) {
                    throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
                }
                if (n4 > n5) break;
                if (n4 < n5) {
                    Object object2 = array.getValue(n4);
                    array.setValue(array.getValue(n5), n4);
                    array.setValue(object2, n5);
                    if (array2 != null) {
                        Object object3 = array2.getValue(n4);
                        array2.setValue(array2.getValue(n5), n4);
                        array2.setValue(object3, n5);
                    }
                }
                if (n4 != Integer.MAX_VALUE) {
                    ++n4;
                }
                if (n5 == Integer.MIN_VALUE) continue;
                --n5;
            } while (n4 <= n5);
            if (n5 - n2 <= n3 - n4) {
                if (n2 < n5) {
                    Array.b(array, array2, comparator, n2, n5);
                }
                n2 = n4;
                continue;
            }
            if (n4 < n3) {
                Array.b(array, array2, comparator, n4, n3);
            }
            n3 = n5;
        } while (n2 < n3);
    }

    public static class FunctorComparer<T>
    implements Comparator<T> {
        private final Comparison<T> a;

        public FunctorComparer(Comparison<T> comparison) {
            this.a = comparison;
        }

        @Override
        public int compare(T t2, T t3) {
            return this.a.invoke(t2, t3);
        }
    }

    public static abstract class ElementInitializer<T> {
        public abstract T createInstance();
    }

    private static class MultiDimensionalEnumerator
    implements ArrayEnumerator,
    IEnumerator,
    ICloneable,
    Cloneable {
        private final Array a;
        private int b;
        private int c;
        private int d;
        private boolean e;
        private int[] f;

        private MultiDimensionalEnumerator(MultiDimensionalEnumerator multiDimensionalEnumerator) {
            this.a = multiDimensionalEnumerator.a;
            this.b = multiDimensionalEnumerator.b;
            this.c = multiDimensionalEnumerator.c;
            this.d = multiDimensionalEnumerator.d;
            this.e = multiDimensionalEnumerator.e;
            this.f = (int[])multiDimensionalEnumerator.f.clone();
        }

        MultiDimensionalEnumerator(Array array, int n2, int n3) {
            this.a = array;
            this.d = n2;
            this.b = n2 + n3 - 1;
            this.f = new int[array.getRank()];
            this.reset();
        }

        private void b() {
            if (this.c < this.d) {
                throw new InvalidOperationException("Enumeration has not started");
            }
            if (this.e) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        @Override
        public Object next() {
            this.b();
            return this.a.getValueImpl(this.f);
        }

        @Override
        public void a(Object object) {
            this.b();
            this.a.setValueImpl(object, this.f);
        }

        private void c() {
            ++this.c;
            if (this.c > this.b) {
                this.e = true;
                return;
            }
            int n2 = this.a.getRank();
            int n3 = n2 - 1;
            this.f[n3] = this.f[n3] + 1;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (this.f[i2] <= this.a.getUpperBound(i2)) continue;
                if (i2 == 0) {
                    this.e = true;
                    this.f[0] = this.a.getLowerBound(0);
                    return;
                }
                for (int i3 = i2; i3 < n2; ++i3) {
                    this.f[i3] = this.a.getLowerBound(i3);
                }
                int n4 = i2 - 1;
                this.f[n4] = this.f[n4] + 1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.e) {
                return false;
            }
            this.c();
            return !this.e;
        }

        @Override
        public void reset() {
            int n2;
            this.c = this.d - 1;
            int[] nArray = new int[]{this.d};
            int n3 = 1;
            for (n2 = 0; n2 < this.a.getRank(); ++n2) {
                int n4 = this.a.getLength(n2);
                this.f[n2] = msMath.divRem(nArray[0], n4, nArray);
                n3 *= n4;
            }
            n2 = this.a.getLength(this.f.length - 1);
            this.f[this.f.length - 1] = nArray[0] - 1;
            this.e = (n3 *= n2) == 0 || this.d > this.b;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new MultiDimensionalEnumerator(this);
        }

        @Override
        public void remove() {
            throw new NotSupportedException("Collection was of a fixed size.");
        }
    }

    private static class OneDimensionalEnumerator
    implements ArrayEnumerator {
        private final Array a;
        private int b;
        private int c;
        private int d;
        private boolean e;

        private OneDimensionalEnumerator(OneDimensionalEnumerator oneDimensionalEnumerator) {
            this.a = oneDimensionalEnumerator.a;
            this.b = oneDimensionalEnumerator.b;
            this.c = oneDimensionalEnumerator.c;
            this.d = oneDimensionalEnumerator.d;
            this.e = oneDimensionalEnumerator.e;
        }

        public OneDimensionalEnumerator(Array array, int n2, int n3) {
            this.a = array;
            this.b = n2;
            this.d = n2 + n3 - 1;
            this.reset();
        }

        private void b() {
            if (this.c < this.b) {
                throw new InvalidOperationException("Enumeration has not started.");
            }
            if (this.e) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        @Override
        public Object next() {
            this.b();
            return this.a.getValueImpl(this.c);
        }

        @Override
        public void a(Object object) {
            this.b();
            this.a.setValueImpl(object, this.c);
        }

        private void c() {
            ++this.c;
            this.e = this.c > this.d;
        }

        @Override
        public boolean hasNext() {
            if (this.e) {
                return false;
            }
            this.c();
            return !this.e;
        }

        @Override
        public void reset() {
            this.c = this.b - 1;
            this.e = this.b > this.d;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new OneDimensionalEnumerator(this);
        }

        @Override
        public void remove() {
            throw new NotSupportedException("Collection was of a fixed size.");
        }
    }

    private static interface ArrayEnumerator
    extends IEnumerator,
    ICloneable,
    Cloneable {
        public void a(Object var1);
    }

    private static class GenericArray<T>
    implements IGenericList<T> {
        private Array a;

        private GenericArray(Array array) {
            this.a = array;
        }

        @Override
        public int indexOfItem(T t2) {
            return this.a.indexOf(t2);
        }

        @Override
        public void insertItem(int n2, T t2) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public void removeAt(int n2) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public T get_Item(int n2) {
            return (T)this.a.get_Item(n2);
        }

        @Override
        public void set_Item(int n2, T t2) {
            this.a.set_Item(n2, t2);
        }

        @Override
        public int size() {
            return this.a.getLength();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(T t2) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read-only");
        }

        @Override
        public boolean containsItem(T t2) {
            return this.a.contains(t2);
        }

        @Override
        public void copyToTArray(T[] TArray, int n2) {
            this.a.copyTo(Array.boxing(TArray), n2);
        }

        @Override
        public boolean removeItem(T t2) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public IGenericEnumerator<T> iterator() {
            return new GenericEnumerator();
        }

        private class GenericEnumerator<T>
        implements IGenericEnumerator<T> {
            IEnumerator a;

            private GenericEnumerator() {
                this.a = GenericArray.this.a.iterator();
            }

            @Override
            public T next() {
                return this.a.next();
            }

            @Override
            public void remove() {
                this.a.remove();
            }

            @Override
            public boolean hasNext() {
                return this.a.hasNext();
            }

            @Override
            public void reset() {
                this.a.reset();
            }

            @Override
            public void dispose() {
            }
        }
    }

    static interface Swapper {
        public void a(int var1, int var2);
    }

    private static final class MultiDimensional
    extends Box {
        private MultiDimensional(Object object, int n2, boolean bl2) {
            super(object, n2, bl2);
        }

        @Override
        protected ArrayEnumerator createEnumerator(int n2, int n3) {
            return new MultiDimensionalEnumerator(this, n2, n3);
        }

        @Override
        protected Object getValueImpl(int n2) {
            int[] nArray = this.a(n2);
            return this.getValueImpl(nArray);
        }

        private int[] a(int n2) {
            Info info = this.getArrayInfo();
            int[] nArray = new int[info.a];
            for (int i2 = info.a - 1; i2 >= 0; --i2) {
                int n3 = this.getLength(i2);
                nArray[i2] = n2 % n3;
                n2 /= n3;
            }
            return nArray;
        }

        @Override
        protected Object getValueImpl(int ... nArray) {
            if (this.getArrayInfo().a != nArray.length) {
                throw new ArgumentException("Indices length does not match the array rank.");
            }
            Object object = this.getInternalObject();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                a a2 = i2 == nArray.length - 1 ? this.getArrayHelper() : a.a();
                object = Array.b(a2, object, nArray[i2]);
            }
            return object;
        }

        @Override
        protected void setValueImpl(Object object, int n2) {
            int[] nArray = this.a(n2);
            this.setValueImpl(object, nArray);
        }
    }

    private static final class OneDimensional
    extends Box {
        private OneDimensional(Object object, boolean bl2) {
            super(object, 1, bl2);
        }

        @Override
        protected ArrayEnumerator createEnumerator(int n2, int n3) {
            return new OneDimensionalEnumerator(this, n2, n3);
        }

        @Override
        protected Object getValueImpl(int n2) {
            return this.getValueImpl(new int[]{n2});
        }

        @Override
        protected Object getValueImpl(int ... nArray) {
            int n2 = nArray[0];
            return Array.b(this.getArrayHelper(), this.getInternalObject(), n2);
        }

        @Override
        protected void setValueImpl(Object object, int n2) {
            this.setValueImpl(object, new int[]{n2});
        }

        @Override
        protected void setValueImpl(Object object, int ... nArray) {
            int n2 = nArray[0];
            Class clazz = this.getArrayInfo().b;
            if (object == null && clazz.isPrimitive()) {
                object = Operators.defaultValue(clazz);
            }
            if (object != null && !ConversionUtils.isCompatible(object.getClass(), clazz) && (clazz.isPrimitive() || ConversionUtils.getUnboxedClass(clazz) != null)) {
                throw new ArgumentException("Cannot widen from source type to target type either because the source type is a not a primitive type or the conversion cannot be accomplished");
            }
            try {
                Array.b(this.getArrayHelper(), this.getInternalObject(), n2, object);
            }
            catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
                throw argumentOutOfRangeException;
            }
            catch (java.lang.Exception exception) {
                throw new InvalidCastException("Cannot save value in this array");
            }
        }
    }

    private static abstract class Box
    extends Array {
        private final Object a;
        private final Info b;
        private final a c;

        Box(Object object, Info info) {
            this.a = object;
            this.b = info;
            this.c = com.aspose.html.internal.ms.core.System.a.a(info.b);
        }

        Box(Object object, int n2, boolean bl2) {
            this(object, new Info(object, n2, bl2));
        }

        @Override
        protected Object getInternalObject() {
            return this.a;
        }

        @Override
        protected Info getArrayInfo() {
            return this.b;
        }

        @Override
        protected a getArrayHelper() {
            return this.c;
        }
    }

    private static final class Info {
        private final int a;
        private final Class<?> b;
        private final int[] c;
        private final boolean d;
        private final long e;

        private Info(Object object, int n2, boolean bl2) {
            int n3 = 0;
            Class<?> clazz = null;
            Class<?> clazz2 = object.getClass().getComponentType();
            while (clazz2 != null) {
                clazz = clazz2;
                clazz2 = clazz.getComponentType();
                if (!bl2 || ++n3 != n2) continue;
            }
            if (n3 == 0) {
                throw new ArgumentException("Array required");
            }
            if (n2 > n3) {
                throw new ArgumentException("Required arrays dimension doesn't match to actual", "rank");
            }
            this.a = n2;
            this.b = clazz;
            this.c = new int[this.a];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.c[i2] = -1;
            }
            this.d = bl2;
            Object object2 = object;
            int n4 = 0;
            int n5 = 1;
            a a2 = com.aspose.html.internal.ms.core.System.a.a();
            a a3 = com.aspose.html.internal.ms.core.System.a.a(this.b);
            while (true) {
                int n6;
                if (object2 == null && !bl2) {
                    throw new ArgumentException("Jagged array not expected", "array");
                }
                boolean bl3 = n4 < n2 - 1;
                int n7 = n6 = bl3 ? a2.a(object2) : a3.a(object2);
                if ((n5 *= n6) == 0) break;
                this.c[n4] = n6 - 1;
                if (!bl3) break;
                object2 = Array.b(a2, object2, 0);
                ++n4;
            }
            this.e = n5;
        }

        final boolean a() {
            return false;
        }

        final boolean b() {
            return false;
        }
    }
}

