/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.Struct;

public class ArraySegment<T>
extends Struct<ArraySegment> {
    private T[] a;
    private int b;
    private int c;

    public ArraySegment() {
    }

    public ArraySegment(T[] TArray) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        this.a = TArray;
        this.b = 0;
        this.c = Array.boxing(TArray).getLength();
    }

    public ArraySegment(T[] TArray, int n2, int n3) {
        if (TArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required");
        }
        if (Array.boxing(TArray).getLength() - n2 < n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection");
        }
        this.a = TArray;
        this.b = n2;
        this.c = n3;
    }

    public T[] getArray() {
        return this.a;
    }

    public int getOffset() {
        return this.b;
    }

    public int getCount() {
        return this.c;
    }

    public int hashCode() {
        return Array.boxing(this.a).hashCode() ^ this.b ^ this.c;
    }

    public boolean equals(Object object) {
        return Operators.is(object, ArraySegment.class) && this.equals((ArraySegment)object);
    }

    public boolean equals(ArraySegment<T> arraySegment) {
        return arraySegment.a == this.a && arraySegment.b == this.b && arraySegment.c == this.c;
    }

    public static <T> boolean op_Equality(ArraySegment<T> arraySegment, ArraySegment<T> arraySegment2) {
        return arraySegment.equals(arraySegment2.Clone());
    }

    public static <T> boolean op_Inequality(ArraySegment<T> arraySegment, ArraySegment<T> arraySegment2) {
        return !ArraySegment.op_Equality(arraySegment, arraySegment2);
    }

    @Override
    public void CloneTo(ArraySegment arraySegment) {
        arraySegment.a = this.a;
        arraySegment.b = this.b;
        arraySegment.c = this.c;
    }

    @Override
    public ArraySegment Clone() {
        ArraySegment<T> arraySegment = new ArraySegment<T>();
        this.CloneTo(arraySegment);
        return arraySegment;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(ArraySegment arraySegment, ArraySegment arraySegment2) {
        return arraySegment.equals(arraySegment2);
    }
}

