/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Drawing2D;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ComponentModel.InvalidEnumArgumentException;
import com.aspose.html.internal.ms.System.Drawing.BasicShape;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.CustomLineCap;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.GraphicsState;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.PathData;
import com.aspose.html.internal.ms.System.Drawing.Font;
import com.aspose.html.internal.ms.System.Drawing.FontFamily;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Pen;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.Region;
import com.aspose.html.internal.ms.System.Drawing.StringFormat;
import com.aspose.html.internal.ms.System.Drawing.Text.LineLayout;
import com.aspose.html.internal.ms.System.Drawing.Text.TextLineIterator;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.ExtendedGeneralPath;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.GraphicsPathConverter;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.JFlatteningPathIterator;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.MatrixUtil;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.Primitive2D;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.l;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.n;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.o;
import com.aspose.html.internal.ms.lang.Ref;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.LinkedList;

public final class GraphicsPath
extends BasicShape
implements ICloneable {
    private int a = 0;
    private boolean b = true;

    public ExtendedGeneralPath getNativeObject() {
        return (ExtendedGeneralPath)this.getShape();
    }

    private GraphicsPath(ExtendedGeneralPath extendedGeneralPath) {
        super(extendedGeneralPath);
    }

    private GraphicsPath(GeneralPath generalPath) {
        super(new ExtendedGeneralPath(generalPath));
    }

    public GraphicsPath() {
        this(0);
    }

    public GraphicsPath(int n2) {
        this(new ExtendedGeneralPath());
        if (n2 == 0 || n2 == 1) {
            this.getNativeObject().setWindingRule(ExtendedGeneralPath.getRuleByFillMode(n2));
        }
        this.a = n2;
    }

    public GraphicsPath(Point[] pointArray, byte[] byArray) {
        this(pointArray, byArray, 0);
    }

    public GraphicsPath(PointF[] pointFArray, byte[] byArray) {
        this(pointFArray, byArray, 0);
    }

    GraphicsPath(l[] lArray, byte[] byArray, int n2) {
        this(new ExtendedGeneralPath());
        this.getNativeObject().setWindingRule(ExtendedGeneralPath.getRuleByFillMode(n2));
        this.a(lArray, byArray);
    }

    public GraphicsPath(Point[] pointArray, byte[] byArray, int n2) {
        this(l.a(pointArray), byArray, n2);
    }

    public GraphicsPath(PointF[] pointFArray, byte[] byArray, int n2) {
        this(l.a(pointFArray), byArray, n2);
    }

    @Override
    public Object deepClone() {
        GraphicsPath graphicsPath = new GraphicsPath((ExtendedGeneralPath)this.getNativeObject().deepClone());
        graphicsPath.a = this.a;
        graphicsPath.b = this.b;
        return graphicsPath;
    }

    public int getFillMode() {
        int n2 = this.getNativeObject().getWindingRule();
        if (n2 != this.a) {
            return this.a;
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            return 1;
        }
        return n2;
    }

    public void setFillMode(int n2) {
        if (n2 < 0 || n2 > 1) {
            throw new InvalidEnumArgumentException("value");
        }
        this.getNativeObject().setWindingRule(ExtendedGeneralPath.getRuleByFillMode(n2));
        this.a = n2;
    }

    public PathData getPathData() {
        return new PathData(this.getNativeObject());
    }

    public PointF[] getPathPoints() {
        if (this.getPointCount() < 1) {
            throw new ArgumentException("Parameter is invalid");
        }
        return this.getPathData().getPoints();
    }

    public byte[] getPathTypes() {
        if (this.getPathData().getTypes().length < 1) {
            throw new ArgumentException("Parameter is invalid");
        }
        return this.getPathData().getTypes();
    }

    public int getPointCount() {
        return this.getPathData().getPoints().length;
    }

    public void addArc(Rectangle rectangle, float f2, float f3) {
        this.addArc(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), f2, f3);
    }

    public void addArc(RectangleF rectangleF, float f2, float f3) {
        this.addArc(rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight(), f2, f3);
    }

    public void addArc(int n2, int n3, int n4, int n5, float f2, float f3) {
        this.addArc((float)n2, (float)n3, (float)n4, (float)n5, f2, f3);
    }

    public void addArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        RectangularShape rectangularShape = null;
        if (f7 >= 360.0f) {
            rectangularShape = new Ellipse2D.Float(f2, f3, f4, f5);
        } else {
            double d2 = f4 / f5;
            double d3 = d2 * d2;
            double d4 = GraphicsPath.a(d3, f6);
            double d5 = GraphicsPath.a(d3, f6 + f7) - d4;
            rectangularShape = new Arc2D.Double(f2, f3, f4, f5, -d4, -d5, 0);
        }
        this.getNativeObject().append(rectangularShape, !this.b());
    }

    static double a(double d2, double d3) {
        double d4 = Math.toRadians(d3);
        double d5 = Math.tan(d4);
        double d6 = 1.0 / Math.sqrt(d2 * (d5 * d5) + 1.0);
        double d7 = Math.acos(d6);
        double d8 = Math.toDegrees(d7);
        int n2 = Math.abs((int)d3) / 90;
        switch (n2 & 3) {
            case 1: {
                d8 = 180.0 - d8;
                break;
            }
            case 2: {
                d8 = 180.0 + d8;
                break;
            }
            case 3: {
                d8 = 360.0 - d8;
            }
        }
        if (d3 < 0.0) {
            d8 = -d8;
        }
        return d8 += (double)((int)d3 / 360 * 360);
    }

    public void addBezier(Point point, Point point2, Point point3, Point point4) {
        this.addBezier(point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY(), point4.getX(), point4.getY());
    }

    public void addBezier(PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        this.addBezier(pointF.getX(), pointF.getY(), pointF2.getX(), pointF2.getY(), pointF3.getX(), pointF3.getY(), pointF4.getX(), pointF4.getY());
    }

    public void addBezier(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.addBezier((float)n2, (float)n3, (float)n4, (float)n5, (float)n6, (float)n7, (float)n8, (float)n9);
    }

    public void addBezier(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        CubicCurve2D.Float float_ = new CubicCurve2D.Float(f2, f3, f4, f5, f6, f7, f8, f9);
        this.getNativeObject().append(float_, !this.b());
    }

    private void a(l[] lArray) {
        if (lArray == null) {
            throw new ArgumentNullException("points");
        }
        if (lArray.length < 4 || lArray.length % 3 != 1) {
            throw new ArgumentException("points");
        }
        this.addBezier(lArray[0].a().floatValue(), lArray[0].b().floatValue(), lArray[1].a().floatValue(), lArray[1].b().floatValue(), lArray[2].a().floatValue(), lArray[2].b().floatValue(), lArray[3].a().floatValue(), lArray[3].b().floatValue());
        for (int i2 = 4; i2 < lArray.length; i2 += 3) {
            this.getNativeObject().curveTo(lArray[i2].a().floatValue(), lArray[i2].b().floatValue(), lArray[i2 + 1].a().floatValue(), lArray[i2 + 1].b().floatValue(), lArray[i2 + 2].a().floatValue(), lArray[i2 + 2].b().floatValue());
        }
    }

    public void addBeziers(Point[] pointArray) {
        this.a(l.a(pointArray));
    }

    public void addBeziers(PointF[] pointFArray) {
        this.a(l.a(pointFArray));
    }

    public void addEllipse(float f2, float f3, float f4, float f5) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(f2, f3, f4, f5);
        if (((RectangularShape)float_).isEmpty()) {
            this.addBezier(new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3));
            this.addBezier(new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3));
            this.addBezier(new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3));
            this.addBezier(new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3), new PointF(f2, f3));
            this.closeFigure();
        } else {
            this.getNativeObject().append(float_, false);
        }
        this.b = true;
    }

    public void addEllipse(RectangleF rectangleF) {
        this.addEllipse(rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight());
    }

    public void addEllipse(Rectangle rectangle) {
        this.addEllipse(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void addEllipse(int n2, int n3, int n4, int n5) {
        this.addEllipse((float)n2, (float)n3, (float)n4, (float)n5);
    }

    public void addLine(float f2, float f3, float f4, float f5) {
        Line2D.Float float_ = new Line2D.Float(f2, f3, f4, f5);
        this.getNativeObject().append(float_, !this.b());
    }

    public void addLine(Point point, Point point2) {
        this.addLine(point.getX(), point.getY(), point2.getX(), point2.getY());
    }

    public void addLine(PointF pointF, PointF pointF2) {
        this.addLine(pointF.getX(), pointF.getY(), pointF2.getX(), pointF2.getY());
    }

    public void addLine(int n2, int n3, int n4, int n5) {
        this.addLine((float)n2, (float)n3, (float)n4, (float)n5);
    }

    private void b(l[] lArray) {
        if (lArray == null) {
            throw new ArgumentNullException("Value of 'points' cannot be null");
        }
        if (lArray.length == 0) {
            throw new ArgumentException("Value of 'points' cannot be empty");
        }
        if (this.b() || this.getNativeObject().getLastFigureClosed()) {
            this.getNativeObject().moveTo(lArray[0].a().floatValue(), lArray[0].b().floatValue());
        } else if (lArray[0].a().floatValue() != this.getLastPoint().getX() || lArray[0].b().floatValue() != this.getLastPoint().getY()) {
            this.getNativeObject().lineTo(lArray[0].a().floatValue(), lArray[0].b().floatValue());
        }
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            this.getNativeObject().lineTo(lArray[i2].a().floatValue(), lArray[i2].b().floatValue());
        }
    }

    public void addLines(Point[] pointArray) {
        this.b(l.a(pointArray));
    }

    public void addLines(PointF[] pointFArray) {
        this.b(l.a(pointFArray));
    }

    public void addPie(float f2, float f3, float f4, float f5, float f6, float f7) {
        Arc2D.Double double_ = null;
        double d2 = f4 / f5;
        double d3 = d2 * d2;
        double d4 = GraphicsPath.a(d3, f6);
        double d5 = GraphicsPath.a(d3, f6 + f7) - d4;
        double_ = new Arc2D.Double(f2, f3, f4, f5, -d4, -d5, 2);
        GraphicsPath graphicsPath = new GraphicsPath();
        graphicsPath.getNativeObject().append(double_, false);
        PointF[] pointFArray = graphicsPath.getPathPoints();
        byte[] byArray = graphicsPath.getPathTypes();
        PointF pointF = pointFArray[pointFArray.length - 1];
        for (int i2 = byArray.length - 1; i2 >= 1; --i2) {
            pointFArray[i2] = pointFArray[i2 - 1];
        }
        pointFArray[0] = pointF;
        byArray[1] = 1;
        byArray[byArray.length - 1] = -125;
        if (f6 == 0.0f && f7 % 360.0f == 0.0f) {
            pointFArray[0].setY((int)(f3 + f5 / 2.0f));
            pointFArray[1].setY(pointFArray[0].getY());
            pointFArray[pointFArray.length - 1].setY(pointFArray[0].getY());
        }
        this.getNativeObject().append(new GraphicsPath(pointFArray, byArray).getNativeObject(), false);
        this.b = true;
    }

    public void addPie(Rectangle rectangle, float f2, float f3) {
        this.addPie((float)rectangle.getX(), (float)rectangle.getY(), (float)rectangle.getWidth(), (float)rectangle.getHeight(), f2, f3);
    }

    public void addPie(int n2, int n3, int n4, int n5, float f2, float f3) {
        this.addPie((float)n2, (float)n3, (float)n4, (float)n5, f2, f3);
    }

    private void c(l[] lArray) {
        if (lArray == null) {
            throw new ArgumentNullException("points");
        }
        if (lArray.length < 3) {
            throw new ArgumentException("Invalid parameter used.");
        }
        this.getNativeObject().moveTo(lArray[0].a().floatValue(), lArray[0].b().floatValue());
        for (int i2 = 1; !(i2 >= lArray.length || lArray.length > 3 && i2 == lArray.length - 1 && lArray[i2].h(lArray[0])); ++i2) {
            this.getNativeObject().lineTo(lArray[i2].a().floatValue(), lArray[i2].b().floatValue());
        }
        this.getNativeObject().closePath();
        this.b = true;
    }

    public void addPolygon(Point[] pointArray) {
        this.c(l.a(pointArray));
    }

    public void addPolygon(PointF[] pointFArray) {
        this.c(l.a(pointFArray));
    }

    public void addRectangle(float f2, float f3, float f4, float f5) {
        if (f4 > 0.0f && f5 > 0.0f) {
            this.getNativeObject().moveTo(f2, f3);
            this.getNativeObject().lineTo(f2 + f4, f3);
            this.getNativeObject().lineTo(f2 + f4, f3 + f5);
            this.getNativeObject().lineTo(f2, f3 + f5);
            this.getNativeObject().closePath();
            this.b = true;
        }
    }

    public void addRectangle(RectangleF rectangleF) {
        this.addRectangle(rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight());
    }

    public void addRectangle(Rectangle rectangle) {
        this.addRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void addRectangles(Rectangle[] rectangleArray) {
        if (rectangleArray == null) {
            throw new ArgumentNullException("Value of 'rects' cannot be null");
        }
        if (rectangleArray.length == 0) {
            throw new ArgumentException("Value of 'rects' cannot be empty");
        }
        for (Rectangle rectangle : rectangleArray) {
            this.addRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        }
    }

    public void addRectangles(RectangleF[] rectangleFArray) {
        if (rectangleFArray == null) {
            throw new ArgumentNullException("Value of 'rects' cannot be null");
        }
        if (rectangleFArray.length == 0) {
            throw new ArgumentException("Value of 'rects' cannot be empty");
        }
        for (RectangleF rectangleF : rectangleFArray) {
            this.addRectangle(rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight());
        }
    }

    public void addPath(GraphicsPath graphicsPath, boolean bl2) {
        if (graphicsPath == null) {
            throw new ArgumentNullException("Value of 'addingPath' cannot be null");
        }
        if (this.b() || this.getNativeObject().getLastFigureClosed() || graphicsPath.getNativeObject().getLastFigureClosed()) {
            bl2 = false;
        }
        this.getNativeObject().append(graphicsPath.getNativeObject(), bl2);
    }

    public PointF getLastPoint() {
        return this.getNativeObject().getLastPoint();
    }

    public void reset() {
        this.getNativeObject().reset();
    }

    public RectangleF getBounds_() {
        return this.getBounds(null, null);
    }

    public RectangleF getBounds(Matrix matrix) {
        return this.getBounds(matrix, null);
    }

    private RectangleF a(Matrix matrix, Pen pen) {
        Ref<RectangleF> ref = new Ref<RectangleF>(new RectangleF());
        if (this.getNativeObject().gdipGetPathWorldBounds(ref, matrix, pen)) {
            return (RectangleF)ref.value;
        }
        throw new ArgumentException();
    }

    public RectangleF getBounds(Matrix matrix, Pen pen) {
        RectangleF rectangleF = new RectangleF(Region.InfiniteRegion.getBounds());
        RectangleF rectangleF2 = new RectangleF(this.getNativeObject().getBounds2D());
        if (rectangleF2.getX() <= rectangleF.getX() || rectangleF2.getY() <= rectangleF.getY() || rectangleF2.getWidth() >= rectangleF.getWidth() || rectangleF2.getHeight() >= rectangleF.getHeight()) {
            return rectangleF.Clone();
        }
        return this.a(matrix, pen);
    }

    public void transform(Matrix matrix) {
        if (matrix == null) {
            throw new ArgumentNullException("matrix");
        }
        this.getNativeObject().transform(matrix.getNativeObject());
    }

    public boolean isVisible(Point point) {
        return this.isVisible(point.getX(), point.getY(), (Graphics)null);
    }

    public boolean isVisible(PointF pointF) {
        return this.isVisible(pointF.getX(), pointF.getY(), null);
    }

    public boolean isVisible(int n2, int n3) {
        return this.isVisible(n2, n3, (Graphics)null);
    }

    public boolean isVisible(float f2, float f3) {
        return this.isVisible(f2, f3, null);
    }

    public boolean isVisible(Point point, Graphics graphics) {
        return this.isVisible(point.getX(), point.getY(), graphics);
    }

    public boolean isVisible(PointF pointF, Graphics graphics) {
        return this.isVisible(pointF.getX(), pointF.getY(), graphics);
    }

    public boolean isVisible(int n2, int n3, Graphics graphics) {
        return this.isVisible((float)n2, (float)n3, null);
    }

    public boolean isVisible(float f2, float f3, Graphics graphics) {
        return this.getNativeObject().contains(Math.round(f2), Math.round(f3));
    }

    public void reverse() {
        this.getNativeObject().reverse();
    }

    public void addClosedCurve(Point[] pointArray) {
        this.addClosedCurve(pointArray, 0.5f);
    }

    public void addClosedCurve(PointF[] pointFArray) {
        this.addClosedCurve(pointFArray, 0.5f);
    }

    private void a(l[] lArray, float f2) {
        if (lArray == null) {
            throw new ArgumentNullException("Value of 'points' cannot be null");
        }
        if (lArray.length < 3) {
            throw new ArgumentException("Value of 'points' is not valid");
        }
        int n2 = (lArray.length + 3) * 2;
        float[] fArray = new float[n2];
        fArray[--n2] = lArray[1].b().floatValue();
        fArray[--n2] = lArray[1].a().floatValue();
        fArray[--n2] = lArray[0].b().floatValue();
        fArray[--n2] = lArray[0].a().floatValue();
        for (int i2 = lArray.length - 1; i2 >= 0; --i2) {
            fArray[--n2] = lArray[i2].b().floatValue();
            fArray[--n2] = lArray[i2].a().floatValue();
        }
        fArray[--n2] = lArray[lArray.length - 1].b().floatValue();
        fArray[--n2] = lArray[lArray.length - 1].a().floatValue();
        this.a(fArray, false, f2);
        this.closeFigure();
    }

    public void addClosedCurve(Point[] pointArray, float f2) {
        this.a(l.a(pointArray), f2);
    }

    public void addClosedCurve(PointF[] pointFArray, float f2) {
        this.a(l.a(pointFArray), f2);
    }

    public void addCurve(Point[] pointArray) {
        this.addCurve(pointArray, 0.5f);
    }

    public void addCurve(PointF[] pointFArray) {
        this.addCurve(pointFArray, 0.5f);
    }

    private void b(l[] lArray, float f2) {
        if (lArray == null) {
            throw new ArgumentNullException("Value of 'points' cannot be null");
        }
        this.a(lArray, 0, lArray.length - 1, f2);
    }

    public void addCurve(Point[] pointArray, float f2) {
        this.b(l.a(pointArray), f2);
    }

    public void addCurve(PointF[] pointFArray, float f2) {
        this.b(l.a(pointFArray), f2);
    }

    private void a(l[] lArray, int n2, int n3, float f2) {
        if (lArray == null) {
            throw new ArgumentNullException("Value of 'points' cannot be null");
        }
        if (lArray.length < 2) {
            throw new ArgumentException("Value of 'points' is not valid");
        }
        if (n3 <= 0) {
            throw new ArgumentException("Value of 'numberOfSegments' is not valid");
        }
        if (n2 < 0) {
            throw new ArgumentException("Value of 'offset' is not valid");
        }
        if (n2 + n3 >= lArray.length) {
            throw new ArgumentException("Value of 'offset' or 'numberOfSegments' is not valid");
        }
        int n4 = n3 + 1;
        int n5 = n4 * 2 + 4;
        float[] fArray = new float[n5];
        int n6 = n2 + n4;
        if (n6 == lArray.length) {
            fArray[--n5] = lArray[--n6].b().floatValue();
            fArray[--n5] = lArray[n6].a().floatValue();
        }
        while (n5 > 0 && n6 >= 0) {
            fArray[--n5] = lArray[n6].b().floatValue();
            fArray[--n5] = lArray[n6].a().floatValue();
            --n6;
        }
        if (n5 > 0) {
            fArray[1] = lArray[0].b().floatValue();
            fArray[0] = lArray[0].a().floatValue();
        }
        this.a(fArray, !this.b() && !this.getNativeObject().getLastFigureClosed(), f2);
    }

    public void addCurve(Point[] pointArray, int n2, int n3, float f2) {
        this.a(l.a(pointArray), n2, n3, f2);
    }

    public void addCurve(PointF[] pointFArray, int n2, int n3, float f2) {
        this.a(l.a(pointFArray), n2, n3, f2);
    }

    private void a(float[] fArray, boolean bl2, float f2) {
        f2 /= 3.0f;
        if (bl2) {
            if (fArray[2] != this.getLastPoint().getX() || fArray[3] != this.getLastPoint().getY()) {
                this.getNativeObject().lineTo(fArray[2], fArray[3]);
            }
        } else {
            this.getNativeObject().moveTo(fArray[2], fArray[3]);
        }
        float f3 = fArray[4] - fArray[0];
        float f4 = fArray[5] - fArray[1];
        float f5 = fArray[2] + f2 * f3;
        float f6 = fArray[3] + f2 * f4;
        int n2 = fArray.length - 4;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            int n3 = i2;
            int n4 = n3++;
            int n5 = n3++;
            int n6 = n3++;
            int n7 = n3++;
            int n8 = n3++;
            int n9 = n3++;
            f3 = fArray[n8] - fArray[n4];
            f4 = fArray[n9] - fArray[n5];
            float f7 = fArray[n6] - f2 * f3;
            float f8 = fArray[n7] - f2 * f4;
            this.getNativeObject().curveTo(f5, f6, f7, f8, fArray[n6], fArray[n7]);
            f5 = fArray[n6] + f2 * f3;
            f6 = fArray[n7] + f2 * f4;
        }
    }

    public void addString(String string, FontFamily fontFamily, int n2, float f2, Point point, StringFormat stringFormat) {
        this.a(string, fontFamily, f2, n2, 2, point.getX(), point.getY(), Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, stringFormat);
    }

    public void addString(String string, FontFamily fontFamily, int n2, float f2, PointF pointF, StringFormat stringFormat) {
        this.a(string, fontFamily, f2, n2, 2, pointF.getX(), pointF.getY(), Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, stringFormat);
    }

    public void addString(String string, FontFamily fontFamily, int n2, float f2, Rectangle rectangle, StringFormat stringFormat) {
        this.a(string, fontFamily, f2, n2, 2, rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), stringFormat);
    }

    public void addString(String string, FontFamily fontFamily, int n2, float f2, RectangleF rectangleF, StringFormat stringFormat) {
        this.a(string, fontFamily, f2, n2, 2, rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight(), stringFormat);
    }

    private void a(String string, FontFamily fontFamily, float f2, int n2, int n3, float f3, float f4, float f5, float f6, StringFormat stringFormat) {
        if (string == null) {
            throw new NullReferenceException("Value of 's' cannot be null");
        }
        if (fontFamily == null) {
            throw new ArgumentException("Value of 'family' cannot be null");
        }
        string = string.replaceAll("\u0000", "");
        Font font = null;
        Font font2 = null;
        int n4 = 128;
        if (f2 <= 0.0f) {
            font = new Font(fontFamily, 1.0E-4f, n2, n3);
            font = FontFamily.getFontForNonLatinText(font, string);
        } else {
            font = new Font(fontFamily, f2, n2, n3);
            font = FontFamily.getFontForNonLatinText(font, string);
            font2 = new Font(font.getFontFamily(), f2 * (float)n4, n2, n3);
        }
        if (font2 != null && f2 < 80.0f) {
            GraphicsPath graphicsPath = new GraphicsPath();
            graphicsPath.a(null, font2, string, 0.0f, 0.0f, f5 * (float)n4, f6 * (float)n4, stringFormat);
            graphicsPath.transform(new Matrix(1.0f / (float)n4, 0.0f, 0.0f, 1.0f / (float)n4, f3, f4));
            this.a(graphicsPath, font, string, f3, f4, f5, f6, stringFormat);
            return;
        }
        this.a(null, font, string, f3, f4, f5, f6, stringFormat);
    }

    private void a(GraphicsPath graphicsPath, Font font, String string, float f2, float f3, float f4, float f5, StringFormat stringFormat) {
        TextLineIterator textLineIterator = new TextLineIterator(null, string, font, new FontRenderContext(null, true, true), stringFormat, f4, f5);
        int n2 = this.getNativeObject().getTypesCount();
        int n3 = n2 * 2;
        if (n3 > 0) {
            this.getNativeObject().setMarkers(n2);
        }
        if (graphicsPath == null) {
            boolean bl2 = font.getItalic() && font.getNativeObject().getItalicAngle() == 0.0f;
            LineLayout lineLayout = textLineIterator.nextLine();
            while (lineLayout != null) {
                Shape shape = bl2 ? lineLayout.getAlterOutline(f2, f3, font) : lineLayout.getOutline(f2, f3);
                this.getNativeObject().append(shape, false);
                lineLayout = textLineIterator.nextLine();
            }
        } else {
            this.addPath(graphicsPath, false);
        }
        this.setMarkers();
        AffineTransform affineTransform = textLineIterator.calcLineAlignmentTransform();
        if (affineTransform != null) {
            this.getNativeObject().transform(affineTransform, n3, this.getNativeObject().getCoordsCount() - n3);
        }
    }

    public void clearMarkers() {
        this.getNativeObject().clearMarkers();
    }

    public void closeAllFigures() {
        if (this.getPointCount() < 1) {
            return;
        }
        ExtendedGeneralPath extendedGeneralPath = this.getNativeObject();
        extendedGeneralPath.closeAllFigures();
        if (!extendedGeneralPath.getLastFigureClosed()) {
            extendedGeneralPath.closePath();
        }
        this.b = true;
    }

    public void closeFigure() {
        if (new PathData(this.getNativeObject()).getTypes().length > 0) {
            this.getNativeObject().closePath();
        }
        this.b = true;
    }

    public void flatten() {
        this.flatten(null, 0.25f);
    }

    public void flatten(Matrix matrix) {
        this.flatten(matrix, 0.25f);
    }

    public void flatten(Matrix matrix, float f2) {
        AffineTransform affineTransform = null;
        if (matrix != null) {
            affineTransform = matrix.getNativeObject();
        }
        if (!this.hasCurve()) {
            return;
        }
        this.a((JFlatteningPathIterator)this.getNativeObject().getPathIterator(affineTransform, f2));
    }

    private void a(GeneralPath generalPath, Matrix matrix, float f2) {
        AffineTransform affineTransform = null;
        if (matrix != null) {
            affineTransform = matrix.getNativeObject();
        }
        this.a((JFlatteningPathIterator)GraphicsPathConverter.nativeToExtended(generalPath).getPathIterator(affineTransform, f2));
    }

    private void a(ExtendedGeneralPath extendedGeneralPath, Matrix matrix, float f2) {
        AffineTransform affineTransform = null;
        if (matrix != null) {
            affineTransform = matrix.getNativeObject();
        }
        this.a((JFlatteningPathIterator)extendedGeneralPath.getPathIterator(affineTransform, f2));
    }

    private void a(JFlatteningPathIterator jFlatteningPathIterator) {
        ExtendedGeneralPath extendedGeneralPath = new ExtendedGeneralPath();
        extendedGeneralPath.append(jFlatteningPathIterator, false);
        this.setShape(extendedGeneralPath);
    }

    public boolean isOutlineVisible(Point point, Pen pen) {
        return this.isOutlineVisible(point.getX(), point.getY(), pen, (Graphics)null);
    }

    public boolean isOutlineVisible(PointF pointF, Pen pen) {
        return this.isOutlineVisible(pointF.getX(), pointF.getY(), pen, null);
    }

    public boolean isOutlineVisible(int n2, int n3, Pen pen) {
        return this.isOutlineVisible(n2, n3, pen, (Graphics)null);
    }

    public boolean isOutlineVisible(float f2, float f3, Pen pen) {
        return this.isOutlineVisible(f2, f3, pen, null);
    }

    public boolean isOutlineVisible(Point point, Pen pen, Graphics graphics) {
        return this.isOutlineVisible(point.getX(), point.getY(), pen, graphics);
    }

    public boolean isOutlineVisible(PointF pointF, Pen pen, Graphics graphics) {
        return this.isOutlineVisible(pointF.getX(), pointF.getY(), pen, graphics);
    }

    public boolean isOutlineVisible(int n2, int n3, Pen pen, Graphics graphics) {
        return this.isOutlineVisible((float)n2, (float)n3, pen, graphics);
    }

    private static boolean a(GraphicsPath graphicsPath, float f2, float f3, Pen pen, Graphics graphics) {
        int n2 = 3;
        boolean bl2 = true;
        float f4 = 0.5f;
        boolean bl3 = true;
        Graphics graphics2 = null;
        int n3 = 2;
        if (graphicsPath == null || pen == null) {
            throw new ArgumentNullException();
        }
        GraphicsState graphicsState = null;
        if (graphics != null) {
            graphics2 = graphics;
            graphicsState = graphics.save();
            n3 = graphics2.getPageUnit();
        } else {
            graphics2 = Graphics.fromImage(new Bitmap(1, 1));
        }
        graphics2.setPageUnit(2);
        Pen pen2 = new Pen(pen.getBrush(), pen.getWidth() - f4);
        graphics2.drawPath(pen2, graphicsPath);
        Shape shape = pen2.createStrokedShape(GraphicsPathConverter.extendedToNative(graphicsPath.getNativeObject()));
        bl3 = shape.contains(Math.round(f2), Math.round(f3));
        if (graphics != null) {
            graphics.restore(graphicsState);
            graphics2.setPageUnit(n3);
        }
        return bl3;
    }

    private static boolean b(GraphicsPath graphicsPath, float f2, float f3, Pen pen, Graphics graphics) {
        int n2 = 3;
        boolean bl2 = true;
        float f4 = 0.5f;
        boolean bl3 = true;
        Graphics graphics2 = null;
        int n3 = 2;
        if (graphicsPath == null || pen == null) {
            throw new ArgumentNullException();
        }
        GraphicsState graphicsState = null;
        if (graphics != null) {
            graphics2 = graphics;
            graphicsState = graphics.save();
            n3 = graphics2.getPageUnit();
        } else {
            graphics2 = Graphics.fromImage(new Bitmap(1, 1));
        }
        graphics2.setPageUnit(2);
        Pen pen2 = pen;
        Shape shape = pen2.createStrokedShape(GraphicsPathConverter.extendedToNative(graphicsPath.getNativeObject()));
        bl3 = shape.contains(Math.round(f2), Math.round(f3));
        boolean bl4 = bl3 = bl3 && graphics2.isVisible(f2, f3);
        if (graphics != null) {
            graphics.restore(graphicsState);
            graphics2.setPageUnit(n3);
        }
        return bl3;
    }

    public boolean isOutlineVisible(float f2, float f3, Pen pen, Graphics graphics) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        return GraphicsPath.a(this, f2, f3, pen, graphics);
    }

    public void setMarkers() {
        this.getNativeObject().setMarkers();
    }

    public void startFigure() {
        this.b = true;
    }

    private boolean b() {
        boolean bl2 = this.b;
        this.b = false;
        return bl2;
    }

    public void warp(PointF[] pointFArray, RectangleF rectangleF) {
        this.warp(pointFArray, rectangleF.Clone(), null, 0, 0.25f);
    }

    public void warp(PointF[] pointFArray, RectangleF rectangleF, Matrix matrix) {
        this.warp(pointFArray, rectangleF.Clone(), matrix, 0, 0.25f);
    }

    public void warp(PointF[] pointFArray, RectangleF rectangleF, Matrix matrix, int n2) {
        this.warp(pointFArray, rectangleF.Clone(), matrix, n2, 0.25f);
    }

    public boolean hasCurve() {
        return this.getNativeObject().hasCurve();
    }

    public boolean hasNotClosedSubPathes() {
        if (!this.getNativeObject().getLastFigureClosed()) {
            return true;
        }
        byte[] byArray = this.getPathTypes();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] != 0 || (byArray[i2 - 1] & 0x80) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasClosedSubPathes() {
        if (this.getPointCount() == 0) {
            return false;
        }
        if (this.getNativeObject().getLastFigureClosed()) {
            return true;
        }
        byte[] byArray = this.getPathTypes();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    boolean a() {
        if (!this.getNativeObject().getLastFigureClosed()) {
            return false;
        }
        byte[] byArray = this.getPathTypes();
        PointF[] pointFArray = this.getPathPoints();
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & 0x80) == 0) continue;
            if (i2 - n2 >= 2) {
                int n3 = n2;
                while (n3 + 2 <= i2) {
                    if (!Primitive2D.belongToLine(pointFArray[n3], pointFArray[n3 + 1], pointFArray[n3 + 2], 0.499f)) {
                        return true;
                    }
                    ++n3;
                }
            }
            n2 = i2 + 1;
        }
        return false;
    }

    private void a(Matrix matrix, float f2) {
        if (this.hasCurve()) {
            this.flatten(matrix, f2);
        } else if (!MatrixUtil.isMatrixEmpty(matrix)) {
            this.transform(matrix);
        }
    }

    public void warp(PointF[] pointFArray, RectangleF rectangleF, Matrix matrix, int n2, float f2) {
        if (pointFArray == null) {
            throw new ArgumentNullException("destPoints");
        }
        if (pointFArray.length < 1) {
            throw new ArgumentException("destPoints");
        }
        int n3 = this.getPointCount();
        if (n3 == 0) {
            return;
        }
        if (n2 != 0 && n2 != 1 || n3 == 1) {
            this.reset();
            return;
        }
        if (!(rectangleF.getWidth() < 0.0f) && !(rectangleF.getHeight() < 0.0f)) {
            if (rectangleF.isEmpty()) {
                this.getNativeObject().setCoordsToNaN();
                return;
            }
            if (pointFArray.length < 3) {
                this.getNativeObject().setCoordsToZero();
                if (matrix != null) {
                    this.transform(matrix);
                }
                return;
            }
            PointF[] pointFArray2 = pointFArray;
            if (pointFArray.length >= 3) {
                pointFArray2 = Primitive2D.formParallelogramByNetPoints(pointFArray[0], pointFArray[1], pointFArray[2]);
            }
            pointFArray2 = Primitive2D.normalizeParallelogram(pointFArray2[0], pointFArray2[1], pointFArray2[2], pointFArray2[3]);
            double d2 = Primitive2D.linelen(pointFArray2[0], pointFArray2[1]);
            double d3 = Primitive2D.linelen(pointFArray2[1], pointFArray2[2]);
            double d4 = Primitive2D.lineAngle(pointFArray2[0], pointFArray2[1]);
            double d5 = Primitive2D.lineAngle(pointFArray2[0], pointFArray2[3]);
            RectangleF rectangleF2 = new RectangleF((float)this.getShape().getBounds2D().getX(), (float)this.getShape().getBounds2D().getY(), (float)this.getShape().getBounds2D().getWidth() == 0.0f ? 1.0f : (float)this.getShape().getBounds2D().getWidth(), (float)this.getShape().getBounds2D().getHeight() == 0.0f ? 1.0f : (float)this.getShape().getBounds2D().getHeight()).Clone();
            GraphicsPath graphicsPath = new GraphicsPath();
            graphicsPath.addRectangle(rectangleF2);
            Matrix matrix2 = new Matrix();
            double d6 = rectangleF2.getWidth() / rectangleF.getWidth();
            double d7 = rectangleF2.getHeight() / rectangleF.getHeight();
            matrix2.scale((float)(1.0 / d6), (float)(1.0 / d7));
            graphicsPath.transform(matrix2);
            Matrix matrix3 = new Matrix();
            matrix3.translate(-((float)((double)(rectangleF2.getX() * 1.0f) / d6)), -((float)((double)(rectangleF2.getY() * 1.0f) / d7)));
            matrix3.translate(-(-rectangleF.getX() * 1.0f), -(-rectangleF.getY() * 1.0f));
            graphicsPath.transform(matrix3);
            PointF[] pointFArray3 = this.getPathPoints();
            if (n2 == 0) {
                for (int i2 = 0; i2 < pointFArray3.length; ++i2) {
                    pointFArray3[i2] = o.a(graphicsPath.getBounds_(), pointFArray2[0], d2, d3, d4, d5, pointFArray3[i2]);
                }
                this.a(pointFArray3, this.getPathTypes());
                this.flatten(matrix, f2 < 0.0f || f2 > 1.0f ? 0.5f : f2);
            } else {
                pointFArray3 = this.getPathPoints();
                n n4 = new n(graphicsPath.getBounds_().getLeft(), graphicsPath.getBounds_().getTop(), graphicsPath.getBounds_().getRight(), graphicsPath.getBounds_().getBottom(), new float[]{pointFArray2[0].getX(), pointFArray2[0].getY(), pointFArray2[1].getX(), pointFArray2[1].getY(), pointFArray2[2].getX(), pointFArray2[2].getY(), pointFArray2[3].getX(), pointFArray2[3].getY()});
                for (int i3 = 0; i3 < pointFArray3.length; ++i3) {
                    pointFArray3[i3] = n4.a(pointFArray3[i3]);
                }
                this.a(pointFArray3, this.getPathTypes());
                if (matrix != null) {
                    this.transform(matrix);
                }
                this.flatten(new Matrix(), f2 < 0.0f || f2 > 1.0f ? 0.5f : f2);
            }
        }
    }

    public void widen(Pen pen) {
        this.widen(pen, null);
    }

    public void widen(Pen pen, Matrix matrix) {
        this.widen(pen, matrix, 0.6666667f);
    }

    public GraphicsPath[] splitIntoSubpathes(boolean bl2) {
        if (this.getNativeObject().getPointCount() < 2) {
            return new GraphicsPath[]{(GraphicsPath)this.deepClone()};
        }
        byte[] byArray = this.getPathTypes();
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != 0) continue;
            nArray[n2++] = i2;
        }
        if (n2 == 1) {
            return new GraphicsPath[]{(GraphicsPath)this.deepClone()};
        }
        PointF[] pointFArray = this.getPathPoints();
        ArrayList<GraphicsPath> arrayList = new ArrayList<GraphicsPath>();
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3 = (i3 == n2 - 1 ? byArray.length : nArray[i3 + 1]) - nArray[i3];
            byte[] byArray2 = new byte[n3];
            PointF[] pointFArray2 = new PointF[n3];
            for (int i4 = 0; i4 < n3; ++i4) {
                pointFArray2[i4] = pointFArray[nArray[i3] + i4].Clone();
                byArray2[i4] = byArray[nArray[i3] + i4];
            }
            GraphicsPath graphicsPath = new GraphicsPath(pointFArray2, byArray2);
            if (bl2) {
                throw new NotImplementedException();
            }
            arrayList.add(graphicsPath);
        }
        return arrayList.toArray(new GraphicsPath[arrayList.size()]);
    }

    private static GraphicsPath a(GraphicsPath graphicsPath, Pen pen, Matrix matrix, float f2) {
        graphicsPath = (GraphicsPath)graphicsPath.deepClone();
        GraphicsPath graphicsPath2 = new GraphicsPath();
        if (matrix != null) {
            graphicsPath.transform(matrix);
            graphicsPath.flatten(null, f2);
            Matrix matrix2 = matrix.deepClone();
            matrix2.invert();
            graphicsPath.transform(matrix2);
            Shape shape = pen.createWidenShape(GraphicsPathConverter.extendedToNative(graphicsPath.getNativeObject()));
            graphicsPath2.setShape(GraphicsPathConverter.nativeToExtended(shape));
            graphicsPath2.transform(matrix);
        } else {
            graphicsPath.flatten(null, f2);
            Shape shape = pen.createWidenShape(GraphicsPathConverter.extendedToNative(graphicsPath.getNativeObject()));
            graphicsPath2.setShape(GraphicsPathConverter.nativeToExtended(shape));
        }
        return graphicsPath2;
    }

    public void widen(Pen pen, Matrix matrix, float f2) {
        CustomLineCap[] customLineCapArray;
        boolean bl2;
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (this.getPointCount() == 0) {
            return;
        }
        if (this.getPointCount() <= 1) {
            throw new OutOfMemoryException("Path count must be greater than 1");
        }
        boolean bl3 = bl2 = this.hasNotClosedSubPathes() && this.getNativeObject().getPointCount() >= 2;
        if (bl2) {
            customLineCapArray = pen.getCustomCaps();
        } else {
            CustomLineCap[] customLineCapArray2 = new CustomLineCap[2];
            customLineCapArray2[0] = null;
            customLineCapArray = customLineCapArray2;
            customLineCapArray2[1] = null;
        }
        CustomLineCap[] customLineCapArray3 = customLineCapArray;
        bl2 = customLineCapArray3[0] != null || customLineCapArray3[1] != null;
        GraphicsPath graphicsPath = (GraphicsPath)this.deepClone();
        if (customLineCapArray3[0] != null) {
            graphicsPath = CustomLineCap.applyInsetUsual(graphicsPath, pen.getEffectiveWidth(), customLineCapArray3[0], true)[1];
        }
        if (customLineCapArray3[1] != null) {
            graphicsPath = CustomLineCap.applyInsetUsual(graphicsPath, pen.getEffectiveWidth(), customLineCapArray3[1], false)[1];
        }
        GraphicsPath[] graphicsPathArray = graphicsPath.splitIntoSubpathes(false);
        graphicsPath = new GraphicsPath();
        for (GraphicsPath graphicsPath2 : graphicsPathArray) {
            GraphicsPath graphicsPath3 = GraphicsPath.a(graphicsPath2, pen, matrix, f2);
            graphicsPath3.closeAllFigures();
            if (!graphicsPath2.getNativeObject().getLastFigureClosed()) {
                byte[] byArray = graphicsPath3.getPathTypes();
                int n2 = graphicsPath3.getPointCount() - 1;
                byArray[n2] = (byte)(byArray[n2] & 0xFFFFFF7F);
            }
            graphicsPath.addPath(graphicsPath3, false);
        }
        pen = (Pen)pen.deepClone();
        pen.setLineJoin(0);
        pen.setLineCap(0, 0, pen.getDashCap());
        GraphicsPath graphicsPath4 = new GraphicsPath();
        Matrix[] matrixArray = new Matrix[]{new Matrix(), new Matrix()};
        if (bl2) {
            CustomLineCap.a(pen, GraphicsPathConverter.extendedToNative(this.getNativeObject()), customLineCapArray3[0], customLineCapArray3[1], matrixArray);
        }
        GraphicsPath graphicsPath5 = null;
        float f3 = 1.0f;
        if (bl2) {
            for (int i2 = 0; i2 < 2; ++i2) {
                if (customLineCapArray3[i2] == null) continue;
                if (customLineCapArray3[i2].strokePath != null) {
                    graphicsPath5 = customLineCapArray3[i2].strokePath;
                } else if (customLineCapArray3[i2].fillPath != null) {
                    graphicsPath5 = customLineCapArray3[i2].fillPath;
                }
                if (i2 == 0) {
                    if (customLineCapArray3[i2].strokePath != null) {
                        graphicsPath5.transform(matrixArray[0]);
                        graphicsPath5 = GraphicsPath.a(graphicsPath5, pen, matrix, f2);
                    } else {
                        matrixArray[0].scale(f3, f3);
                        graphicsPath5.transform(matrixArray[0]);
                    }
                    graphicsPath4.addPath(graphicsPath5, false);
                    graphicsPath4.addPath(graphicsPath, false);
                    continue;
                }
                if (customLineCapArray3[i2].strokePath != null) {
                    graphicsPath5.transform(matrixArray[1]);
                    graphicsPath5 = GraphicsPath.a(graphicsPath5, pen, matrix, f2);
                } else {
                    matrixArray[1].scale(f3, f3);
                    graphicsPath5.transform(matrixArray[1]);
                }
                if (graphicsPath4.getPointCount() <= 0) {
                    graphicsPath4.addPath(graphicsPath, false);
                }
                graphicsPath4.addPath(graphicsPath5, false);
            }
        }
        if (graphicsPath4.getPointCount() <= 0) {
            graphicsPath4.addPath(graphicsPath, true);
        }
        this.setShape(graphicsPath4.getNativeObject());
        this.setFillMode(1);
    }

    private void a(Pen pen, Matrix matrix, float f2) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (this.getPointCount() == 0) {
            return;
        }
        if (this.getPointCount() <= 1) {
            throw new OutOfMemoryException("Path count must be greater than 1");
        }
        GraphicsPath graphicsPath = new GraphicsPath();
        CustomLineCap[] customLineCapArray = new CustomLineCap[]{null, null};
        try {
            customLineCapArray[0] = pen.getCustomStartCap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            customLineCapArray[1] = pen.getCustomEndCap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Matrix[] matrixArray = new Matrix[]{new Matrix(), new Matrix()};
        CustomLineCap.a(pen, GraphicsPathConverter.extendedToNative(this.getNativeObject()), customLineCapArray[0], customLineCapArray[1], matrixArray);
        if (pen.getTransform() != null) {
            // empty if block
        }
        GraphicsPath graphicsPath2 = null;
        if (!this.getNativeObject().getLastFigureClosed() && this.getNativeObject().getPointCount() >= 2) {
            for (int i2 = 0; i2 < 2; ++i2) {
                if (customLineCapArray[i2] == null) continue;
                if (customLineCapArray[i2].strokePath != null) {
                    graphicsPath2 = customLineCapArray[i2].strokePath;
                } else if (customLineCapArray[i2].fillPath != null) {
                    graphicsPath2 = customLineCapArray[i2].fillPath;
                }
                if (i2 == 0) {
                    graphicsPath2.transform(matrixArray[0]);
                    graphicsPath.addPath(graphicsPath2, false);
                    graphicsPath.addPath(this, false);
                    continue;
                }
                graphicsPath2.transform(matrixArray[1]);
                if (graphicsPath.getPointCount() <= 0) {
                    graphicsPath.addPath(this, false);
                }
                graphicsPath.addPath(graphicsPath2, false);
            }
        }
        if (graphicsPath.getPointCount() <= 0) {
            graphicsPath.addPath(this, true);
        }
        if (matrix != null) {
            graphicsPath.transform(matrix);
            graphicsPath.flatten(null, f2);
            Matrix matrix2 = matrix.deepClone();
            matrix2.invert();
            graphicsPath.transform(matrix2);
            Shape shape = pen.createWidenShape(GraphicsPathConverter.extendedToNative(graphicsPath.getNativeObject()));
            this.setShape(GraphicsPathConverter.nativeToExtended(shape));
            this.transform(matrix);
        } else {
            graphicsPath.flatten(null, f2);
            Shape shape = pen.createWidenShape(GraphicsPathConverter.extendedToNative(graphicsPath.getNativeObject()));
            this.setShape(GraphicsPathConverter.nativeToExtended(shape));
        }
    }

    private static boolean a(PointF pointF, PointF pointF2, PointF pointF3) {
        float f2 = pointF2.getY() - pointF.getY();
        float f3 = pointF2.getX() - pointF.getX();
        float f4 = pointF3.getY() - pointF2.getY();
        float f5 = pointF3.getX() - pointF2.getX();
        if (f3 == 0.0f && f2 == 0.0f || f5 == 0.0f && f4 == 0.0f) {
            return pointF.equals(pointF3) && pointF2.equals(pointF3);
        }
        if (pointF.getX() == pointF2.getX() && pointF.getX() == pointF3.getX()) {
            return true;
        }
        if (pointF.getY() == pointF2.getY() && pointF.getY() == pointF3.getY()) {
            return true;
        }
        float f6 = f2 / f3;
        float f7 = f4 / f5;
        return Math.abs(f6 - f7) < 0.01f;
    }

    /*
     * WARNING - void declaration
     */
    private void c() {
        void var5_8;
        int n2;
        PointF[] pointFArray = this.getPathPoints();
        if (pointFArray.length < 3) {
            return;
        }
        byte[] byArray = this.getPathTypes();
        LinkedList<PointF> linkedList = new LinkedList<PointF>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (PointF pointF : pointFArray) {
            linkedList.add(pointF);
        }
        byte[] i2 = byArray;
        int n3 = i2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            byte by2 = i2[n2];
            linkedList2.add(by2 & 0xFF);
        }
        int pointFArray2 = 2;
        while (var5_8 < linkedList.size()) {
            if (GraphicsPath.a((PointF)linkedList.get((int)var5_8), (PointF)linkedList.get((int)(var5_8 - true)), (PointF)linkedList.get((int)(var5_8 - 2)))) {
                if ((Integer)linkedList2.get((int)(var5_8 - true)) != 0 && ((Integer)linkedList2.get((int)(var5_8 - true)) & 0x80) != 0 && ((Integer)linkedList2.get((int)(var5_8 - true)) & 0x20) != 0) {
                    linkedList.remove((int)(var5_8 - true));
                    linkedList2.remove((int)(var5_8 - true));
                } else if ((Integer)linkedList2.get((int)(var5_8 - 2)) != 0 && ((Integer)linkedList2.get((int)(var5_8 - 2)) & 0x80) != 0 && ((Integer)linkedList2.get((int)(var5_8 - 2)) & 0x20) != 0) {
                    linkedList.remove((int)(var5_8 - 2));
                    linkedList2.remove((int)(var5_8 - 2));
                } else if ((Integer)linkedList2.get((int)var5_8) != 0 && ((Integer)linkedList2.get((int)var5_8) & 0x80) != 0 && ((Integer)linkedList2.get((int)var5_8) & 0x20) != 0) {
                    linkedList.remove((int)var5_8);
                    linkedList2.remove((int)var5_8);
                }
            }
            ++var5_8;
        }
        PointF[] pointFArray3 = new PointF[linkedList.size()];
        byte[] byArray2 = new byte[linkedList2.size()];
        for (n2 = 0; n2 < linkedList2.size(); ++n2) {
            pointFArray3[n2] = (PointF)linkedList.get(n2);
            byArray2[n2] = ((Integer)linkedList2.get(n2)).byteValue();
        }
        this.a(pointFArray3, byArray2);
    }

    void a(PointF[] pointFArray, byte[] byArray) {
        this.a(l.a(pointFArray), byArray);
    }

    private void a(l[] lArray, byte[] byArray) {
        if (lArray == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (byArray == null) {
            throw new NullReferenceException("Value of 'types' cannot be null");
        }
        if (lArray.length != byArray.length) {
            throw new ArgumentException("Value of 'pts.length' must be equal to 'types.length'");
        }
        this.getNativeObject().reset();
        if (byArray.length > 0 && (byArray[0] & 0xFF & 7) != 0) {
            byArray[0] = 0;
        }
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF & 7;
            switch (n2) {
                case 0: {
                    this.getNativeObject().moveTo(lArray[i2].a().floatValue(), lArray[i2].b().floatValue());
                    break;
                }
                case 1: {
                    this.getNativeObject().lineTo(lArray[i2].a().floatValue(), lArray[i2].b().floatValue());
                    break;
                }
                case 3: {
                    if (i2 + 2 >= lArray.length || (byArray[i2 + 1] & 0xFF & 7) != 3 || (byArray[i2 + 2] & 0xFF & 7) != 3) {
                        this.a(new PointF[0], new byte[0]);
                        return;
                    }
                    float f2 = lArray[i2].a().floatValue();
                    float f3 = lArray[i2].b().floatValue();
                    float f4 = lArray[++i2].a().floatValue();
                    float f5 = lArray[i2].b().floatValue();
                    float f6 = lArray[++i2].a().floatValue();
                    float f7 = lArray[i2].b().floatValue();
                    this.getNativeObject().curveTo(f2, f3, f4, f5, f6, f7);
                }
            }
            if ((byArray[i2] & 0xFF & 0x80) != 0) {
                this.getNativeObject().closePath();
            }
            if ((byArray[i2] & 0xFF & 4) != 0) {
                this.getNativeObject().closePath();
            }
            if (i2 == lArray.length - 1 && lArray.length == byArray.length - 1) {
                if ((byArray[i2 + 1] & 0xFF & 0x80) != 0) {
                    this.getNativeObject().closePath();
                }
                if ((byArray[i2 + 1] & 0xFF & 4) != 0) {
                    this.getNativeObject().closePath();
                }
            }
            if ((byArray[i2] & 0xFF & 0x20) == 0) continue;
            this.setMarkers();
        }
    }

    public static Shape toJava(GraphicsPath graphicsPath) {
        if (graphicsPath == null) {
            return null;
        }
        return graphicsPath.getNativeObject().getNativeObject();
    }

    public static GraphicsPath fromJava(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof GeneralPath) {
            return new GraphicsPath((GeneralPath)shape);
        }
        return new GraphicsPath(new ExtendedGeneralPath(shape));
    }

    public static final class JPI {
        public static final int SegMoveTo = 0;
        public static final int SegLineTo = 1;
        public static final int SegQuadTo = 2;
        public static final int SegCubicTo = 3;
        public static final int SegClose = 4;

        static {
            Enum.register(new Enum.SimpleEnum((Class)JPI.class, Integer.class){
                {
                    this.addConstant("SegMoveTo", 0L);
                    this.addConstant("SegLineTo", 1L);
                    this.addConstant("SegQuadTo", 2L);
                    this.addConstant("SegCubicTo", 3L);
                    this.addConstant("SegClose", 4L);
                }
            });
        }
    }
}

