/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.Net.IPv6Address;
import com.aspose.html.internal.ms.System.Net.Sockets.SocketException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.lang.Operators;

public class IPAddress {
    private long a;
    private int b;
    private int[] c;
    private long d;
    public static final IPAddress Any = new IPAddress(Operators.castToInt64(0, 9));
    public static final IPAddress Broadcast = IPAddress.parse("255.255.255.255");
    public static final IPAddress Loopback = IPAddress.parse("127.0.0.1");
    public static final IPAddress None = IPAddress.parse("255.255.255.255");
    public static final IPAddress IPv6Any = IPAddress.b("::");
    public static final IPAddress IPv6Loopback = IPAddress.b("::1");
    public static final IPAddress IPv6None = IPAddress.b("::");
    private int e;

    private static short a(short s2) {
        return (short)(s2 >> 8 & 0xFF | s2 << 8 & 0xFF00);
    }

    private static int a(int n2) {
        return n2 >> 24 & 0xFF | n2 >> 8 & 0xFF00 | n2 << 8 & 0xFF0000 | n2 << 24;
    }

    private static long b(long l2) {
        return l2 >> 56 & Operators.castToInt64(255, 9) | l2 >> 40 & Operators.castToInt64(65280, 9) | l2 >> 24 & Operators.castToInt64(0xFF0000, 9) | l2 >> 8 & Operators.castToInt64(0xFF000000L, 10) | l2 << 8 & 0xFF00000000L | l2 << 24 & 0xFF0000000000L | l2 << 40 & 0xFF000000000000L | l2 << 56;
    }

    public static short hostToNetworkOrder_Int16(short s2) {
        return IPAddress.a(s2);
    }

    public static int hostToNetworkOrder_Int32(int n2) {
        return IPAddress.a(n2);
    }

    public static long hostToNetworkOrder_Int64(long l2) {
        return IPAddress.b(l2);
    }

    public static short networkToHostOrder_Int16(short s2) {
        return IPAddress.a(s2);
    }

    public static int networkToHostOrder_Int32(int n2) {
        return IPAddress.a(n2);
    }

    public static long networkToHostOrder_Int64(long l2) {
        return IPAddress.b(l2);
    }

    public IPAddress(long l2) {
        this.a = l2;
        this.b = 2;
    }

    public IPAddress(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("address");
        }
        int n2 = Array.boxing(byArray).getLength();
        if (n2 != 16 && n2 != 4) {
            throw new ArgumentException("An invalid IP address was specified.", "address");
        }
        if (n2 == 16) {
            this.c = this.a(byArray);
            this.b = 23;
            this.d = Operators.castToInt64(0, 9);
        } else {
            this.a = Operators.castToInt64(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(byArray[3], 6), 10) << 24, 10) + Operators.castToUInt32(Operators.castToInt32(byArray[2], 6) << 16, 9), 10) + Operators.castToUInt32(Operators.castToInt32(byArray[1], 6) << 8, 9), 10) + Operators.castToUInt32(byArray[0], 6), 10);
            this.b = 2;
        }
    }

    public IPAddress(byte[] byArray, long l2) {
        if (byArray == null) {
            throw new ArgumentNullException("address");
        }
        if (Array.boxing(byArray).getLength() != 16) {
            throw new ArgumentException("An invalid IP address was specified.", "address");
        }
        this.c = this.a(byArray);
        this.b = 23;
        this.d = l2;
    }

    IPAddress(int[] nArray, long l2) {
        this.c = nArray;
        for (int i2 = 0; i2 < 8; ++i2) {
            this.c[i2] = Operators.castToUInt16(IPAddress.hostToNetworkOrder_Int16(Operators.castToInt16(this.c[i2], 8)), 7);
        }
        this.b = 23;
        this.d = l2;
    }

    public static IPAddress parse(String string) {
        IPAddress iPAddress = null;
        IPAddress[] iPAddressArray = new IPAddress[]{iPAddress};
        boolean bl2 = IPAddress.tryParse(string, iPAddressArray);
        iPAddress = iPAddressArray[0];
        if (bl2) {
            return iPAddress;
        }
        throw new FormatException("An invalid IP address was specified.");
    }

    public static boolean tryParse(String string, IPAddress[] iPAddressArray) {
        if (string == null) {
            throw new ArgumentNullException("ipString");
        }
        iPAddressArray[0] = IPAddress.a(string);
        return iPAddressArray[0] != null || (iPAddressArray[0] = IPAddress.b(string)) != null;
    }

    private static IPAddress a(String string) {
        String[] stringArray;
        int n2 = StringExtensions.indexOf(string, ' ');
        if (n2 != -1) {
            stringArray = StringExtensions.split(StringExtensions.substring(string, n2 + 1), new char[]{'.'});
            if (Array.boxing(stringArray).getLength() > 0) {
                String string2 = stringArray[Array.boxing(stringArray).getLength() - 1];
                if (string2.length() == 0) {
                    return null;
                }
                for (int i2 = 0; i2 < string2.length(); ++i2) {
                    char c2 = string2.charAt(i2);
                    if (Uri.isHexDigit(c2)) continue;
                    return null;
                }
            }
            string = StringExtensions.substring(string, 0, n2);
        }
        if (string.length() == 0 || string.charAt(string.length() - 1) == '.') {
            return null;
        }
        stringArray = StringExtensions.split(string, new char[]{'.'});
        if (Array.boxing(stringArray).getLength() > 4) {
            return null;
        }
        try {
            long l2 = Operators.castToInt64(0, 9);
            long l3 = Operators.castToInt64(0, 9);
            for (int i3 = 0; i3 < Array.boxing(stringArray).getLength(); ++i3) {
                int n3;
                String string3 = stringArray[i3];
                if (3 <= string3.length() && string3.length() <= 4 && string3.charAt(0) == '0' && (string3.charAt(1) == 'x' || string3.charAt(1) == 'X')) {
                    l3 = string3.length() == 3 ? Operators.castToInt64(Operators.castToByte(Uri.fromHex(string3.charAt(2)), 9), 6) : Operators.castToInt64(Operators.castToByte(Uri.fromHex(string3.charAt(2)) << 4 | Uri.fromHex(string3.charAt(3)), 9), 6);
                } else {
                    if (string3.length() == 0) {
                        return null;
                    }
                    if (string3.charAt(0) == '0') {
                        l3 = Operators.castToInt64(0, 9);
                        for (n3 = 1; n3 < string3.length(); ++n3) {
                            if ('0' > string3.charAt(n3) || string3.charAt(n3) > '7') {
                                return null;
                            }
                            l3 = (l3 << 3) + Operators.castToInt64(Character.valueOf(string3.charAt(n3)), 4) - Operators.castToInt64(Character.valueOf('0'), 4);
                        }
                    } else {
                        long[] lArray = new long[]{l3};
                        boolean bl2 = !Int64Extensions.tryParse(string3, 0, null, lArray);
                        l3 = lArray[0];
                        if (bl2) {
                            return null;
                        }
                    }
                }
                if (i3 == Array.boxing(stringArray).getLength() - 1) {
                    if (i3 != 0 && l3 >= (long)(256 << (3 - i3) * 8)) {
                        return null;
                    }
                    if (l3 > 0x3FFFFFFFEL) {
                        return null;
                    }
                    i3 = 3;
                } else if (l3 >= 256L) {
                    return null;
                }
                n3 = 0;
                while (l3 > 0L) {
                    l2 |= (l3 & Operators.castToInt64(255, 9)) << (i3 - n3 << 3);
                    ++n3;
                    l3 /= Operators.castToInt64(256, 9);
                }
            }
            return new IPAddress(l2);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static IPAddress b(String string) {
        IPv6Address iPv6Address = null;
        IPv6Address[] iPv6AddressArray = new IPv6Address[]{iPv6Address};
        boolean bl2 = IPv6Address.a(string, iPv6AddressArray);
        iPv6Address = iPv6AddressArray[0];
        if (bl2) {
            return new IPAddress(iPv6Address.a(), iPv6Address.c());
        }
        return null;
    }

    public long getAddress() {
        if (this.b != 2) {
            throw new Exception("The attempted operation is not supported for the type of object referenced");
        }
        return this.a;
    }

    public void setAddress(long l2) {
        if (this.b != 2) {
            throw new Exception("The attempted operation is not supported for the type of object referenced");
        }
        this.a = l2;
    }

    long a() {
        return this.a;
    }

    public boolean isIPv6LinkLocal() {
        if (this.b == 2) {
            return false;
        }
        int n2 = Operators.castToInt32(IPAddress.networkToHostOrder_Int16(Operators.castToInt16(this.c[0], 8)), 7) & 0xFFF0;
        return 65152 <= n2 && n2 < 65216;
    }

    public boolean isIPv6SiteLocal() {
        if (this.b == 2) {
            return false;
        }
        int n2 = Operators.castToInt32(IPAddress.networkToHostOrder_Int16(Operators.castToInt16(this.c[0], 8)), 7) & 0xFFF0;
        return 65216 <= n2 && n2 < 65280;
    }

    public boolean isIPv6Multicast() {
        return this.b != 2 && (Operators.castToInt32(Operators.castToUInt16(IPAddress.networkToHostOrder_Int16(Operators.castToInt16(this.c[0], 8)), 7), 8) & 0xFF00) == 65280;
    }

    public long getScopeId() {
        if (this.b != 23) {
            throw new SocketException(10045);
        }
        return this.d;
    }

    public void setScopeId(long l2) {
        if (this.b != 23) {
            throw new SocketException(10045);
        }
        if (l2 < 0L || l2 > Operators.castToUInt32(0xFFFFFFFFL, 10)) {
            throw new ArgumentOutOfRangeException();
        }
        this.d = l2;
    }

    public byte[] getAddressBytes() {
        if (this.b == 23) {
            return this.a(this.c);
        }
        return new byte[]{Operators.castToByte(this.a & Operators.castToInt64(255, 9), 11), Operators.castToByte(this.a >> 8 & Operators.castToInt64(255, 9), 11), Operators.castToByte(this.a >> 16 & Operators.castToInt64(255, 9), 11), Operators.castToByte(this.a >> 24, 11)};
    }

    public int getAddressFamily() {
        return this.b;
    }

    public static boolean isLoopback(IPAddress iPAddress) {
        if (iPAddress.b == 2) {
            return (iPAddress.a & Operators.castToInt64(255, 9)) == 127L;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            if (Operators.castToUInt16(iPAddress.c[i2], 8) == 0) continue;
            return false;
        }
        return IPAddress.networkToHostOrder_Int16(Operators.castToInt16(iPAddress.c[7], 8)) == 1;
    }

    public String toString() {
        if (this.b == 2) {
            return IPAddress.a(this.a);
        }
        int[] nArray = Operators.as(Array.boxing(this.c).deepClone(), int[].class);
        for (int i2 = 0; i2 < Array.boxing(nArray).getLength(); ++i2) {
            nArray[i2] = Operators.castToUInt16(IPAddress.networkToHostOrder_Int16(Operators.castToInt16(nArray[i2], 8)), 7);
        }
        IPv6Address iPv6Address = new IPv6Address(nArray);
        iPv6Address.a(this.getScopeId());
        return iPv6Address.toString();
    }

    static String a(long l2) {
        return StringExtensions.concat(Int64Extensions.toString(l2 & Operators.castToInt64(255, 9)), ".", Int64Extensions.toString(l2 >> 8 & Operators.castToInt64(255, 9)), ".", Int64Extensions.toString(l2 >> 16 & Operators.castToInt64(255, 9)), ".", Int64Extensions.toString(l2 >> 24 & Operators.castToInt64(255, 9)));
    }

    public boolean equals(Object object) {
        IPAddress iPAddress = Operators.as(object, IPAddress.class);
        if (iPAddress != null) {
            if (this.getAddressFamily() != iPAddress.getAddressFamily()) {
                return false;
            }
            if (this.getAddressFamily() == 2) {
                return this.a == iPAddress.a;
            }
            int[] nArray = iPAddress.c;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (Operators.castToUInt16(this.c[i2], 8) == Operators.castToUInt16(nArray[i2], 8)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.b == 2) {
            return Operators.castToInt32(this.a, 11);
        }
        return IPAddress.a((Operators.castToInt32(this.c[0], 8) << 16) + Operators.castToInt32(this.c[1], 8), (Operators.castToInt32(this.c[2], 8) << 16) + Operators.castToInt32(this.c[3], 8), (Operators.castToInt32(this.c[4], 8) << 16) + Operators.castToInt32(this.c[5], 8), (Operators.castToInt32(this.c[6], 8) << 16) + Operators.castToInt32(this.c[7], 8));
    }

    private static int a(int n2, int n3, int n4, int n5) {
        return n2 ^ (n3 << 13 | n3 >> 19) ^ (n4 << 26 | n4 >> 6) ^ (n5 << 7 | n5 >> 25);
    }

    private int[] a(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(sArray), 0, byArray.length);
        return this.a(sArray);
    }

    private byte[] a(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 2];
        short[] sArray = this.b(nArray);
        Buffer.blockCopy(Array.boxing(sArray), 0, Array.boxing(byArray), 0, byArray.length);
        return byArray;
    }

    private short[] b(int[] nArray) {
        short[] sArray = new short[nArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
        return sArray;
    }

    private int[] a(short[] sArray) {
        int[] nArray = new int[sArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = sArray[i2];
        }
        return nArray;
    }
}

