/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Sockets;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.Net.Dns;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.Net.IPEndPoint;
import com.aspose.html.internal.ms.System.Net.Sockets.LingerOption;
import com.aspose.html.internal.ms.System.Net.Sockets.NetworkStream;
import com.aspose.html.internal.ms.System.Net.Sockets.Socket;
import com.aspose.html.internal.ms.System.Net.Sockets.SocketException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class TcpClient
implements IDisposable {
    private NetworkStream a;
    private boolean b;
    private Socket c;
    private boolean d;
    private long e;
    private int f;
    private int g;
    private int h;
    private int i;
    private LingerOption j;
    private boolean k;

    private void a(int n2) {
        this.b = false;
        if (this.c != null) {
            this.c.close();
            this.c = null;
        }
        this.c = new Socket(n2, 1, 6);
    }

    public TcpClient() {
        this.a(2);
        this.c.bind(new IPEndPoint(IPAddress.Any, 0));
    }

    TcpClient(Socket socket) {
        this.c = socket;
    }

    public TcpClient(int n2) {
        if (n2 != 2 && n2 != 23) {
            throw new ArgumentException("Family must be InterNetwork or InterNetworkV6", "family");
        }
        this.a(n2);
        IPAddress iPAddress = IPAddress.Any;
        if (n2 == 23) {
            iPAddress = IPAddress.IPv6Any;
        }
        this.c.bind(new IPEndPoint(iPAddress, 0));
    }

    public TcpClient(IPEndPoint iPEndPoint) {
        this.a(iPEndPoint.getAddressFamily());
        this.c.bind(iPEndPoint);
    }

    public TcpClient(String string, int n2) {
        this.connect(string, n2);
    }

    protected boolean getActive() {
        return this.b;
    }

    protected void setActive(boolean bl2) {
        this.b = bl2;
    }

    public Socket getClient() {
        return this.c;
    }

    public void setClient(Socket socket) {
        this.c = socket;
        this.a = null;
    }

    public int getAvailable() {
        return this.c.getAvailable();
    }

    public boolean getConnected() {
        return this.c.getConnected();
    }

    public boolean getExclusiveAddressUse() {
        return this.c.getExclusiveAddressUse();
    }

    public void setExclusiveAddressUse(boolean bl2) {
        this.c.setExclusiveAddressUse(bl2);
    }

    public LingerOption getLingerState() {
        if ((this.e & Properties.a) != 0L) {
            return this.j;
        }
        return (LingerOption)this.c.getSocketOption(65535, 128);
    }

    public void setLingerState(LingerOption lingerOption) {
        if (!this.c.getConnected()) {
            this.j = lingerOption;
            this.e |= Properties.a;
            return;
        }
        this.c.setSocketOption(65535, 128, lingerOption);
    }

    public boolean getNoDelay() {
        if ((this.e & Properties.b) != 0L) {
            return this.k;
        }
        return (Boolean)this.c.getSocketOption(6, 1);
    }

    public void setNoDelay(boolean bl2) {
        if (!this.c.getConnected()) {
            this.k = bl2;
            this.e |= Properties.b;
            return;
        }
        this.c.setSocketOption(6, 1, bl2 ? 1 : 0);
    }

    public int getReceiveBufferSize() {
        if ((this.e & Properties.c) != 0L) {
            return this.h;
        }
        return (Integer)this.c.getSocketOption(65535, 4098);
    }

    public void setReceiveBufferSize(int n2) {
        if (!this.c.getConnected()) {
            this.h = n2;
            this.e |= Properties.c;
            return;
        }
        this.c.setSocketOption(65535, 4098, n2);
    }

    public int getReceiveTimeout() {
        if ((this.e & Properties.d) != 0L) {
            return this.f;
        }
        return (Integer)this.c.getSocketOption(65535, 4102);
    }

    public void setReceiveTimeout(int n2) {
        if (!this.c.getConnected()) {
            this.f = n2;
            this.e |= Properties.d;
            return;
        }
        this.c.setSocketOption(65535, 4102, n2);
    }

    public int getSendBufferSize() {
        if ((this.e & Properties.e) != 0L) {
            return this.i;
        }
        return (Integer)this.c.getSocketOption(65535, 4097);
    }

    public void setSendBufferSize(int n2) {
        if (!this.c.getConnected()) {
            this.i = n2;
            this.e |= Properties.e;
            return;
        }
        this.c.setSocketOption(65535, 4097, n2);
    }

    public int getSendTimeout() {
        if ((this.e & Properties.f) != 0L) {
            return this.g;
        }
        return (Integer)this.c.getSocketOption(65535, 4101);
    }

    public void setSendTimeout(int n2) {
        if (!this.c.getConnected()) {
            this.g = n2;
            this.e |= Properties.f;
            return;
        }
        this.c.setSocketOption(65535, 4101, n2);
    }

    public void close() {
        this.dispose();
    }

    public void connect(IPEndPoint iPEndPoint) {
        try {
            this.c.connect(iPEndPoint);
            this.b = true;
        }
        finally {
            this.b();
        }
    }

    public void connect(IPAddress iPAddress, int n2) {
        this.connect(new IPEndPoint(iPAddress, n2));
    }

    private void a() {
        long l2 = this.e;
        this.e = 0L;
        if ((l2 & Properties.a) != 0L) {
            this.setLingerState(this.j);
        }
        if ((l2 & Properties.b) != 0L) {
            this.setNoDelay(this.k);
        }
        if ((l2 & Properties.c) != 0L) {
            this.setReceiveBufferSize(this.h);
        }
        if ((l2 & Properties.d) != 0L) {
            this.setReceiveTimeout(this.f);
        }
        if ((l2 & Properties.e) != 0L) {
            this.setSendBufferSize(this.i);
        }
        if ((l2 & Properties.f) != 0L) {
            this.setSendTimeout(this.g);
        }
    }

    public void connect(String string, int n2) {
        IPAddress[] iPAddressArray = Dns.getHostAddresses(string);
        this.connect(iPAddressArray, n2);
    }

    public void connect(IPAddress[] iPAddressArray, int n2) {
        this.b();
        if (iPAddressArray == null) {
            throw new ArgumentNullException("ipAddresses");
        }
        for (int i2 = 0; i2 < Array.boxing(iPAddressArray).getLength(); ++i2) {
            try {
                IPAddress iPAddress = iPAddressArray[i2];
                if (iPAddress.equals(IPAddress.Any) || iPAddress.equals(IPAddress.IPv6Any)) {
                    throw new SocketException(10049);
                }
                this.a(iPAddress.getAddressFamily());
                if (iPAddress.getAddressFamily() == 2) {
                    this.c.bind(new IPEndPoint(IPAddress.Any, 0));
                } else if (iPAddress.getAddressFamily() == 23) {
                    this.c.bind(new IPEndPoint(IPAddress.IPv6Any, 0));
                } else {
                    throw new NotSupportedException("This method is only valid for sockets in the InterNetwork and InterNetworkV6 families");
                }
                this.connect(new IPEndPoint(iPAddress, n2));
                if (this.e == 0L) break;
                this.a();
                break;
            }
            catch (RuntimeException runtimeException) {
                this.a(2);
                if (i2 != Array.boxing(iPAddressArray).getLength() - 1) continue;
                throw runtimeException;
            }
        }
    }

    public void endConnect(IAsyncResult iAsyncResult) {
        this.c.endConnect(iAsyncResult);
    }

    public IAsyncResult beginConnect(IPAddress iPAddress, int n2, AsyncCallback asyncCallback, Object object) {
        return this.c.beginConnect(iPAddress, n2, asyncCallback, object);
    }

    public IAsyncResult beginConnect(IPAddress[] iPAddressArray, int n2, AsyncCallback asyncCallback, Object object) {
        return this.c.beginConnect(iPAddressArray, n2, asyncCallback, object);
    }

    public IAsyncResult beginConnect(String string, int n2, AsyncCallback asyncCallback, Object object) {
        return this.c.beginConnect(string, n2, asyncCallback, object);
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean bl2) {
        if (this.d) {
            return;
        }
        this.d = true;
        if (bl2) {
            NetworkStream networkStream = this.a;
            this.a = null;
            if (networkStream != null) {
                networkStream.close();
                this.b = false;
                networkStream = null;
            } else if (this.c != null) {
                this.c.close();
                this.c = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
        super.finalize();
    }

    public NetworkStream getStream() {
        try {
            if (this.a == null) {
                this.a = new NetworkStream(this.c, true);
            }
            NetworkStream networkStream = this.a;
            return networkStream;
        }
        finally {
            this.b();
        }
    }

    private void b() {
        if (this.d) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }

    private static final class Properties
    extends Enum {
        public static final long a = Operators.castToUInt32(1, 9);
        public static final long b = Operators.castToUInt32(2, 9);
        public static final long c = Operators.castToUInt32(4, 9);
        public static final long d = Operators.castToUInt32(8, 9);
        public static final long e = Operators.castToUInt32(16, 9);
        public static final long f = Operators.castToUInt32(32, 9);

        private Properties() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)Properties.class, Long.class){
                {
                    this.addConstant("LingerState", a);
                    this.addConstant("NoDelay", b);
                    this.addConstant("ReceiveBufferSize", c);
                    this.addConstant("ReceiveTimeout", d);
                    this.addConstant("SendBufferSize", e);
                    this.addConstant("SendTimeout", f);
                }
            });
        }
    }
}

