/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.internal.ms.System.msArray;

public abstract class DSA
extends AsymmetricAlgorithm {
    protected DSA() {
    }

    public static DSA create() {
        return DSA.create("System.Security.Cryptography.DSA");
    }

    public static DSA create(String string) {
        return (DSA)CryptoConfig.createFromName(string);
    }

    public abstract byte[] createSignature(byte[] var1);

    public abstract DSAParameters exportParameters(boolean var1);

    void a(DSAParameters dSAParameters) {
        if (dSAParameters.X != null) {
            msArray.clear(dSAParameters.X, 0, dSAParameters.X.length);
        }
    }

    @Override
    public void fromXmlString(String string) {
        if (string == null) {
            throw new ArgumentNullException("xmlString");
        }
        DSAParameters dSAParameters = new DSAParameters();
        try {
            dSAParameters.P = DSA.a(string, "P");
            dSAParameters.Q = DSA.a(string, "Q");
            dSAParameters.G = DSA.a(string, "G");
            dSAParameters.J = DSA.a(string, "J");
            dSAParameters.Y = DSA.a(string, "Y");
            dSAParameters.X = DSA.a(string, "X");
            dSAParameters.Seed = DSA.a(string, "Seed");
            byte[] byArray = DSA.a(string, "PgenCounter");
            if (byArray != null) {
                byte[] byArray2 = new byte[4];
                Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), 0, byArray.length);
                dSAParameters.Counter = BitConverter.toInt32(byArray2, 0);
            }
            this.importParameters(dSAParameters.Clone());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.a(dSAParameters.Clone());
        }
    }

    public abstract void importParameters(DSAParameters var1);

    @Override
    public String toXmlString(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        DSAParameters dSAParameters = this.exportParameters(bl2).Clone();
        try {
            stringBuilder.append("<DSAKeyValue>");
            stringBuilder.append("<P>");
            stringBuilder.append(Convert.toBase64String(dSAParameters.P));
            stringBuilder.append("</P>");
            stringBuilder.append("<Q>");
            stringBuilder.append(Convert.toBase64String(dSAParameters.Q));
            stringBuilder.append("</Q>");
            stringBuilder.append("<G>");
            stringBuilder.append(Convert.toBase64String(dSAParameters.G));
            stringBuilder.append("</G>");
            stringBuilder.append("<Y>");
            stringBuilder.append(Convert.toBase64String(dSAParameters.Y));
            stringBuilder.append("</Y>");
            if (dSAParameters.J != null) {
                stringBuilder.append("<J>");
                stringBuilder.append(Convert.toBase64String(dSAParameters.J));
                stringBuilder.append("</J>");
            }
            if (dSAParameters.Seed != null) {
                stringBuilder.append("<Seed>");
                stringBuilder.append(Convert.toBase64String(dSAParameters.Seed));
                stringBuilder.append("</Seed>");
                stringBuilder.append("<PgenCounter>");
                if (dSAParameters.Counter != 0) {
                    byte[] byArray = BitConverter.getBytesInt32(dSAParameters.Counter);
                    int n2 = byArray.length;
                    while (byArray[n2 - 1] == 0) {
                        --n2;
                    }
                    stringBuilder.append(Convert.toBase64String(byArray, 0, n2));
                } else {
                    stringBuilder.append("AA==");
                }
                stringBuilder.append("</PgenCounter>");
            }
            if (dSAParameters.X != null) {
                stringBuilder.append("<X>");
                stringBuilder.append(Convert.toBase64String(dSAParameters.X));
                stringBuilder.append("</X>");
            } else if (bl2) {
                throw new ArgumentException("X");
            }
            stringBuilder.append("</DSAKeyValue>");
        }
        catch (RuntimeException runtimeException) {
            this.a(dSAParameters.Clone());
            throw runtimeException;
        }
        return stringBuilder.toString();
    }

    public abstract boolean verifySignature(byte[] var1, byte[] var2);
}

