/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.Pkcs9AttributeObject;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.internal.ms.lang.Operators;

public final class Pkcs9ContentType
extends Pkcs9AttributeObject {
    public static final String oid = "1.2.840.113549.1.9.3";
    public static final String friendlyName = "Content Type";
    private Oid a;
    private byte[] b;

    public Pkcs9ContentType() {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.b = null;
    }

    public Pkcs9ContentType(String string) {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.a = new Oid(string);
        this.setRawData(this.encode());
        this.b = null;
    }

    public Pkcs9ContentType(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("encodedContentType");
        }
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.setRawData(byArray);
        this.decode(byArray);
    }

    public Oid getContentType() {
        if (this.b != null) {
            this.decode(this.b);
        }
        return this.a;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        super.copyFrom(asnEncodedData);
        this.b = asnEncodedData.getRawData();
    }

    public void decode(byte[] byArray) {
        if (byArray == null || Operators.castToInt32(byArray[0], 6) != 6) {
            throw new CryptographicException("Expected an OID.");
        }
        ASN1 aSN1 = new ASN1(byArray);
        this.a = new Oid(ASN1Convert.toOid(aSN1));
        this.b = null;
    }

    public byte[] encode() {
        if (this.a == null) {
            return null;
        }
        return ASN1Convert.fromOid(this.a.getValue()).getBytes();
    }
}

