/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.EventArgs;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricKeyExchangeDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricKeyExchangeFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspKeyContainerInfo;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICspAsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAOAEPKeyExchangeFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.internal.ms.System.bc.BouncyCastleProviderHelper;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.RSAManaged;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.e;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.m;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.s;
import com.aspose.html.internal.ms.core.logger.Log4jLogger;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;

public final class RSACryptoServiceProvider
extends RSA
implements ICspAsymmetricAlgorithm {
    private static final int a = 1;
    private static final int b = 24;
    private m c;
    private boolean d;
    private boolean e;
    private boolean f = true;
    private boolean g;
    private RSAManaged h;
    private static final StringSwitchMap i = new StringSwitchMap("1.3.14.3.2.26", "1.2.840.113549.2.5", "2.16.840.1.101.3.4.2.1", "2.16.840.1.101.3.4.2.2", "2.16.840.1.101.3.4.2.3");
    private PrivateKey j;

    public RSACryptoServiceProvider() {
        this.a(1024, (CspParameters)null);
    }

    public RSACryptoServiceProvider(CspParameters cspParameters) {
        this.a(1024, cspParameters);
    }

    public RSACryptoServiceProvider(int n2) {
        this.a(n2, (CspParameters)null);
    }

    public RSACryptoServiceProvider(int n2, CspParameters cspParameters) {
        this.a(n2, cspParameters);
    }

    private void a(int n2, CspParameters cspParameters) {
        this.LegalKeySizesValue = new KeySizes[1];
        this.LegalKeySizesValue[0] = new KeySizes(384, 16384, 8);
        super.setKeySize(n2);
        this.h = new RSAManaged(this.getKeySize());
        this.h.KeyGenerated.add(new RSAManaged.a(){

            @Override
            public void a(Object object, EventArgs eventArgs) {
                RSACryptoServiceProvider.this.a(object, eventArgs);
            }
        });
        boolean bl2 = this.d = cspParameters != null;
        if (cspParameters == null) {
            cspParameters = new CspParameters(24);
            this.c = new m(cspParameters);
        } else {
            boolean bl3;
            this.c = new m(cspParameters);
            boolean bl4 = this.c.d();
            boolean bl5 = bl3 = (cspParameters.getFlags() & 8) != 0;
            if (bl3 && !bl4) {
                throw new CryptographicException("Keyset does not exist");
            }
            if (this.c.b() != null) {
                this.e = true;
                this.fromXmlString(this.c.b());
            }
        }
    }

    @Override
    public String getKeyExchangeAlgorithm() {
        return "RSA-PKCS1-KeyEx";
    }

    @Override
    public int getKeySize() {
        if (this.h == null) {
            return this.KeySizeValue;
        }
        return this.h.getKeySize();
    }

    public boolean getPersistKeyInCsp() {
        return this.d;
    }

    public void setPersistKeyInCsp(boolean bl2) {
        this.d = bl2;
        if (this.d) {
            this.a(this.h, null);
        }
    }

    public boolean getPublicOnly() {
        return this.h.getPublicOnly() && this.j == null;
    }

    @Override
    public String getSignatureAlgorithm() {
        return "https://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd#rsa-sha1";
    }

    public byte[] decrypt(byte[] byArray, boolean bl2) {
        AsymmetricKeyExchangeDeformatter asymmetricKeyExchangeDeformatter = null;
        asymmetricKeyExchangeDeformatter = bl2 ? new RSAOAEPKeyExchangeDeformatter(this.h) : new RSAPKCS1KeyExchangeDeformatter(this.h);
        return asymmetricKeyExchangeDeformatter.decryptKeyExchange(byArray);
    }

    @Override
    public byte[] decryptValue(byte[] byArray) {
        if (!this.h.isCrtPossible()) {
            throw new CryptographicException("Incomplete private key - missing CRT.");
        }
        return this.h.decryptValue(byArray);
    }

    public byte[] encrypt(byte[] byArray, boolean bl2) {
        AsymmetricKeyExchangeFormatter asymmetricKeyExchangeFormatter = null;
        asymmetricKeyExchangeFormatter = bl2 ? new RSAOAEPKeyExchangeFormatter(this.h) : new RSAPKCS1KeyExchangeFormatter(this.h);
        return asymmetricKeyExchangeFormatter.createKeyExchange(byArray);
    }

    @Override
    public byte[] encryptValue(byte[] byArray) {
        return this.h.encryptValue(byArray);
    }

    @Override
    public RSAParameters exportParameters(boolean bl2) {
        if (bl2 && !this.f) {
            throw new CryptographicException("cannot export private key");
        }
        return this.h.exportParameters(bl2);
    }

    @Override
    public void importParameters(RSAParameters rSAParameters) {
        this.h.importParameters(rSAParameters.Clone());
    }

    private HashAlgorithm a(Object object) {
        if (object == null) {
            throw new ArgumentNullException("halg");
        }
        HashAlgorithm hashAlgorithm = null;
        if (object instanceof String) {
            hashAlgorithm = HashAlgorithm.create((String)object);
        } else if (object instanceof HashAlgorithm) {
            hashAlgorithm = (HashAlgorithm)object;
        } else if (object instanceof Class) {
            try {
                hashAlgorithm = (HashAlgorithm)((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            throw new ArgumentException("halg");
        }
        return hashAlgorithm;
    }

    public byte[] signData(byte[] byArray, Object object) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        return this.signData(byArray, 0, byArray.length, object);
    }

    public byte[] signData(Stream stream, Object object) {
        HashAlgorithm hashAlgorithm = this.a(object);
        byte[] byArray = hashAlgorithm.computeHash(stream);
        return s.b(this, hashAlgorithm, byArray);
    }

    public byte[] signData(byte[] byArray, int n2, int n3, Object object) {
        HashAlgorithm hashAlgorithm = this.a(object);
        byte[] byArray2 = hashAlgorithm.computeHash(byArray, n2, n3);
        return s.b(this, hashAlgorithm, byArray2);
    }

    private String a(String string) {
        switch (i.of(string)) {
            case 0: {
                return "SHA1";
            }
            case 1: {
                return "MD5";
            }
            case 2: {
                return "SHA256";
            }
            case 3: {
                return "SHA384";
            }
            case 4: {
                return "SHA512";
            }
        }
        throw new CryptographicException(string + " is an unsupported hash algorithm for RSA signing");
    }

    public byte[] signHash(byte[] byArray, String string) {
        if (byArray == null) {
            throw new ArgumentNullException("rgbHash");
        }
        String string2 = string == null ? "SHA1" : this.a(string);
        HashAlgorithm hashAlgorithm = HashAlgorithm.create(string2);
        return s.b(this, hashAlgorithm, byArray);
    }

    public boolean verifyData(byte[] byArray, Object object, byte[] byArray2) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (byArray2 == null) {
            throw new ArgumentNullException("signature");
        }
        HashAlgorithm hashAlgorithm = this.a(object);
        byte[] byArray3 = hashAlgorithm.computeHash(byArray);
        return s.a((RSA)this, hashAlgorithm, byArray3, byArray2);
    }

    public boolean verifyHash(byte[] byArray, String string, byte[] byArray2) {
        if (byArray == null) {
            throw new ArgumentNullException("rgbHash");
        }
        if (byArray2 == null) {
            throw new ArgumentNullException("rgbSignature");
        }
        String string2 = string == null ? "SHA1" : this.a(string);
        HashAlgorithm hashAlgorithm = HashAlgorithm.create(string2);
        return s.a((RSA)this, hashAlgorithm, byArray, byArray2);
    }

    @Override
    protected void dispose(boolean bl2) {
        if (!this.g) {
            if (this.e && !this.d) {
                this.c.f();
            }
            if (this.h != null) {
                this.h.clear();
            }
            this.g = true;
        }
    }

    private void a(Object object, EventArgs eventArgs) {
        if (this.d && !this.e) {
            this.c.a(this.toXmlString(!this.h.getPublicOnly()));
            this.c.e();
            this.e = true;
        }
    }

    @Override
    public CspKeyContainerInfo getCspKeyContainerInfo() {
        return new CspKeyContainerInfo(this.c.c());
    }

    @Override
    public byte[] exportCspBlob(boolean bl2) {
        byte[] byArray = null;
        byArray = bl2 ? com.aspose.html.internal.ms.core.System.Security.Cryptography.e.a(this) : com.aspose.html.internal.ms.core.System.Security.Cryptography.e.b(this);
        byArray[5] = -92;
        return byArray;
    }

    @Override
    public void importCspBlob(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("keyBlob");
        }
        RSA rSA = com.aspose.html.internal.ms.core.System.Security.Cryptography.e.e(byArray);
        if (rSA instanceof RSACryptoServiceProvider) {
            RSAParameters rSAParameters = rSA.exportParameters(!((RSACryptoServiceProvider)rSA).getPublicOnly()).Clone();
            this.importParameters(rSAParameters.Clone());
        } else {
            try {
                RSAParameters rSAParameters = rSA.exportParameters(true).Clone();
                this.importParameters(rSAParameters.Clone());
            }
            catch (Exception exception) {
                RSAParameters rSAParameters = rSA.exportParameters(false).Clone();
                this.importParameters(rSAParameters.Clone());
            }
        }
    }

    public void setJavaPrivateKey(PrivateKey privateKey) {
        this.d = true;
        this.j = privateKey;
    }

    protected boolean hasJavaPrivateKey() {
        return this.j != null;
    }

    protected byte[] signDataSHA1withRSA(byte[] byArray) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(this.j);
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            Log4jLogger.debug(exception.toString(), exception);
            return null;
        }
    }

    protected byte[] signDataNoneWithRSA(byte[] byArray) {
        try {
            Provider provider = BouncyCastleProviderHelper.getBCProvider();
            Signature signature = Signature.getInstance("NONEwithRSA", provider);
            signature.initSign(this.j);
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            Log4jLogger.debug(exception.toString(), exception);
            return null;
        }
    }
}

