/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.h;

public final class X500DistinguishedName
extends AsnEncodedData {
    private static final int a = 29169;
    private String b;

    public X500DistinguishedName(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("encodedDistinguishedName");
        }
        this.setRawData(asnEncodedData.getRawData());
        if (this.getRawData().length > 0) {
            this.a();
        } else {
            this.b = StringExtensions.Empty;
        }
    }

    public X500DistinguishedName(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("encodedDistinguishedName");
        }
        this.setOid(new Oid());
        this.setRawData(byArray);
        if (byArray.length > 0) {
            this.a();
        } else {
            this.b = StringExtensions.Empty;
        }
    }

    public X500DistinguishedName(String string) {
        this(string, 1);
    }

    public X500DistinguishedName(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("distinguishedName");
        }
        if (n2 != 0 && (n2 & 0x71F1) == 0) {
            throw new ArgumentException("flag");
        }
        this.setOid(new Oid());
        if (string.length() == 0) {
            this.setRawData(new byte[]{48, 0});
            this.a();
        } else {
            ASN1 aSN1 = h.a(string);
            if ((n2 & 1) != 0) {
                ASN1 aSN12 = new ASN1(48);
                for (int i2 = aSN1.getCount() - 1; i2 >= 0; --i2) {
                    aSN12.add(aSN1.get_Item(i2));
                }
                aSN1 = aSN12;
            }
            this.setRawData(aSN1.getBytes());
            this.b = n2 == 0 ? string : this.decode(n2);
        }
    }

    public X500DistinguishedName(X500DistinguishedName x500DistinguishedName) {
        if (x500DistinguishedName == null) {
            throw new ArgumentNullException("distinguishedName");
        }
        this.setOid(new Oid());
        this.setRawData(x500DistinguishedName.getRawData());
        this.b = x500DistinguishedName.b;
    }

    public String getName() {
        return this.b;
    }

    public String decode(int n2) {
        if (n2 != 0 && (n2 & 0x71F1) == 0) {
            throw new ArgumentException("flag");
        }
        if (this.getRawData().length == 0) {
            return StringExtensions.Empty;
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 0x40) == 0;
        String string = X500DistinguishedName.a(n2);
        ASN1 aSN1 = new ASN1(this.getRawData());
        return h.a(aSN1, bl2, string, bl3);
    }

    @Override
    public String format(boolean bl2) {
        if (bl2) {
            String string = this.decode(256);
            if (string.length() > 0) {
                return StringExtensions.concat(string, Environment.get_NewLine());
            }
            return string;
        }
        return this.decode(128);
    }

    private static String a(int n2) {
        if ((n2 & 0x10) != 0) {
            return "; ";
        }
        if ((n2 & 0x80) != 0) {
            return ", ";
        }
        if ((n2 & 0x100) != 0) {
            return Environment.get_NewLine();
        }
        return ", ";
    }

    private void a() {
        if (this.getRawData() == null || this.getRawData().length < 3) {
            this.b = StringExtensions.Empty;
            return;
        }
        ASN1 aSN1 = new ASN1(this.getRawData());
        this.b = h.a(aSN1, true, ", ", true);
    }

    private static String a(String string) {
        int n2;
        msStringBuilder msStringBuilder2 = new msStringBuilder(StringExtensions.substring(string, 0, n2));
        for (n2 = StringExtensions.indexOf(string, '=') + 1; n2 < string.length() && Char.isWhiteSpace(string, n2); ++n2) {
        }
        string = StringExtensions.trimEnd(string, new char[0]);
        boolean bl2 = false;
        while (n2 < string.length()) {
            if (!bl2 || !(bl2 = Char.isWhiteSpace(string, n2))) {
                if (Char.isWhiteSpace(string, n2)) {
                    bl2 = true;
                }
                msStringBuilder2.append(Char.toUpperInvariant(string.charAt(n2)));
            }
            ++n2;
        }
        return msStringBuilder2.toString();
    }

    public static boolean areEqual(X500DistinguishedName x500DistinguishedName, X500DistinguishedName x500DistinguishedName2) {
        String[] stringArray;
        if (x500DistinguishedName == null) {
            return x500DistinguishedName2 == null;
        }
        if (x500DistinguishedName2 == null) {
            return false;
        }
        int n2 = 320;
        String[] stringArray2 = new String[]{Environment.get_NewLine()};
        String[] stringArray3 = StringExtensions.split(x500DistinguishedName.decode(n2), stringArray2, 1);
        if (stringArray3.length != (stringArray = StringExtensions.split(x500DistinguishedName2.decode(n2), stringArray2, 1)).length) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray3.length; ++i2) {
            if (StringExtensions.equals(X500DistinguishedName.a(stringArray3[i2]), X500DistinguishedName.a(stringArray[i2]))) continue;
            return false;
        }
        return true;
    }
}

