/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Text.Decoder;
import com.aspose.html.internal.ms.System.Text.DecoderFallback;
import com.aspose.html.internal.ms.System.Text.DecoderFallbackBuffer;
import com.aspose.html.internal.ms.System.Text.Encoder;
import com.aspose.html.internal.ms.System.Text.EncoderFallback;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.mscorlib.f.a;
import com.aspose.html.internal.ms.core.mscorlib.f.g;

public class UTF7Encoding
extends Encoding {
    static final int a = 65000;
    private boolean n;

    public UTF7Encoding() {
        this(false);
    }

    public UTF7Encoding(boolean bl2) {
        super(65000);
        this.n = bl2;
        this.body_name = "utf-7";
        this.encoding_name = "Unicode (UTF-7)";
        this.header_name = "utf-7";
        this.is_mail_news_display = true;
        this.is_mail_news_save = true;
        this.web_name = "utf-7";
        this.windows_code_page = 1200;
        this.setDecoderFallback(new UTF7DecoderFallback());
    }

    @Override
    public int getByteCount(char[] cArray, int n2, int n3) {
        g g2 = new g(this.n, this.getEncoderFallback());
        return g2.a(cArray, n2, n3);
    }

    @Override
    public int getBytes(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        g g2 = new g(this.n, this.getEncoderFallback());
        return g2.a(cArray, n2, n3, byArray, n4);
    }

    @Override
    public int getCharCount(byte[] byArray, int n2, int n3) {
        com.aspose.html.internal.ms.core.mscorlib.e.g g2 = new com.aspose.html.internal.ms.core.mscorlib.e.g(this.getDecoderFallback());
        return g2.a(byArray, n2, n3);
    }

    @Override
    public int getChars(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        com.aspose.html.internal.ms.core.mscorlib.e.g g2 = new com.aspose.html.internal.ms.core.mscorlib.e.g(this.getDecoderFallback());
        return g2.a(byArray, n2, n3, cArray, n4);
    }

    @Override
    public Encoder getEncoder() {
        return new UTF7Encoder(this.n, this.getEncoderFallback());
    }

    @Override
    public Decoder getDecoder() {
        return new UTF7Decoder(this.getDecoderFallback());
    }

    @Override
    public int getMaxByteCount(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("charCount", "Non-negative number required.");
        }
        return n2 * 3 + 2;
    }

    @Override
    public int getMaxCharCount(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("byteCount", "Non-negative number required.");
        }
        return n2 == 0 ? 1 : n2;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        return this.n ? -n2 : n2;
    }

    @Override
    public boolean equals(Object object) {
        UTF7Encoding uTF7Encoding = object instanceof UTF7Encoding ? (UTF7Encoding)object : null;
        return uTF7Encoding != null && this.n == uTF7Encoding.n && this.getEncoderFallback().equals(uTF7Encoding.getEncoderFallback()) && this.getDecoderFallback().equals(uTF7Encoding.getDecoderFallback());
    }

    private static class UTF7DecoderFallbackBuffer
    extends DecoderFallbackBuffer {
        private char a = '\u0000';
        private int b = -1;
        private int c;

        private UTF7DecoderFallbackBuffer() {
        }

        @Override
        public void reset() {
            this.b = -1;
        }

        @Override
        public int getRemaining() {
            return this.b > 0 ? this.b : 0;
        }

        @Override
        public boolean fallback(byte[] byArray, int n2) {
            if (byArray == null) {
                throw new ArgumentNullException("bytesUnknown");
            }
            if (n2 < 0 || byArray.length < n2) {
                throw new ArgumentOutOfRangeException("index");
            }
            if (this.b >= 0) {
                throw new ArgumentException("[UTF7DecoderFallbackBuffer.Fallback] Can't have recursive fallbacks");
            }
            if (byArray.length != 1) {
                throw new ArgumentException("[UTF7DecoderFallbackBuffer.Fallback] Only possible fallback case should be 1 unknown byte");
            }
            this.a = (char)(byArray[0] & 0xFF);
            if (this.a == '\u0000') {
                return false;
            }
            this.b = 1;
            this.c = 1;
            return true;
        }

        @Override
        public char getNextChar() {
            if (this.b-- > 0) {
                return this.a;
            }
            return '\u0000';
        }

        @Override
        public boolean movePrevious() {
            if (this.b >= 0) {
                ++this.b;
            }
            return this.b >= 0 && this.b <= this.c;
        }
    }

    private static class UTF7DecoderFallback
    extends DecoderFallback {
        private UTF7DecoderFallback() {
        }

        @Override
        public int getMaxCharCount() {
            return 1;
        }

        @Override
        public DecoderFallbackBuffer createFallbackBuffer() {
            return new UTF7DecoderFallbackBuffer();
        }
    }

    private static class UTF7Decoder
    extends com.aspose.html.internal.ms.core.mscorlib.e.a {
        private UTF7Decoder(DecoderFallback decoderFallback) {
            super(new com.aspose.html.internal.ms.core.mscorlib.e.g(decoderFallback));
        }
    }

    private static class UTF7Encoder
    extends a {
        private UTF7Encoder(boolean bl2, EncoderFallback encoderFallback) {
            super(new g(bl2, encoderFallback));
        }
    }
}

