/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.FunctionArguments;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathFunction;
import com.aspose.html.internal.ms.System.msMath;

class XPathFunctionSubstring
extends XPathFunction {
    private Expression a;
    private Expression b;
    private Expression c;

    public XPathFunctionSubstring(FunctionArguments functionArguments) {
        super(functionArguments);
        if (functionArguments == null || functionArguments.getTail() == null || functionArguments.getTail().getTail() != null && functionArguments.getTail().getTail().getTail() != null) {
            throw new XPathException("substring takes 2 or 3 args");
        }
        this.a = functionArguments.getArg();
        this.b = functionArguments.getTail().getArg();
        if (functionArguments.getTail().getTail() != null) {
            this.c = functionArguments.getTail().getTail().getArg();
        }
    }

    @Override
    public int getReturnType() {
        return 1;
    }

    @Override
    boolean getPeer() {
        return this.a.getPeer() && this.b.getPeer() && (this.c == null || this.c.getPeer());
    }

    @Override
    public Object evaluate(BaseIterator baseIterator) {
        double d2;
        String string = this.a.evaluateString(baseIterator);
        double d3 = msMath.round(this.b.evaluateNumber(baseIterator)) - 1.0;
        if (Double.isNaN(d3) || DoubleExtensions.isNegativeInfinity(d3) || d3 >= (double)string.length()) {
            return "";
        }
        if (this.c == null) {
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            return StringExtensions.substring(string, (int)d3);
        }
        double d4 = msMath.round(this.c.evaluateNumber(baseIterator));
        if (Double.isNaN(d4)) {
            return "";
        }
        if (d3 < 0.0 || d4 < 0.0) {
            if ((d4 = d3 + d4) <= 0.0) {
                return "";
            }
            d3 = 0.0;
        }
        if (d4 > (d2 = (double)string.length() - d3)) {
            d4 = d2;
        }
        return StringExtensions.substring(string, (int)d3, (int)d4);
    }

    public String toString() {
        return StringExtensions.concat("substring(", this.a.toString(), ",", this.b.toString(), ",", this.c.toString(), ")");
    }
}

