/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotated;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotation;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaReader;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUtil;

public class XmlSchemaNotation
extends XmlSchemaAnnotated {
    private String a;
    private String b;
    private String c;
    private XmlQualifiedName d;
    private static final String e = "notation";

    public String getName() {
        return this.a;
    }

    public void setName(String string) {
        this.a = string;
    }

    public String getPublic() {
        return this.b;
    }

    public void setPublic(String string) {
        this.b = string;
    }

    public String getSystem() {
        return this.c;
    }

    public void setSystem(String string) {
        this.c = string;
    }

    XmlQualifiedName getQualifiedName() {
        return this.d;
    }

    @Override
    int compile(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (Guid.op_Equality(this.getCompilationId(), xmlSchema.getCompilationId())) {
            return 0;
        }
        if (this.getName() == null) {
            this.error(validationEventHandler, "Required attribute name must be present");
        } else if (!XmlSchemaUtil.checkNCName(this.a)) {
            this.error(validationEventHandler, "attribute name must be NCName");
        } else {
            this.d = new XmlQualifiedName(this.getName(), this.getAncestorSchema().getTargetNamespace());
        }
        if (this.getPublic() == null) {
            this.error(validationEventHandler, "public must be present");
        } else if (!XmlSchemaUtil.checkAnyUri(this.getPublic())) {
            this.error(validationEventHandler, "public must be anyURI");
        }
        if (this.c != null && !XmlSchemaUtil.checkAnyUri(this.c)) {
            this.error(validationEventHandler, "system must be present and of Type anyURI");
        }
        XmlSchemaUtil.compileID(this.getId(), this, xmlSchema.getIDCollection(), validationEventHandler);
        return this.errorCount;
    }

    @Override
    int validate(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        return this.errorCount;
    }

    static XmlSchemaNotation read(XmlSchemaReader xmlSchemaReader, ValidationEventHandler validationEventHandler) {
        XmlSchemaNotation xmlSchemaNotation = new XmlSchemaNotation();
        xmlSchemaReader.moveToElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI()) || !e.equals(xmlSchemaReader.getLocalName())) {
            XmlSchemaNotation.error(validationEventHandler, StringExtensions.concat("Should not happen :1: XmlSchemaInclude.Read, name=", xmlSchemaReader.getName()), null);
            xmlSchemaReader.skip();
            return null;
        }
        xmlSchemaNotation.setLineNumber(xmlSchemaReader.getLineNumber());
        xmlSchemaNotation.setLinePosition(xmlSchemaReader.getLinePosition());
        xmlSchemaNotation.setSourceUri(xmlSchemaReader.getBaseURI());
        while (xmlSchemaReader.moveToNextAttribute()) {
            if ("id".equals(xmlSchemaReader.getName())) {
                xmlSchemaNotation.setId(xmlSchemaReader.getValue());
                continue;
            }
            if ("name".equals(xmlSchemaReader.getName())) {
                xmlSchemaNotation.a = xmlSchemaReader.getValue();
                continue;
            }
            if ("public".equals(xmlSchemaReader.getName())) {
                xmlSchemaNotation.b = xmlSchemaReader.getValue();
                continue;
            }
            if ("system".equals(xmlSchemaReader.getName())) {
                xmlSchemaNotation.c = xmlSchemaReader.getValue();
                continue;
            }
            if ("".equals(xmlSchemaReader.getNamespaceURI()) && !"xmlns".equals(xmlSchemaReader.getName()) || "http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI())) {
                XmlSchemaNotation.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getName(), " is not a valid attribute for notation"), null);
                continue;
            }
            XmlSchemaUtil.readUnhandledAttribute(xmlSchemaReader, xmlSchemaNotation);
        }
        xmlSchemaReader.moveToElement();
        if (xmlSchemaReader.isEmptyElement()) {
            return xmlSchemaNotation;
        }
        int n2 = 1;
        while (xmlSchemaReader.readNextElement()) {
            if (xmlSchemaReader.getNodeType() == 15) {
                if (e.equals(xmlSchemaReader.getLocalName())) break;
                XmlSchemaNotation.error(validationEventHandler, StringExtensions.concat("Should not happen :2: XmlSchemaNotation.Read, name=", xmlSchemaReader.getName()), null);
                break;
            }
            if (n2 <= 1 && "annotation".equals(xmlSchemaReader.getLocalName())) {
                n2 = 2;
                XmlSchemaAnnotation xmlSchemaAnnotation = XmlSchemaAnnotation.read(xmlSchemaReader, validationEventHandler);
                if (xmlSchemaAnnotation == null) continue;
                xmlSchemaNotation.setAnnotation(xmlSchemaAnnotation);
                continue;
            }
            xmlSchemaReader.raiseInvalidElementError();
        }
        return xmlSchemaNotation;
    }
}

