/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.Drawing2D;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.GraphicsPath;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.PathData;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.ExtendedGeneralPath;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class GraphicsPathConverter {
    public static ExtendedGeneralPath nativeToExtended(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof GeneralPath) {
            return new ExtendedGeneralPath((GeneralPath)shape);
        }
        if (shape.getClass().getPackage().getName().startsWith("java.awt.geom")) {
            return (ExtendedGeneralPath)new ExtendedGeneralPath(shape).deepClone();
        }
        if (shape instanceof ExtendedGeneralPath) {
            return (ExtendedGeneralPath)shape;
        }
        if (shape instanceof GraphicsPath) {
            return ((GraphicsPath)shape).getNativeObject();
        }
        throw new ArgumentException("Unknown graphics path: " + shape.getClass().getCanonicalName());
    }

    public static GeneralPath extendedToNative(ExtendedGeneralPath extendedGeneralPath) {
        return extendedGeneralPath.getNativeObject();
    }

    public static GraphicsPath nativeToGraphics(Shape shape) {
        ExtendedGeneralPath extendedGeneralPath = GraphicsPathConverter.nativeToExtended(shape);
        PathData pathData = new PathData(extendedGeneralPath);
        return new GraphicsPath(pathData.getPoints(), pathData.getTypes());
    }

    public static Shape tryExtendedToNative(Shape shape) {
        if (shape instanceof ExtendedGeneralPath) {
            return GraphicsPathConverter.extendedToNative((ExtendedGeneralPath)shape);
        }
        if (shape instanceof GeneralPath || shape.getClass().getPackage().getName().startsWith("java.awt.geom")) {
            return shape;
        }
        if (shape instanceof GraphicsPath) {
            return GraphicsPathConverter.extendedToNative(((GraphicsPath)shape).getNativeObject());
        }
        return shape;
    }
}

