/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageLoadException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.DRISegment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.DataBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.FastCopy;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegBufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegComponentInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDecoderState;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegMCU;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRangeLimitTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegScan;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.QTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegUtils;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.dct.IDCT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.HuffmanDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.JpegEntropyDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.ProgressiveHuffmanDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.samplers.UpSampler;

public class JpegDecodingController {
    private static JpegRangeLimitTable a;
    private int b;
    private JpegDecoderState c;
    private DataBlock[][][] d;
    private JpegEntropyDecoder e;
    private IDCT f;
    private long g;
    private RawDataSettings h;
    private UpSampler i;

    public int getColorFormat() {
        return this.b;
    }

    public void setColorFormat(int n2) {
        this.b = n2;
    }

    public JpegDecoderState getDecoderState() {
        return this.c;
    }

    public void setDecoderState(JpegDecoderState jpegDecoderState) {
        this.c = jpegDecoderState;
    }

    public JpegEntropyDecoder getEntropyDecoder() {
        return this.e;
    }

    public void setEntropyDecoder(JpegEntropyDecoder jpegEntropyDecoder) {
        this.e = jpegEntropyDecoder;
    }

    public long getInitialDataPosition() {
        return this.g;
    }

    public void setInitialDataPosition(long l2) {
        this.g = l2;
    }

    public RawDataSettings getRawDataSettings() {
        return this.h;
    }

    public void setRawDataSettings(RawDataSettings rawDataSettings) {
        this.h = rawDataSettings;
    }

    public UpSampler getUpsampler() {
        return this.i;
    }

    public void setUpsampler(UpSampler upSampler) {
        this.i = upSampler;
    }

    public static JpegRangeLimitTable prepareRangeLimitTable() {
        JpegRangeLimitTable jpegRangeLimitTable = a;
        if (jpegRangeLimitTable == null) {
            jpegRangeLimitTable = a = JpegDecodingController.a();
        }
        return jpegRangeLimitTable;
    }

    public static EntropyTable[] readEntropyTables(JpegStream jpegStream) {
        JpegRawDataReader jpegRawDataReader = new JpegRawDataReader(jpegStream);
        List<EntropyTable> list = new List<EntropyTable>();
        while (jpegRawDataReader.makeByteAvailable()) {
            int n2 = 0;
            int[] nArray = new int[]{0};
            jpegRawDataReader.getTwoBytes(nArray);
            n2 = nArray[0];
            byte by2 = (byte)n2;
            if (by2 == -39) break;
            if (by2 == -40) continue;
            if (by2 == -60) {
                list.addRange(Array.toGenericList(EntropyTable.read(jpegRawDataReader)));
                continue;
            }
            int n3 = 0;
            int[] nArray2 = new int[]{0};
            jpegRawDataReader.getTwoBytes(nArray2);
            n3 = nArray2[0];
            jpegRawDataReader.skipInputData(n3 - 2);
        }
        return list.toArray(new EntropyTable[0]);
    }

    public static QTable[] readQuantTables(JpegStream jpegStream) {
        JpegRawDataReader jpegRawDataReader = new JpegRawDataReader(jpegStream);
        List<QTable> list = new List<QTable>();
        while (jpegRawDataReader.makeByteAvailable()) {
            int n2 = 0;
            int[] nArray = new int[]{0};
            jpegRawDataReader.getTwoBytes(nArray);
            n2 = nArray[0];
            byte by2 = (byte)n2;
            if (by2 == -39) break;
            if (by2 == -40) continue;
            if (by2 == -37) {
                list.addRange(Array.toGenericList(QTable.read(jpegRawDataReader)));
                continue;
            }
            int n3 = 0;
            int[] nArray2 = new int[]{0};
            jpegRawDataReader.getTwoBytes(nArray2);
            n3 = nArray2[0];
            jpegRawDataReader.skipInputData(n3 - 2);
        }
        return list.toArray(new QTable[0]);
    }

    public void decode(JpegRawDataReader jpegRawDataReader, Rectangle rectangle) {
        boolean bl2 = false;
        if (this.c.getJpegLoadOptions() != null) {
            if (this.c.getJpegLoadOptions().getEntropyTables() != null) {
                for (EntropyTable object : this.c.getJpegLoadOptions().getEntropyTables()) {
                    this.c.getEntropyTables().set_Item(object.Ti & 0xFF, object);
                }
            }
            if (this.c.getJpegLoadOptions().getQuantTables() != null) {
                for (QTable qTable : this.c.getJpegLoadOptions().getQuantTables()) {
                    this.c.getQTables().set_Item(qTable.Qi & 0xFF, qTable);
                }
            }
        }
        boolean bl3 = false;
        block13: while (!bl3) {
            if (bl2) {
                this.startPass();
                if (this.c.getJpegScan().Components.length == 1) {
                    this.c();
                } else {
                    this.b();
                }
                bl2 = false;
                continue;
            }
            int n2 = this.c.getRawDataReader().consumeMarker();
            switch (n2) {
                case -40: {
                    break;
                }
                case -39: {
                    bl3 = true;
                    break;
                }
                case -35: {
                    DRISegment dRISegment = DRISegment.read(this.c.getRawDataReader());
                    this.c.setRestartsNumber(dRISegment.getNumberOfRestarts() & 0xFFFF);
                    break;
                }
                case -64: 
                case -63: {
                    this.c.setJpegFrame(JpegFrame.read(this.c.getRawDataReader(), (byte)-64));
                    this.c.setProgressive(false);
                    this.initialize(this.c);
                    break;
                }
                case -62: {
                    this.c.setJpegFrame(JpegFrame.read(this.c.getRawDataReader(), (byte)-62));
                    this.c.setProgressive(true);
                    this.initialize(this.c);
                    break;
                }
                case -38: {
                    this.c.setJpegScan(JpegScan.read(this.c.getRawDataReader(), this.c.getJpegFrame()));
                    this.getDecoderState().setMultipleScans(this.getDecoderState().getJpegScan().Components.length < this.getDecoderState().getJpegFrame().getComponentInfos().length || this.getDecoderState().isProgressive());
                    this.perScanSetup();
                    bl2 = true;
                    break;
                }
                case -36: {
                    throw new NotSupportedException("This feature is not supported yet.");
                }
                case -60: {
                    EntropyTable[] entropyTableArray = EntropyTable.read(this.c.getRawDataReader());
                    for (EntropyTable entropyTable : entropyTableArray) {
                        this.c.getEntropyTables().set_Item(entropyTable.Ti & 0xFF, entropyTable);
                    }
                    continue block13;
                }
                case -37: {
                    Object[] objectArray = QTable.read(this.c.getRawDataReader());
                    for (QTable qTable : objectArray) {
                        this.c.getQTables().set_Item(qTable.Qi & 0xFF, qTable);
                    }
                    continue block13;
                }
                default: {
                    int n3 = 0;
                    int[] nArray = new int[]{0};
                    this.getDecoderState().getRawDataReader().getTwoBytes(nArray);
                    n3 = nArray[0];
                    this.getDecoderState().getRawDataReader().skipInputData(n3 - 2);
                    break;
                }
            }
        }
    }

    public void initialize(JpegDecoderState jpegDecoderState) {
        this.setDecoderState(jpegDecoderState);
        if (this.getDecoderState().getJpegFrame().isProgressive()) {
            this.setEntropyDecoder(new ProgressiveHuffmanDecoder(this.getDecoderState()));
        } else {
            this.setEntropyDecoder(new HuffmanDecoder(this.getDecoderState()));
        }
        for (JpegComponentInfo jpegComponentInfo : this.getDecoderState().getJpegFrame().getComponentInfos()) {
            this.getDecoderState().getJpegFrame().setHmax(msMath.max(jpegComponentInfo.getH() & 0xFF, this.getDecoderState().getJpegFrame().getHmax()));
            this.getDecoderState().getJpegFrame().setVmax(msMath.max(jpegComponentInfo.getV() & 0xFF, this.getDecoderState().getJpegFrame().getVmax()));
        }
        for (JpegComponentInfo jpegComponentInfo : this.c.getJpegFrame().getComponentInfos()) {
            jpegComponentInfo.WidthInBlocks = JpegUtils.divRoundUp((this.getDecoderState().getJpegFrame().getX() & 0xFFFF) * (jpegComponentInfo.getH() & 0xFF), this.getDecoderState().getJpegFrame().getHmax() * JpegConstants.BlockSize);
            jpegComponentInfo.setHeightInBlocks(JpegUtils.divRoundUp((this.getDecoderState().getJpegFrame().getY() & 0xFFFF) * (jpegComponentInfo.getV() & 0xFF), this.getDecoderState().getJpegFrame().getVmax() * JpegConstants.BlockSize));
            int n2 = jpegComponentInfo.WidthInBlocks % (jpegComponentInfo.getV() & 0xFF);
            if (n2 == 0) {
                n2 = jpegComponentInfo.getV() & 0xFF;
            }
            jpegComponentInfo.setLastColWidth(n2);
            n2 = jpegComponentInfo.getHeightInBlocks() % (jpegComponentInfo.getV() & 0xFF);
            if (n2 == 0) {
                n2 = jpegComponentInfo.getV() & 0xFF;
            }
            jpegComponentInfo.setLastRowHeight(n2);
        }
        this.c.setRangeLimitTable(JpegDecodingController.prepareRangeLimitTable());
        this.d = new DataBlock[JpegConstants.MaxComponents][][];
        this.setUpsampler(new UpSampler(this.getDecoderState().getJpegFrame().getComponentInfos(), this.getDecoderState().getJpegFrame().getHmax(), this.c.getJpegFrame().getVmax()));
    }

    public void perScanSetup() {
        if (this.getDecoderState().getJpegScan().Components.length == 1) {
            int n2 = this.getDecoderState().getJpegScan().Components[0];
            int n3 = this.a(n2);
            JpegComponentInfo jpegComponentInfo = this.getDecoderState().getJpegFrame().getComponentInfos()[n3];
            jpegComponentInfo.setMCUWidth(1);
            jpegComponentInfo.setMCUHeight(1);
            jpegComponentInfo.setMCUBlocks(1);
            this.c.setMcusPerRow(jpegComponentInfo.WidthInBlocks);
            this.getDecoderState().getJpegScan().setMCUMembership(new int[]{n3});
            this.getDecoderState().getJpegScan().setBlocksInMcu(1);
        } else {
            this.c.setMcusPerRow(JpegUtils.divRoundUp(this.c.getJpegFrame().getX() & 0xFFFF, this.c.getJpegFrame().getHmax() * JpegConstants.BlockSize));
            this.c.getJpegScan().setBlocksInMcu(0);
            for (int i2 = 0; i2 < this.getDecoderState().getJpegScan().Components.length; ++i2) {
                int n4 = this.getDecoderState().getJpegScan().Components[i2];
                int n5 = this.a(n4);
                JpegComponentInfo jpegComponentInfo = this.getDecoderState().getJpegFrame().getComponentInfos()[n5];
                jpegComponentInfo.setMCUBlocks((jpegComponentInfo.getH() & 0xFF) * (jpegComponentInfo.getV() & 0xFF));
                jpegComponentInfo.setMCUWidth(jpegComponentInfo.getH() & 0xFF);
                jpegComponentInfo.setMCUHeight(jpegComponentInfo.getV() & 0xFF);
                int n6 = jpegComponentInfo.getMCUBlocks();
                while (n6-- > 0) {
                    int n7 = this.getDecoderState().getJpegScan().getBlocksInMcu();
                    this.getDecoderState().getJpegScan().setBlocksInMcu(n7 + 1);
                    this.getDecoderState().getJpegScan().getMCUMembership()[n7] = n5;
                }
            }
        }
        this.getEntropyDecoder().initializeScan();
    }

    public void startPass() {
        this.getDecoderState().setTotaliMCURows(JpegUtils.divRoundUp(this.getDecoderState().getJpegFrame().getY() & 0xFFFF, this.getDecoderState().getJpegFrame().getVmax() * JpegConstants.BlockSize));
        if (this.c.getJpegScan().Components.length > 1) {
            this.c.setMCURowsPeriMCURow(1);
        } else {
            int n2 = this.c.getJpegScan().getMCUMembership()[0];
            JpegComponentInfo jpegComponentInfo = this.c.getJpegFrame().getComponentInfos()[n2];
            this.c.setMCURowsPeriMCURow(jpegComponentInfo.getV() & 0xFF);
        }
    }

    public void unpack(byte[][][] byArray, int n2, boolean bl2) {
        this.f = new IDCT(this.getDecoderState());
        int n3 = JpegUtils.roundUp(this.c.getJpegFrame().getX() & 0xFFFF, JpegConstants.BlockSize * this.c.getJpegFrame().getHmax());
        for (int i2 = 0; i2 < this.getDecoderState().getJpegFrame().getComponentInfos().length; ++i2) {
            JpegComponentInfo jpegComponentInfo = this.getDecoderState().getJpegFrame().getComponentInfos()[i2];
            int n4 = bl2 ? jpegComponentInfo.getLastRowHeight() : jpegComponentInfo.getV() & 0xFF;
            for (int i3 = 0; i3 < n4; ++i3) {
                for (int i4 = 0; i4 < jpegComponentInfo.WidthInBlocks; ++i4) {
                    byte[][] byArray2 = JpegBufferHelper.blockSquare(this.f.inverse(this.d[i2][n2 * (jpegComponentInfo.getV() & 0xFF) + i3][i4].getData(), jpegComponentInfo.getId() & 0xFF));
                    int n5 = JpegConstants.BlockSize * i4;
                    int n6 = JpegConstants.BlockSize * (i3 + n2 * (jpegComponentInfo.getV() & 0xFF));
                    for (int i5 = 0; i5 < byArray2.length; ++i5) {
                        FastCopy.copy(byArray2[i5], 0, byArray[0][i2], (n6 + i5) * n3 + n5, byArray2[i5].length);
                    }
                }
            }
        }
    }

    private int a(int n2) {
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.getDecoderState().getJpegFrame().getComponentInfos().length; ++i2) {
            if ((this.getDecoderState().getJpegFrame().getComponentInfos()[i2].getId() & 0xFF) != n2) continue;
            n3 = i2;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new FrameworkException(StringExtensions.Empty, new ImageLoadException("Corrupted Jpeg scan component id definition. Cannot load image."));
        }
        return n3;
    }

    private static JpegRangeLimitTable a() {
        int n2;
        JpegRangeLimitTable jpegRangeLimitTable = new JpegRangeLimitTable();
        byte[] byArray = new byte[1408];
        int n3 = 256;
        jpegRangeLimitTable.setSampleRangeLimitOffset(n3);
        for (n2 = 0; n2 <= 255; ++n2) {
            byArray[n3 + n2] = (byte)n2;
        }
        n3 += 128;
        for (n2 = 128; n2 < 512; ++n2) {
            byArray[n3 + n2] = -1;
        }
        ArrayHelper.clear(byArray, n3 + 512, 384);
        jpegRangeLimitTable.setTable(byArray);
        return jpegRangeLimitTable;
    }

    private void b() {
        Object object;
        int n2;
        int n3;
        int[] nArray = new int[this.getDecoderState().getJpegScan().Components.length];
        for (n3 = 0; n3 < this.getDecoderState().getJpegScan().Components.length; ++n3) {
            nArray[n3] = n2 = this.a(this.getDecoderState().getJpegScan().Components[n3]);
            object = this.c.getJpegFrame().getComponentInfos()[n2];
            if (this.d[n2] != null) continue;
            this.d[n2] = JpegBufferHelper.allocBlocksDataBlock((((JpegComponentInfo)object).getV() & 0xFF) * this.c.getTotaliMCURows(), (((JpegComponentInfo)object).getH() & 0xFF) * this.c.getMcusPerRow());
        }
        for (n3 = 0; n3 < this.c.getTotaliMCURows(); ++n3) {
            for (n2 = 0; n2 < this.c.getMcusPerRow(); ++n2) {
                int n4;
                int n5;
                JpegComponentInfo jpegComponentInfo;
                int n6;
                object = new JpegMCU(this.c.getJpegScan().getBlocksInMcu());
                int n7 = 0;
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    jpegComponentInfo = this.c.getJpegFrame().getComponentInfos()[nArray[n6]];
                    for (n5 = 0; n5 < jpegComponentInfo.getMCUHeight(); ++n5) {
                        for (n4 = 0; n4 < jpegComponentInfo.getMCUWidth(); ++n4) {
                            DataBlock dataBlock = this.d[nArray[n6]][n3 * this.c.getMCURowsPeriMCURow() * jpegComponentInfo.getMCUHeight() + n5][n4 + n2 * jpegComponentInfo.getMCUWidth()];
                            if (dataBlock == null) {
                                dataBlock = new DataBlock();
                            }
                            ((JpegMCU)object).getBlocks()[n7] = dataBlock;
                            ++n7;
                        }
                    }
                }
                if (!this.e.decodeMCU((JpegMCU)object)) {
                    return;
                }
                n7 = 0;
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    jpegComponentInfo = this.c.getJpegFrame().getComponentInfos()[nArray[n6]];
                    for (n5 = 0; n5 < jpegComponentInfo.getMCUHeight(); ++n5) {
                        for (n4 = 0; n4 < jpegComponentInfo.getMCUWidth(); ++n4) {
                            this.d[nArray[n6]][n3 * this.c.getMCURowsPeriMCURow() * jpegComponentInfo.getMCUHeight() + n5][n4 + n2 * jpegComponentInfo.getMCUWidth()] = ((JpegMCU)object).getBlocks()[n7];
                            ++n7;
                        }
                    }
                }
            }
        }
    }

    private void c() {
        int n2 = this.c.getJpegScan().getMCUMembership()[0];
        JpegComponentInfo jpegComponentInfo = this.c.getJpegFrame().getComponentInfos()[n2];
        if (this.d[n2] == null) {
            this.d[n2] = JpegBufferHelper.allocBlocksDataBlock((jpegComponentInfo.getV() & 0xFF) * this.c.getTotaliMCURows(), (jpegComponentInfo.getH() & 0xFF) * this.c.getMcusPerRow());
        }
        for (int i2 = 0; i2 < jpegComponentInfo.getHeightInBlocks(); ++i2) {
            for (int i3 = 0; i3 < jpegComponentInfo.WidthInBlocks; ++i3) {
                JpegMCU jpegMCU = new JpegMCU(1);
                DataBlock dataBlock = this.d[n2][i2][i3];
                if (dataBlock == null) {
                    dataBlock = new DataBlock();
                }
                jpegMCU.getBlocks()[0] = dataBlock;
                boolean bl2 = this.e.decodeMCU(jpegMCU);
                this.d[n2][i2][i3] = jpegMCU.getBlocks()[0];
            }
        }
    }
}

