/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringMode;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.ExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffTagsSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class TiffImage
extends RasterImage {
    private final List<TiffFrame> a = new List();
    private int b = 18761;
    private TiffFrame c;

    public TiffImage(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("frame");
        }
        this.addFrame(tiffFrame);
        this.b = tiffFrame.getFrameOptions().getByteOrder();
        this.setActiveFrame(tiffFrame);
        this.setDataLoader(new TiffActiveFrameLoader(this));
    }

    public TiffImage(TiffFrame[] tiffFrameArray) {
        if (tiffFrameArray == null) {
            throw new ArgumentNullException("frames");
        }
        if (tiffFrameArray.length > 0) {
            this.addFrames(tiffFrameArray);
            this.setActiveFrame(tiffFrameArray[0]);
            this.b = this.getActiveFrame().getFrameOptions().getByteOrder();
        }
        this.setDataLoader(new TiffActiveFrameLoader(this));
    }

    public int getByteOrder() {
        this.verifyNotDisposed();
        return this.b;
    }

    public void setByteOrder(int n2) {
        this.verifyNotDisposed();
        this.b = n2;
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            return super.getHorizontalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getXresolution().getValue();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            this.setResolution(d2, super.getVerticalResolution());
        } else {
            this.setResolution(d2, this.getActiveFrame().getFrameOptions().getYresolution().getValue());
        }
    }

    @Override
    public DitheringMode getDitheringSettings() {
        return this.c.getDitheringSettings();
    }

    @Override
    public void setDitheringSettings(DitheringMode ditheringMode) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            this.a.get_Item(i2).setDitheringSettings(ditheringMode);
        }
    }

    @Override
    public double getVerticalResolution() {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            return super.getVerticalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getYresolution().getValue();
    }

    @Override
    public void setVerticalResolution(double d2) {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            this.setResolution(super.getHorizontalResolution(), d2);
        } else {
            this.setResolution(this.getActiveFrame().getFrameOptions().getXresolution().getValue(), d2);
        }
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getBitsPerPixel();
    }

    public TiffFrame getActiveFrame() {
        this.verifyNotDisposed();
        if (this.c == null) {
            throw new InvalidOperationException("TiffImageException: There is no active frame selected.");
        }
        return this.c;
    }

    public void setActiveFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame != null && tiffFrame.getContainer() != this) {
            throw new InvalidOperationException("TiffImageException: The active frame cannot be set as it belongs to another image.");
        }
        this.c = tiffFrame;
    }

    public TiffFrame[] getFrames() {
        this.verifyNotDisposed();
        TiffFrame[] tiffFrameArray = new TiffFrame[this.a.size()];
        this.a.copyToTArray((TiffFrame[])tiffFrameArray, 0);
        return tiffFrameArray;
    }

    @Override
    public int getHeight() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getHeight();
    }

    @Override
    public int getWidth() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getWidth();
    }

    @Override
    public final boolean isCached() {
        TiffFrame[] tiffFrameArray = this.getFrames();
        boolean bl2 = true;
        for (int i2 = 0; i2 < tiffFrameArray.length && (bl2 = tiffFrameArray[i2].isCached()); ++i2) {
        }
        return bl2;
    }

    public ExifData getExifData() {
        return this.c.getExifData();
    }

    public void setExifData(ExifData exifData) {
        this.c.setExifData(exifData);
    }

    @Override
    public void setResolution(double d2, double d3) {
        this.getActiveFrame().getFrameOptions().setXresolution(new TiffRational(Convert.toUInt32(d2)));
        this.getActiveFrame().getFrameOptions().setYresolution(new TiffRational(Convert.toUInt32(d3)));
    }

    @Override
    public final void cacheData() {
        TiffFrame[] tiffFrameArray = this.getFrames();
        for (int i2 = 0; i2 < tiffFrameArray.length; ++i2) {
            tiffFrameArray[i2].cacheData();
        }
    }

    @Override
    public void rotateFlip(int n2) {
        this.getActiveFrame().rotateFlip(n2);
    }

    public void rotateFlipAll(int n2) {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.rotateFlip(n2);
        }
    }

    @Override
    public void rotate(float f2, boolean bl2, int n2) {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.rotate(f2, bl2, n2);
        }
    }

    public void addFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame.getContainer() != null && tiffFrame.getContainer() != this) {
            throw new InvalidOperationException("TiffImageException: Frame belongs to other image");
        }
        tiffFrame.setContainer(this);
        this.a.addItem(tiffFrame);
    }

    public void add(TiffImage tiffImage) {
        int n2 = tiffImage.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = tiffImage.a.get_Item(i2);
            if (tiffFrame == null) continue;
            TiffFrame tiffFrame2 = TiffFrame.copyFrame(tiffFrame);
            this.addFrame(tiffFrame2);
        }
    }

    public void addFrames(TiffFrame[] tiffFrameArray) {
        this.verifyNotDisposed();
        if (tiffFrameArray == null) {
            throw new ArgumentNullException("TiffImageException: Frames parameter is null");
        }
        for (int i2 = 0; i2 < tiffFrameArray.length; ++i2) {
            if (tiffFrameArray[i2] == null) {
                throw new ArgumentNullException("TiffImageException: Frame is null or not TiffFrame type");
            }
            if (tiffFrameArray[i2].getContainer() == this || tiffFrameArray[i2].getContainer() == null) continue;
            throw new ArgumentException("TiffImageException: Frame belongs to other image");
        }
        for (TiffFrame tiffFrame : tiffFrameArray) {
            tiffFrame.setContainer(this);
        }
        this.a.addRange(Array.toGenericList(tiffFrameArray));
    }

    public void insertFrame(int n2, TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new ArgumentNullException("TiffImageException: Frame Is NULL");
        }
        if (tiffFrame.getContainer() != this && tiffFrame.getContainer() != null) {
            throw new ArgumentException("TiffImageException: Frame belongs to other image");
        }
        if (this.a.size() <= n2 || n2 < 0) {
            throw new ArgumentException("TiffImageException: Invalid index or Frame is null");
        }
        this.a.insertItem(n2, tiffFrame);
    }

    public TiffFrame removeFrame(int n2) {
        TiffFrame tiffFrame;
        this.verifyNotDisposed();
        if (n2 >= 0 && n2 < this.a.size()) {
            tiffFrame = this.a.get_Item(n2);
            if (this.getActiveFrame() == tiffFrame) {
                throw new InvalidOperationException("TiffImageException: Unable to remove current frame");
            }
            if (this.a.size() <= 1) {
                throw new InvalidOperationException("TiffImageException: Unable to remove last frame");
            }
        } else {
            throw new ArgumentException("TiffImageException: Invalid index");
        }
        this.a.removeAt(n2);
        return tiffFrame;
    }

    public void removeFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new ArgumentNullException("frame");
        }
        if (tiffFrame.getContainer() != this) {
            throw new ArgumentOutOfRangeException("frame", "The frame does not belong to the current TIFF image.");
        }
        if (this.getActiveFrame() == tiffFrame) {
            throw new InvalidOperationException("TiffImageException: Unable to remove current frame");
        }
        if (this.a.size() <= 1) {
            throw new InvalidOperationException("TiffImageException: Unable to remove last frame");
        }
        this.a.removeItem(tiffFrame);
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
            tiffFrame.resize(n2, n3, n4);
        }
    }

    public void resizeWidthProportionally(int n2, int n3) {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
        }
    }

    public void resizeHeightProportionally(int n2, int n3) {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
        }
    }

    public void resizeProportional(int n2, int n3, int n4) {
        double d2 = Operators.castToDouble(n2, 9) / (double)this.getWidth();
        double d3 = Operators.castToDouble(n3, 9) / (double)this.getHeight();
        for (TiffFrame tiffFrame : this.a) {
            int n5 = Operators.castToInt32(d2 * (double)tiffFrame.getWidth() + 0.5, 14);
            int n6 = Operators.castToInt32(d3 * (double)tiffFrame.getHeight() + 0.5, 14);
            tiffFrame.resize(n5, n6, n4);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            try {
                this.a.get_Item(i2).crop(rectangle.Clone());
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidOperationException(StringExtensions.concat("ImageException: Can't crop image. Frame index: ", Int32Extensions.toString(i2)), runtimeException);
            }
        }
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            try {
                this.a.get_Item(i2).crop(n2, n3, n4, n5);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidOperationException(StringExtensions.concat("ImageException: Can't crop image. Frame index: ", Int32Extensions.toString(i2)), runtimeException);
            }
        }
    }

    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        TiffStream tiffStream = TiffStreamFactory.getTiffStream(stream, this.b);
        this.a(tiffStream);
    }

    @Override
    protected void releaseManagedResources() {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
            tiffFrame.dispose();
        }
        this.a.clear();
        this.c = null;
        super.releaseManagedResources();
    }

    @Override
    protected void savePixelsInternal(Rectangle rectangle, int[] nArray) {
        this.verifyNotDisposed();
        this.getActiveFrame().saveArgb32Pixels(rectangle.Clone(), nArray);
    }

    private void a(TiffStream tiffStream) {
        this.verifyNotDisposed();
        tiffStream.getStream().seek(0L, 0);
        TiffTagsSaver.writeTiffHeader(tiffStream);
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            TiffFrame tiffFrame = this.a.get_Item(i2);
            TiffFrame.save(tiffFrame, tiffStream, i2 == this.a.size() - 1, tiffFrame.getFrameOptions(), tiffFrame.getExifData());
        }
    }

    private static class TiffActiveFrameLoader
    implements IRasterImageArgb32PixelLoader {
        private final TiffImage a;

        public TiffActiveFrameLoader(TiffImage tiffImage) {
            this.a = tiffImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return this.a.c.isRawDataAvailable();
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return this.a.c.getRawDataSettings();
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            this.a.verifyNotDisposed();
            this.a.getActiveFrame().loadPartialArgb32Pixels(rectangle.Clone(), iPartialArgb32PixelLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            this.a.verifyNotDisposed();
            this.a.c.loadRawData(rectangle.Clone(), rawDataSettings, iPartialRawDataLoader);
        }
    }
}

