/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.IO.BinaryReader;
import com.aspose.html.internal.ms.System.IO.Stream;

public class IccProfileReader {
    private BinaryReader a;

    public IccProfileReader(Stream stream) {
        stream.setPosition(0L);
        this.a = new BinaryReader(stream);
    }

    public byte read8() {
        return (byte)(this.a.readByte() & 0xFF);
    }

    public int read16() {
        return IccProfileReader.a(this.a.readUInt16());
    }

    public long read32() {
        return IccProfileReader.a(this.a.readUInt32());
    }

    public long read64() {
        return IccProfileReader.b(this.a.readUInt64());
    }

    public byte[] readBytes(int n2) {
        return this.a.readBytes(n2);
    }

    public float[] read8fArray(int n2) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)(this.read8() & 0xFF) / 255.0f;
        }
        return fArray;
    }

    public float[] read16fArray(int n2) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)(this.read16() & 0xFFFF) / 65535.0f;
        }
        return fArray;
    }

    public float[] read32fArray(int n2) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)((int)(this.read32() & 0xFFFFFFFFL)) / 65536.0f;
        }
        return fArray;
    }

    public long[] read32nArray(int n2) {
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = this.read32();
        }
        return lArray;
    }

    public void close() {
        this.a.close();
    }

    private static int a(int n2) {
        byte[] byArray = BitConverter.getBytesUInt16(n2);
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    private static long a(long l2) {
        byte[] byArray = BitConverter.getBytesUInt32(l2);
        Array.reverse(Array.boxing(byArray));
        return BitConverter.toUInt32(byArray, 0);
    }

    private static long b(long l2) {
        byte[] byArray = BitConverter.getBytesUInt64(l2);
        Array.reverse(Array.boxing(byArray));
        return BitConverter.toUInt64(byArray, 0);
    }

    public long getPosition() {
        return this.a.getBaseStream().getPosition();
    }

    public void setPosition(long l2) {
        this.a.getBaseStream().setPosition(l2);
    }
}

