/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.FilterType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLineHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;

public class ImageLine {
    public final ImageInfo imgInfo;
    private int a = 0;
    public final int[] scanline;
    public final byte[] scanlineb;
    protected FilterType filterUsed;
    final int channels;
    final int bitDepth;
    final int elementsPerRow;
    public final SampleType sampleType;
    public final boolean samplesUnpacked;

    public ImageLine(ImageInfo imageInfo) {
        this(imageInfo, SampleType.INT, false);
    }

    public ImageLine(ImageInfo imageInfo, SampleType sampleType, boolean bl2) {
        this(imageInfo, sampleType, bl2, null, null);
    }

    ImageLine(ImageInfo imageInfo, SampleType sampleType, boolean bl2, int[] nArray, byte[] byArray) {
        this.imgInfo = imageInfo;
        this.channels = imageInfo.channels;
        this.bitDepth = imageInfo.bitDepth;
        this.filterUsed = FilterType.FILTER_UNKNOWN;
        this.sampleType = sampleType;
        this.samplesUnpacked = bl2 || !imageInfo.packed;
        int n2 = this.elementsPerRow = this.samplesUnpacked ? imageInfo.samplesPerRow : imageInfo.samplesPerRowPacked;
        if (sampleType == SampleType.INT) {
            this.scanline = nArray != null ? nArray : new int[this.elementsPerRow];
            this.scanlineb = null;
        } else if (sampleType == SampleType.BYTE) {
            this.scanlineb = byArray != null ? byArray : new byte[this.elementsPerRow];
            this.scanline = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
        this.a = -1;
    }

    public int getRown() {
        return this.a;
    }

    public void setRown(int n2) {
        this.a = n2;
    }

    static void unpackInplaceInt(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl2) {
        int n2;
        int n3;
        int n4 = imageInfo.bitDepth;
        if (n4 >= 8) {
            return;
        }
        int n5 = ImageLineHelper.getMaskForPackedFormatsLs(n4);
        int n6 = 8 - n4;
        int n7 = 8 * imageInfo.samplesPerRowPacked - n4 * imageInfo.samplesPerRow;
        if (n7 != 8) {
            n3 = n5 << n7;
            n2 = n7;
        } else {
            n3 = n5;
            n2 = 0;
        }
        int n8 = imageInfo.samplesPerRowPacked - 1;
        for (int i2 = imageInfo.samplesPerRow - 1; i2 >= 0; --i2) {
            int n9 = (nArray[n8] & n3) >> n2;
            if (bl2) {
                n9 <<= n6;
            }
            nArray2[i2] = n9;
            n3 <<= n4;
            if ((n2 += n4) != 8) continue;
            n3 = n5;
            n2 = 0;
            --n8;
        }
    }

    static void packInplaceInt(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl2) {
        int n2 = imageInfo.bitDepth;
        if (n2 >= 8) {
            return;
        }
        int n3 = ImageLineHelper.getMaskForPackedFormatsLs(n2);
        int n4 = 8 - n2;
        int n5 = 8 - n2;
        int n6 = 8 - n2;
        int n7 = nArray[0];
        nArray2[0] = 0;
        if (bl2) {
            n7 >>= n4;
        }
        n7 = (n7 & n3) << n6;
        int n8 = 0;
        for (int i2 = 0; i2 < imageInfo.samplesPerRow; ++i2) {
            int n9 = nArray[i2];
            if (bl2) {
                n9 >>= n4;
            }
            int n10 = n8++;
            nArray2[n10] = nArray2[n10] | (n9 & n3) << n6;
            if ((n6 -= n2) >= 0) continue;
            n6 = n5;
            if (n8 >= nArray2.length) continue;
            nArray2[n8] = 0;
        }
        nArray2[0] = nArray2[0] | n7;
    }

    static void unpackInplaceByte(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl2) {
        int n2;
        int n3;
        int n4 = imageInfo.bitDepth;
        if (n4 >= 8) {
            return;
        }
        int n5 = ImageLineHelper.getMaskForPackedFormatsLs(n4);
        int n6 = 8 - n4;
        int n7 = 8 * imageInfo.samplesPerRowPacked - n4 * imageInfo.samplesPerRow;
        if (n7 != 8) {
            n3 = n5 << n7;
            n2 = n7;
        } else {
            n3 = n5;
            n2 = 0;
        }
        int n8 = imageInfo.samplesPerRowPacked - 1;
        for (int i2 = imageInfo.samplesPerRow - 1; i2 >= 0; --i2) {
            int n9 = (byArray[n8] & n3) >> n2;
            if (bl2) {
                n9 <<= n6;
            }
            byArray2[i2] = (byte)n9;
            n3 <<= n4;
            if ((n2 += n4) != 8) continue;
            n3 = n5;
            n2 = 0;
            --n8;
        }
    }

    static void packInplaceByte(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl2) {
        int n2 = imageInfo.bitDepth;
        if (n2 >= 8) {
            return;
        }
        int n3 = ImageLineHelper.getMaskForPackedFormatsLs(n2);
        int n4 = 8 - n2;
        int n5 = 8 - n2;
        int n6 = 8 - n2;
        int n7 = byArray[0];
        byArray2[0] = 0;
        if (bl2) {
            n7 >>= n4;
        }
        n7 = (n7 & n3) << n6;
        int n8 = 0;
        for (int i2 = 0; i2 < imageInfo.samplesPerRow; ++i2) {
            int n9 = byArray[i2];
            if (bl2) {
                n9 >>= n4;
            }
            int n10 = n8++;
            byArray2[n10] = (byte)(byArray2[n10] | (n9 & n3) << n6);
            if ((n6 -= n2) >= 0) continue;
            n6 = n5;
            if (n8 >= byArray2.length) continue;
            byArray2[n8] = 0;
        }
        byArray2[0] = (byte)(byArray2[0] | n7);
    }

    public ImageLine unpackToNewImageLine() {
        ImageLine imageLine = new ImageLine(this.imgInfo, this.sampleType, true);
        if (this.sampleType == SampleType.INT) {
            ImageLine.unpackInplaceInt(this.imgInfo, this.scanline, imageLine.scanline, false);
        } else {
            ImageLine.unpackInplaceByte(this.imgInfo, this.scanlineb, imageLine.scanlineb, false);
        }
        return imageLine;
    }

    public ImageLine packToNewImageLine() {
        ImageLine imageLine = new ImageLine(this.imgInfo, this.sampleType, false);
        if (this.sampleType == SampleType.INT) {
            ImageLine.packInplaceInt(this.imgInfo, this.scanline, imageLine.scanline, false);
        } else {
            ImageLine.packInplaceByte(this.imgInfo, this.scanlineb, imageLine.scanlineb, false);
        }
        return imageLine;
    }

    public FilterType getFilterUsed() {
        return this.filterUsed;
    }

    public void setFilterUsed(FilterType filterType) {
        this.filterUsed = filterType;
    }

    public int[] getScanlineInt() {
        return this.scanline;
    }

    public byte[] getScanlineByte() {
        return this.scanlineb;
    }

    public String toString() {
        return "row=" + this.a + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + (this.scanline != null ? this.scanline.length : 0);
    }

    public static void showLineInfo(ImageLine imageLine) {
    }

    public static enum SampleType {
        INT,
        BYTE;

    }
}

