/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkMultiple;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class PngChunkSPLT
extends PngChunkMultiple {
    public static final String ID = "sPLT";
    private String a;
    private int b;
    private int[] c;

    public PngChunkSPLT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            imageOutputStream.write(PngHelperInternal.Latin1.getBytes(this.a));
            imageOutputStream.write(0);
            imageOutputStream.write((byte)this.b);
            int n2 = this.getNentries();
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (this.b == 8) {
                        PngHelperInternal.writeByte(imageOutputStream, (byte)this.c[i2 * 5 + i3]);
                        continue;
                    }
                    PngHelperInternal.writeInt2(imageOutputStream, this.c[i2 * 5 + i3]);
                }
                PngHelperInternal.writeInt2(imageOutputStream, this.c[i2 * 5 + 4]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray.length, false);
            chunkRaw.data = byArray;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < chunkRaw.data.length; ++n2) {
            if (chunkRaw.data[n2] != 0) continue;
            n3 = n2;
            break;
        }
        if (n3 <= 0 || n3 > chunkRaw.data.length - 2) {
            throw new PngjException("bad sPLT chunk: no separator found");
        }
        this.a = PngHelperInternal.Latin1.getString(chunkRaw.data, 0, n3);
        this.b = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3 + 1);
        n2 = (chunkRaw.data.length - (n3 += 2)) / (this.b == 8 ? 6 : 10);
        this.c = new int[n2 * 5];
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.b == 8) {
                n8 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
                n7 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
                n6 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
                n5 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n3++);
            } else {
                n8 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3);
                n7 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3 += 2);
                n6 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3 += 2);
                n5 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3 += 2);
                n3 += 2;
            }
            int n9 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n3);
            n3 += 2;
            this.c[n4++] = n8;
            this.c[n4++] = n7;
            this.c[n4++] = n6;
            this.c[n4++] = n5;
            this.c[n4++] = n9;
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSPLT pngChunkSPLT = (PngChunkSPLT)pngChunk;
        this.a = pngChunkSPLT.a;
        this.b = pngChunkSPLT.b;
        this.c = new int[pngChunkSPLT.c.length];
        System.arraycopy(pngChunkSPLT.c, 0, this.c, 0, this.c.length);
    }

    public int getNentries() {
        return this.c.length / 5;
    }

    public String getPalName() {
        return this.a;
    }

    public void setPalName(String string) {
        this.a = string;
    }

    public int getSampledepth() {
        return this.b;
    }

    public void setSampledepth(int n2) {
        this.b = n2;
    }

    public int[] getPalette() {
        return this.c;
    }

    public void setPalette(int[] nArray) {
        this.c = nArray;
    }
}

