/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.asn1.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetStringParser;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1SequenceParser;
import com.aspose.html.internal.ms.core.bc.asn1.DERIA5String;
import com.aspose.html.internal.ms.core.bc.asn1.cms.Evidence;
import com.aspose.html.internal.ms.core.bc.asn1.cms.MetaData;
import java.io.IOException;

public class TimeStampedDataParser {
    private ASN1Integer version;
    private DERIA5String dataUri;
    private MetaData metaData;
    private ASN1OctetStringParser content;
    private Evidence temporalEvidence;
    private ASN1SequenceParser parser;

    private TimeStampedDataParser(ASN1SequenceParser aSN1SequenceParser) throws IOException {
        this.parser = aSN1SequenceParser;
        this.version = ASN1Integer.getInstance(aSN1SequenceParser.readObject());
        ASN1Encodable aSN1Encodable = aSN1SequenceParser.readObject();
        if (aSN1Encodable instanceof DERIA5String) {
            this.dataUri = DERIA5String.getInstance(aSN1Encodable);
            aSN1Encodable = aSN1SequenceParser.readObject();
        }
        if (aSN1Encodable instanceof MetaData || aSN1Encodable instanceof ASN1SequenceParser) {
            this.metaData = MetaData.getInstance(aSN1Encodable.toASN1Primitive());
            aSN1Encodable = aSN1SequenceParser.readObject();
        }
        if (aSN1Encodable instanceof ASN1OctetStringParser) {
            this.content = (ASN1OctetStringParser)aSN1Encodable;
        }
    }

    public static TimeStampedDataParser getInstance(Object object) throws IOException {
        if (object instanceof ASN1Sequence) {
            return new TimeStampedDataParser(((ASN1Sequence)object).parser());
        }
        if (object instanceof ASN1SequenceParser) {
            return new TimeStampedDataParser((ASN1SequenceParser)object);
        }
        return null;
    }

    public int getVersion() {
        return this.version.getValue().intValue();
    }

    public DERIA5String getDataUri() {
        return this.dataUri;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ASN1OctetStringParser getContent() {
        return this.content;
    }

    public Evidence getTemporalEvidence() throws IOException {
        if (this.temporalEvidence == null) {
            this.temporalEvidence = Evidence.getInstance(this.parser.readObject().toASN1Primitive());
        }
        return this.temporalEvidence;
    }
}

