/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.CMPObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PBMParameter;
import com.aspose.html.internal.ms.core.bc.asn1.iana.IANAObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACValuesCalculator;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.MacCalculator;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.PBEMacCalculatorProvider;
import com.aspose.html.internal.ms.core.bc.operator.RuntimeOperatorException;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class PKMACBuilder
implements PBEMacCalculatorProvider {
    private AlgorithmIdentifier owf;
    private int iterationCount;
    private AlgorithmIdentifier mac;
    private int saltLength = 20;
    private SecureRandom random;
    private PKMACValuesCalculator calculator;
    private PBMParameter parameters;
    private int maxIterations;

    public PKMACBuilder(PKMACValuesCalculator pKMACValuesCalculator) {
        this(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), 1000, new AlgorithmIdentifier(IANAObjectIdentifiers.hmacSHA1, DERNull.INSTANCE), pKMACValuesCalculator);
    }

    public PKMACBuilder(PKMACValuesCalculator pKMACValuesCalculator, int n2) {
        this.maxIterations = n2;
        this.calculator = pKMACValuesCalculator;
    }

    private PKMACBuilder(AlgorithmIdentifier algorithmIdentifier, int n2, AlgorithmIdentifier algorithmIdentifier2, PKMACValuesCalculator pKMACValuesCalculator) {
        this.owf = algorithmIdentifier;
        this.iterationCount = n2;
        this.mac = algorithmIdentifier2;
        this.calculator = pKMACValuesCalculator;
    }

    public PKMACBuilder setSaltLength(int n2) {
        if (n2 < 8) {
            throw new IllegalArgumentException("salt length must be at least 8 bytes");
        }
        this.saltLength = n2;
        return this;
    }

    public PKMACBuilder setIterationCount(int n2) {
        if (n2 < 100) {
            throw new IllegalArgumentException("iteration count must be at least 100");
        }
        this.checkIterationCountCeiling(n2);
        this.iterationCount = n2;
        return this;
    }

    public PKMACBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PKMACBuilder setParameters(PBMParameter pBMParameter) {
        this.checkIterationCountCeiling(pBMParameter.getIterationCount().getValue().intValue());
        this.parameters = pBMParameter;
        return this;
    }

    public MacCalculator get(AlgorithmIdentifier algorithmIdentifier, char[] cArray) throws OperatorCreationException {
        if (!CMPObjectIdentifiers.passwordBasedMac.equals(algorithmIdentifier.getAlgorithm())) {
            throw new OperatorCreationException("protection algorithm not mac based");
        }
        this.setParameters(PBMParameter.getInstance(algorithmIdentifier.getParameters()));
        try {
            return this.build(cArray);
        }
        catch (CRMFException cRMFException) {
            throw new OperatorCreationException(cRMFException.getMessage(), cRMFException.getCause());
        }
    }

    public MacCalculator build(char[] cArray) throws CRMFException {
        if (this.parameters != null) {
            return this.genCalculator(this.parameters, cArray);
        }
        byte[] byArray = new byte[this.saltLength];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray);
        return this.genCalculator(new PBMParameter(byArray, this.owf, this.iterationCount, this.mac), cArray);
    }

    private void checkIterationCountCeiling(int n2) {
        if (this.maxIterations > 0 && n2 > this.maxIterations) {
            throw new IllegalArgumentException("iteration count exceeds limit (" + n2 + " > " + this.maxIterations + ")");
        }
    }

    private MacCalculator genCalculator(final PBMParameter pBMParameter, char[] cArray) throws CRMFException {
        byte[] byArray = Strings.toUTF8ByteArray(cArray);
        byte[] byArray2 = pBMParameter.getSalt().getOctets();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        this.calculator.setup(pBMParameter.getOwf(), pBMParameter.getMac());
        int n2 = pBMParameter.getIterationCount().getValue().intValue();
        do {
            byArray3 = this.calculator.calculateDigest(byArray3);
        } while (--n2 > 0);
        final byte[] byArray4 = byArray3;
        return new MacCalculator(){
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(CMPObjectIdentifiers.passwordBasedMac, pBMParameter);
            }

            public GenericKey getKey() {
                return new GenericKey(this.getAlgorithmIdentifier(), byArray4);
            }

            public OutputStream getOutputStream() {
                return this.bOut;
            }

            public byte[] getMac() {
                try {
                    return PKMACBuilder.this.calculator.calculateMac(byArray4, this.bOut.toByteArray());
                }
                catch (CRMFException cRMFException) {
                    throw new RuntimeOperatorException("exception calculating mac: " + cRMFException.getMessage(), cRMFException);
                }
            }
        };
    }
}

