/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKMACValue;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACBuilder;
import com.aspose.html.internal.ms.core.bc.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueGenerator {
    private PKMACBuilder builder;

    public PKMACValueGenerator(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public PKMACValue generate(char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return new PKMACValue(macCalculator.getAlgorithmIdentifier(), new DERBitString(macCalculator.getMac()));
    }
}

