/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertReqMsg;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CertificateRequestMessage;
import com.aspose.html.internal.ms.core.bc.cert.crmf.jcajce.CRMFHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.pkix.SubjectPublicKeyInfoChecker;
import java.io.IOException;
import java.security.Provider;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class JcaCertificateRequestMessage
extends CertificateRequestMessage {
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JcaCertificateRequestMessage(byte[] byArray) {
        this(CertReqMsg.getInstance(byArray));
    }

    public JcaCertificateRequestMessage(CertificateRequestMessage certificateRequestMessage) {
        this(certificateRequestMessage.toASN1Structure());
    }

    public JcaCertificateRequestMessage(CertReqMsg certReqMsg) {
        super(certReqMsg);
    }

    public JcaCertificateRequestMessage setProvider(String string) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JcaCertificateRequestMessage setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public X500Principal getSubjectX500Principal() {
        X500Name x500Name = this.getCertTemplate().getSubject();
        if (x500Name != null) {
            try {
                return new X500Principal(x500Name.getEncoded("DER"));
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to construct DER encoding of name: " + iOException.getMessage());
            }
        }
        return null;
    }

    public PublicKey getPublicKey() throws CRMFException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getCertTemplate().getPublicKey();
        SubjectPublicKeyInfoChecker.checkInfo(subjectPublicKeyInfo);
        if (subjectPublicKeyInfo != null) {
            return this.helper.toPublicKey(subjectPublicKeyInfo);
        }
        return null;
    }
}

