/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.dane;

import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntry;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntryFetcherFactory;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntrySelector;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntrySelectorFactory;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEException;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory dANEEntryFetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = dANEEntryFetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String string) throws DANEException {
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        List list = this.fetcherFactory.build(dANEEntrySelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(list.size());
        for (DANEEntry dANEEntry : list) {
            if (!dANEEntrySelector.match(dANEEntry)) continue;
            arrayList.add(dANEEntry.getCertificate());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

