/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509ContentVerifierProviderBuilder;
import com.aspose.html.internal.ms.core.bc.operator.ContentVerifierProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JcaContentVerifierProviderBuilder;
import com.aspose.html.internal.ms.core.bc.pkix.SubjectPublicKeyInfoChecker;
import java.security.Provider;
import java.security.cert.CertificateException;

public class JcaX509ContentVerifierProviderBuilder
implements X509ContentVerifierProviderBuilder {
    private JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();

    public JcaX509ContentVerifierProviderBuilder setProvider(Provider provider) {
        this.builder.setProvider(provider);
        return this;
    }

    public JcaX509ContentVerifierProviderBuilder setProvider(String string) {
        this.builder.setProvider(string);
        return this;
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        SubjectPublicKeyInfoChecker.checkInfo(subjectPublicKeyInfo);
        return this.builder.build(subjectPublicKeyInfo);
    }

    public ContentVerifierProvider build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        try {
            return this.builder.build(x509CertificateHolder);
        }
        catch (CertificateException certificateException) {
            throw new OperatorCreationException("Unable to process certificate: " + certificateException.getMessage(), certificateException);
        }
    }
}

