/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParametersID;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParametersIndex;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricECKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private Algorithm algorithm;
    private ECDomainParameters domainParameters;

    AsymmetricECKey(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = eCDomainParameters;
    }

    AsymmetricECKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID) {
        this(algorithm, ECDomainParametersIndex.lookupDomainParameters(eCDomainParametersID));
    }

    AsymmetricECKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this(algorithm, ECDomainParameters.decodeCurveParameters(algorithmIdentifier));
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public ECDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }
}

