/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcMqvBasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreementParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsEC;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcMqvPublicParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcNamedDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.util.BigIntegers;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EcDHAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final BasicAgreement dh;
    private final T parameter;

    EcDHAgreement(BasicAgreement basicAgreement, T t2) {
        this.dh = basicAgreement;
        this.parameter = t2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
        BigInteger bigInteger;
        Object object;
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EcDHAgreement.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
        int n2 = this.dh.getFieldSize();
        if (this.dh instanceof EcMqvBasicAgreement) {
            object = ((FipsEC.MQVAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
            bigInteger = this.dh.calculateAgreement(new EcMqvPublicParameters(ecPublicKeyParameters, new EcPublicKeyParameters(((AsymmetricECPublicKey)object).getW(), EcDHAgreement.getDomainParams(((AsymmetricECKey)object).getDomainParameters()))));
        } else {
            bigInteger = this.dh.calculateAgreement(ecPublicKeyParameters);
        }
        object = BigIntegers.asUnsignedByteArray(n2, bigInteger);
        return FipsKDF.processZBytes((byte[])object, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }
}

