/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.KDFCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.KDFOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.SCryptImpl;
import com.aspose.html.internal.ms.core.bc.util.Arrays;

public final class Scrypt {
    public static final ParametersBuilder ALGORITHM = new ParametersBuilder(new FipsAlgorithm("scrypt"));

    private Scrypt() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KDFFactory
    implements KDFOperatorFactory<Parameters> {
        @Override
        public KDFCalculator<Parameters> createKDFCalculator(final Parameters parameters) {
            return new KDFCalculator<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public void generateBytes(byte[] byArray) {
                    byte[] byArray2 = SCryptImpl.generate(parameters.seed, parameters.salt, parameters.n, parameters.r, parameters.p, byArray.length);
                    System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                    Arrays.fill(byArray2, (byte)0);
                }

                @Override
                public void generateBytes(byte[] byArray, int n2, int n3) {
                    byte[] byArray2 = SCryptImpl.generate(parameters.seed, parameters.salt, parameters.n, parameters.r, parameters.p, n3);
                    System.arraycopy(byArray2, 0, byArray, n2, n3);
                    Arrays.fill(byArray2, (byte)0);
                }
            };
        }
    }

    public static final class Parameters
    extends FipsParameters {
        final int n;
        final int r;
        final int p;
        final byte[] salt;
        final byte[] seed;

        private Parameters(int n2, byte[] byArray, int n3, int n4, byte[] byArray2) {
            super(ALGORITHM.getAlgorithm());
            this.seed = byArray;
            this.n = n2;
            this.r = n3;
            this.p = n4;
            this.salt = byArray2;
        }
    }

    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }

        public Parameters using(byte[] byArray, int n2, int n3, int n4, byte[] byArray2) {
            return new Parameters(n2, Arrays.clone(byArray2), n3, n4, Arrays.clone(byArray));
        }

        public Parameters using(byte[] byArray, int n2, int n3, int n4, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(n2, passwordConverter.convert(cArray), n3, n4, Arrays.clone(byArray));
        }
    }
}

